/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Map;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.chararray.CharArrayCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;

public class TextBufferTracker
extends NodeListener
implements TextBufferListener {
    private static Map<URL, TextBufferTracker> instances = new Maps.WeakHashMap();
    private static Edit[] NO_EDITS = new Edit[0];
    private URL url;
    private int initialId = -1;
    private int initialLength = -1;
    private boolean reloading = false;
    private char[] removedText;
    private char[] insertedText;
    private volatile int version = 0;
    private volatile Edit[] edits = NO_EDITS;
    private static final Object LOCK = new Object();
    private static final Log LOG = new Log("tracker");
    private static final int LIMIT = 32768;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextBufferTracker getTracker(final TextNode node) {
        TextBufferTracker newTracker;
        assert (LOG.trace("getting tracker for {0}", (Object)node));
        URL url = node.getURL();
        Object object = LOCK;
        synchronized (object) {
            TextBufferTracker tracker = instances.get(url);
            if (tracker != null) {
                return tracker;
            }
            newTracker = new TextBufferTracker(node);
            instances.put(url, newTracker);
        }
        node.runUnderReadLock(new Runnable(){

            @Override
            public void run() {
                if (newTracker.initialLength < 0 && node.isOpen()) {
                    newTracker.nodeOpened(node);
                }
            }
        });
        return newTracker;
    }

    private TextBufferTracker(TextNode node) {
        assert (LOG.trace("creating tracker for {0}", (Object)node));
        this.url = node.getURL();
        node.addNodeListener(this);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean adjustOffsetLength(int offset, int length, int version, int[] adjusted) {
        int latestVersion = this.version;
        boolean modified = false;
        for (int i = version; i < latestVersion; ++i) {
            Edit edit = this.edits[i];
            if (edit.offset > offset + length) continue;
            if (edit.delta >= 0) {
                if (edit.offset <= offset) {
                    offset += edit.delta;
                    continue;
                }
                length += edit.delta;
                modified = true;
                continue;
            }
            int delta = edit.delta;
            int endOffset = edit.offset - delta;
            if (edit.offset <= offset) {
                if (endOffset <= offset) {
                    offset += delta;
                    continue;
                }
                int excess = endOffset - offset;
                offset += delta + excess;
                if ((length -= excess) < 0) {
                    length = 0;
                }
                modified = true;
                continue;
            }
            int markOffset = offset + length;
            if (endOffset <= markOffset) {
                length += delta;
            } else {
                int excess = endOffset - markOffset;
                if ((length -= excess) < 0) {
                    length = 0;
                }
            }
            modified = true;
        }
        adjusted[0] = offset;
        adjusted[1] = length;
        return modified;
    }

    public boolean isModified(int version) {
        return this.id(version) != this.id(this.version);
    }

    public boolean isModified(int offset, int length, int version) {
        return this.adjustOffsetLength(offset, length, version, new int[]{offset, length});
    }

    public String toString() {
        int version = this.version;
        return "tracker (" + URLFileSystem.getPlatformPathName((URL)this.url) + ", version " + version + ", id " + this.id(version) + ", length " + this.length(version) + ")";
    }

    @Override
    public void nodeWillOpen(NodeEvent e) {
        assert (LOG.trace("node will open, {0}", (Object)this));
    }

    @Override
    public void nodeOpened(NodeEvent event) {
        assert (LOG.trace("node opened, {0}", (Object)this));
        this.nodeOpened((TextNode)event.getNode());
    }

    private void nodeOpened(TextNode node) {
        TextBuffer buffer = node.acquireTextBuffer();
        assert (TextBufferTracker.isLocked(buffer));
        if (this.initialLength < 0) {
            this.initialId = buffer.getChangeId();
            this.initialLength = buffer.getLength();
        } else {
            this.reconcileReload(buffer, null, null);
        }
        buffer.addTextBufferListener((TextBufferListener)this);
        assert (LOG.trace("started tracking {2}, initial id {0}, initial length {1}", this.initialId, this.initialLength, (Object)this));
    }

    @Override
    public void nodeDirtyStateChanged(NodeEvent e, boolean dirty) {
        assert (LOG.trace("node dirty state changed to {0}, {1}", dirty, (Object)this));
    }

    @Override
    public void nodeWillClose(NodeEvent e) {
        assert (LOG.trace("node will close, {0}", (Object)this));
    }

    @Override
    public void nodeClosed(NodeEvent event) {
        assert (LOG.trace("node closed, {0}", (Object)this));
        TextNode node = (TextNode)event.getNode();
        node.removeTextBufferListener(this);
        this.reloading = false;
        this.removedText = null;
        this.insertedText = null;
    }

    @Override
    public void nodeWillBeSaved(NodeEvent e) {
        assert (LOG.trace("node will be saved, {0}", (Object)this));
    }

    @Override
    public void nodeSaved(NodeEvent e) {
        assert (LOG.trace("node saved, {0}", (Object)this));
    }

    @Override
    public void nodeReverted(NodeEvent e) {
        assert (LOG.trace("node reverted, {0}", (Object)this));
    }

    @Override
    public void nodeDeleted(NodeEvent e) {
        assert (LOG.trace("node deleted, {0}", (Object)this));
    }

    @Override
    public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        assert (LOG.trace("node renamed to {0}, {1}", (Object)this));
        this.url = newURL;
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 1: {
                assert (LOG.trace("buffer attribute EOL changed, id {0}, {1}", buffer.getChangeId(), (Object)this));
                break;
            }
            case 5: {
                assert (LOG.trace("buffer attribute modified changed to {1}, id {0}, {2}", buffer.getChangeId(), (Object)buffer.isModified(), (Object)this));
                break;
            }
            case 2: {
                assert (LOG.trace("buffer attribute read-only changed to {1}, id {0}, {2}", buffer.getChangeId(), (Object)buffer.isReadOnly(), (Object)this));
                break;
            }
            case 3: {
                assert (LOG.trace("buffer reload start, id {0}, {1}", buffer.getChangeId(), (Object)this));
                this.reloading = true;
                break;
            }
            case 4: {
                assert (LOG.trace("buffer reload end, id {0}, {1}", buffer.getChangeId(), (Object)this));
                this.reconcileReload(buffer, this.removedText, this.insertedText);
                this.reloading = false;
                this.removedText = null;
                this.insertedText = null;
                break;
            }
            default: {
                assert (LOG.trace("buffer attribute {0} changed, id {1}, {2}", attribute, buffer.getChangeId(), (Object)this));
                break;
            }
        }
    }

    private void reconcileReload(TextBuffer buffer, char[] removedText, char[] insertedText) {
        assert (TextBufferTracker.isLocked(buffer));
        int version = this.version;
        int newId = buffer.getChangeId();
        for (int previousVersion = version; previousVersion >= 0; --previousVersion) {
            if (newId != this.id(previousVersion)) continue;
            int distance = version - previousVersion;
            LOG.trace("reloading to tracked id {0}, reversing {1} edits", newId, distance);
            if (version + distance >= this.edits.length) {
                Edit[] copy = new Edit[version * 2 + 4];
                System.arraycopy(this.edits, 0, copy, 0, version);
                this.edits = copy;
            }
            int index = version;
            while (index-- > previousVersion) {
                int offset = this.edits[index].offset;
                int delta = -this.edits[index].delta;
                int id = index > 0 ? this.edits[index - 1].id : this.initialId;
                int length = index > 0 ? this.edits[index - 1].length : this.initialLength;
                this.edits[version] = new Edit(offset, delta, id, length);
                ++version;
            }
            this.version = version;
            assert (this.verifyLength(buffer));
            return;
        }
        if (insertedText != null) {
            if (removedText != null) {
                assert (LOG.trace("buffer normal reload: inserting {0} at {1}, id {2}, {3}", insertedText.length, newId, (Object)this));
                this.replaceText(buffer, removedText, insertedText);
            } else {
                int length = this.length(version);
                if (length == 0) {
                    assert (LOG.trace("buffer normal load: inserting {0} at 0, id {1}, {2})", insertedText.length, newId, (Object)this));
                    this.textEdited(buffer, 0, insertedText.length);
                } else {
                    int difference = buffer.getLength() - length;
                    assert (LOG.trace("gc reload, no digest match: adjusting length by {0}, id {1}, {2})", difference, newId, (Object)this));
                    if (difference != 0) {
                        this.textEdited(buffer, 0, difference);
                    }
                }
            }
        } else if (removedText != null) {
            assert (LOG.trace("normal reload to empty: removing {0} at 0, id {1}, {2})", removedText.length, newId, (Object)this));
            this.textEdited(buffer, 0, -removedText.length);
        } else {
            int difference = buffer.getLength() - this.length(version);
            assert (LOG.trace("node reopen, no digest match: adjusting length by {0}, id {1}, {2})", difference, newId, (Object)this));
            if (difference != 0) {
                this.textEdited(buffer, 0, difference);
            }
        }
        assert (this.verifyLength(buffer));
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        if (this.reloading) {
            assert (LOG.trace("reloading: buffer inserting {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this));
            assert (offset == 0);
            assert (count == text.length);
            this.insertedText = text;
        } else {
            assert (LOG.trace("buffer inserting {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this));
            this.textEdited(buffer, offset, count);
            assert (this.verifyLength(buffer));
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        if (this.reloading) {
            assert (LOG.trace("reloading: buffer removing {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this));
            assert (offset == 0);
            assert (count == text.length);
            this.removedText = text;
        } else {
            assert (LOG.trace("buffer removing {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this));
            this.textEdited(buffer, offset, -count);
            assert (this.verifyLength(buffer));
        }
    }

    private void textEdited(TextBuffer buffer, int offset, int count) {
        assert (TextBufferTracker.isLocked(buffer));
        int version = this.version;
        if (version == this.edits.length) {
            Edit[] copy = new Edit[version * 2 + 4];
            System.arraycopy(this.edits, 0, copy, 0, version);
            this.edits = copy;
        }
        this.edits[version] = new Edit(offset, count, buffer.getChangeId(), buffer.getLength());
        this.version = version + 1;
    }

    private static boolean isLocked(TextBuffer buffer) {
        switch (buffer.getLockStatus()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean verifyLength(TextBuffer buffer) {
        int bufferLength = buffer.getLength();
        int[] adjusted = new int[2];
        this.adjustOffsetLength(this.initialLength, 0, 0, adjusted);
        int derivedLength = adjusted[0];
        if (bufferLength != derivedLength) {
            Log.error((String)"buffer length {0}, derived length {1}, initial length {2}, initial id {3}, edits {4}", (Object)bufferLength, (Object)derivedLength, (Object)this.initialLength, (Object)this.initialId, (Object)this.edits);
        }
        return true;
    }

    private int id(int version) {
        if (version == 0) {
            return this.initialId;
        }
        return this.edits[version - 1].id;
    }

    private int length(int version) {
        if (version == 0) {
            return this.initialLength;
        }
        return this.edits[version - 1].length;
    }

    public void replaceText(TextBuffer buffer, char[] fromText, char[] toText) {
        if (fromText.length > 0 && toText.length > 0 && fromText.length < 32768 && toText.length < 32768) {
            SequenceCompareModel model = null;
            try {
                model = (SequenceCompareModel)CompareModelFactory.createCompareModel((CompareContributor)new CharArrayCompareContributor(fromText), (CompareContributor)new CharArrayCompareContributor(toText), (CompareType)CompareType.CHARACTER);
            }
            catch (CompareFailedException cfe) {
                cfe.printStackTrace();
            }
            if (model != null) {
                SequenceCompareDifference[] blocks = model.getDifferenceBlocks();
                int count = blocks.length;
                if (count > 0) {
                    for (int i = count - 1; i >= 0; --i) {
                        SequenceCompareDifference thing = blocks[i];
                        int fromBlockOffset = thing.getStart(ContributorKind.FIRST);
                        int fromBlockLength = thing.getLength(ContributorKind.FIRST);
                        int toBlockLength = thing.getLength(ContributorKind.SECOND);
                        if (fromBlockLength > 0) {
                            this.textEdited(buffer, fromBlockOffset, -fromBlockLength);
                        }
                        if (toBlockLength <= 0) continue;
                        this.textEdited(buffer, fromBlockOffset, toBlockLength);
                    }
                }
                return;
            }
        }
        if (fromText.length > 0) {
            this.textEdited(buffer, 0, -fromText.length);
        }
        if (toText.length > 0) {
            this.textEdited(buffer, 0, toText.length);
        }
    }

    private static class Edit {
        public int offset;
        public int delta;
        public int id;
        public int length;

        public Edit(int offset, int delta, int id, int length) {
            this.offset = offset;
            this.delta = delta;
            this.id = id;
            this.length = length;
        }

        public Edit(Edit edit) {
            this(edit.offset, edit.delta, edit.id, edit.length);
        }

        public String toString() {
            return "{" + this.delta + " at " + this.offset + " (length " + this.length + ", id" + this.id + ")}";
        }
    }
}

