/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;

public class ProjectMigrator
extends HashStructureNodeMigrator {
    public static final String MIGRATOR_NAME = Project.class.getName();

    private final void super_callHelpersMigrate(MigrationInfo info, TraversableContext context) {
        super.callHelpersMigrate(info, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callHelpersMigrate(final MigrationInfo info, final TraversableContext context) {
        Node node = info.getNode();
        if (node instanceof Project) {
            Project project = (Project)node;
            try {
                project.getTransientProperties().put("blockOpenOnDirty", Boolean.TRUE);
                project.applyBatchChanges(new Runnable(){

                    @Override
                    public void run() {
                        ProjectMigrator.this.super_callHelpersMigrate(info, context);
                    }
                });
            }
            finally {
                project.getTransientProperties().remove("blockOpenOnDirty");
            }
        } else {
            super.callHelpersMigrate(info, context);
        }
    }

    @Override
    String getRootQname() {
        return "jpr:project";
    }

    @Override
    protected void preMigrate(MigrationInfo[] infos, TraversableContext context) {
        for (MigrationInfo info : infos) {
            Node node = info.getNode();
            node.setMigrating();
            NodeMigrationTracker.getInstance().startTracking(node.getURL());
        }
    }

    @Override
    protected void postMigrate(MigrationInfo[] infos, TraversableContext context) {
        for (MigrationInfo info : infos) {
            Node node = info.getNode();
            MigrationInfo.MigrationStatus migrationStatus = info.getMigrationStatus();
            if (migrationStatus == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
                NodeMigrationTracker.getInstance().startTracking(node.getURL());
                info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
            } else if (migrationStatus == MigrationInfo.MIGRATION_DONE) {
                NodeMigrationTracker.getInstance().stopTracking(node.getURL());
            }
            boolean fireEvents = info.getMigrationStatus() == MigrationInfo.MIGRATION_DONE;
            node.unsetMigrating(fireEvents);
        }
    }

    @Override
    protected String getMsg(MigrationInfo[] infos) {
        String product = IdeArb.format(390, Version.NAME_SHORT, Version.VER);
        if (infos.length > 1) {
            return IdeArb.format(394, product);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(392, fname, product);
    }

    @Override
    protected String getTitle() {
        return IdeArb.getString(391);
    }

    @Override
    protected String getSummaryMsg(MigrationInfo[] infos) {
        if (infos.length > 1) {
            return IdeArb.getString(395);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(393, fname);
    }

    @Override
    protected float getWeight() {
        return 0.01f;
    }
}

