/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

@Deprecated
public final class OwnerMap
extends HashStructureAdapter {
    static final String NODE_URL = "nodeURL";
    private static final String NODE_CLASS = "nodeClass";
    private static final String OWNER_URL = "ownerURL";
    private static final String OWNER_CLASS = "ownerClass";
    private final HashStructureNode _project;
    private final HashMap _ownerMap = new HashMap();
    private HashMap _referenceMap;
    private List _ownedChildren;
    static final String OWNER_MAP = "ownerMap";

    private OwnerMap(HashStructureNode project) {
        super(project._hash);
        this._project = project;
    }

    public static OwnerMap getInstance(HashStructureNode project) {
        Map tprops = project.getTransientProperties();
        OwnerMap ownerMap = (OwnerMap)((Object)tprops.get("owner-map"));
        if (ownerMap == null) {
            ownerMap = new OwnerMap(project);
            ownerMap.initOwnerMap();
            tprops.put("owner-map", ownerMap);
        }
        return ownerMap;
    }

    public static OwnerMap getInstance(Project project) {
        return OwnerMap.getInstance((HashStructureNode)project);
    }

    public static boolean addToOwnerMap(Project project, Node node, Node ownerContainer) {
        if (project.ensureOpen()) {
            if (OwnerMap.getInstance(project).add(node, ownerContainer)) {
                return true;
            }
            project.setSubDirtyableOwner(node, project);
            project.markDirty(true);
            node.attach(project);
            return true;
        }
        return false;
    }

    public List getOwnedNodes(URL ownerContainerURL, URLPath srcRoots, String dirRelPath) {
        boolean isRootRelPath = "".equals(dirRelPath);
        ArrayList<Node> ownedNodes = new ArrayList<Node>();
        ListStructure list = this.getOwnerMapListStructure();
        for (HashStructure hash : list) {
            URL ownerURL;
            String nodeRelPath;
            URL nodeURL = hash.getURL(NODE_URL);
            if (nodeURL == null || (nodeRelPath = srcRoots.toRelativePath(nodeURL)) == null || (!isRootRelPath || nodeRelPath.indexOf(47) >= 0) && (nodeRelPath.length() <= dirRelPath.length() || !nodeRelPath.startsWith(dirRelPath) || nodeRelPath.indexOf(47, dirRelPath.length()) >= 0) || !URLFileSystem.equals((URL)(ownerURL = hash.getURL(OWNER_URL)), (URL)ownerContainerURL)) continue;
            try {
                Node node = NodeFactory.findOrCreate(nodeURL);
                ownedNodes.add(node);
            }
            catch (Exception e) {}
        }
        return ownedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Node node, Node ownerContainer) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List ownedChildren = this.getOwnedChildrenList();
            if (ownedChildren.contains(node)) {
                return true;
            }
            this.addToOwnerMap(new Reference(node), this.getOwnerReference(ownerContainer));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            this._ownerMap.clear();
            this._ownedChildren = null;
            this._referenceMap = null;
        }
    }

    void sortOwnerMap() {
        ListStructure list = this.getOwnerMapListStructure();
        list.internalPreprsist();
    }

    void initOwnerMap() {
        assert (this._ownerMap.size() == 0);
        ListStructure list = this.getOwnerMapListStructure();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            try {
                HashStructure hash = (HashStructure)iter.next();
                Reference nodeRef = OwnerMap.getReference(hash, NODE_URL, NODE_CLASS);
                Reference ownerRef = OwnerMap.getReference(hash, OWNER_URL, OWNER_CLASS);
                this.addToOwnerMapDirectly(nodeRef, ownerRef);
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getMap() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownerMap.size() == 0) {
                return null;
            }
            HashMap ownerMap = new HashMap();
            for (Map.Entry entry : this._ownerMap.entrySet()) {
                Node node = NodeFactory.find((URL)entry.getKey());
                if (node == null) continue;
                ownerMap.put(new Reference(node), entry.getValue());
            }
            return ownerMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsOwnedChild(Element child) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownerMap.size() == 0) {
                return false;
            }
            if (child instanceof Node) {
                return this._ownerMap.get(((Node)child).getURL()) != null;
            }
        }
        return false;
    }

    HashMap getReferenceMap() {
        if (this._referenceMap == null) {
            this._referenceMap = new HashMap();
            Map ownerMap = this.getMap();
            if (ownerMap != null) {
                for (Map.Entry entry : ownerMap.entrySet()) {
                    Reference ref = (Reference)entry.getValue();
                    Node container = ref.getData();
                    this._referenceMap.put(container, ref);
                    container.attach(this._project);
                }
            }
        }
        return this._referenceMap;
    }

    private ListStructure getOwnerMapListStructure() {
        return this._hash.getOrCreateListStructure(OWNER_MAP);
    }

    private static Reference getReference(HashStructure hash, String urlProperty, String classProperty) throws ClassNotFoundException {
        URL url = hash.getURL(urlProperty);
        String type = hash.getString(classProperty);
        return new Reference(url, type);
    }

    private static void putReference(HashStructure hash, String urlProperty, String classProperty, Reference ref) {
        Node node = ref.getData();
        hash.putURL(urlProperty, node != null ? node.getURL() : null);
        hash.putString(classProperty, node != null ? node.getClass().getName() : null);
    }

    private void addToOwnerMap(final Reference nodeRef, final Reference ownerRef) {
        this.addToOwnerMapDirectly(nodeRef, ownerRef);
        URL nodeURL = nodeRef.getURL();
        final ListStructure list = this.getOwnerMapListStructure();
        Iterator iter = list.iterator();
        HashStructure hash = null;
        while (iter.hasNext()) {
            HashStructure curHash = (HashStructure)iter.next();
            URL curNodeURL = curHash.getURL(NODE_URL);
            if (!ModelUtil.areEqual((Object)nodeURL, (Object)curNodeURL)) continue;
            hash = curHash;
            break;
        }
        final HashStructure finalHash = hash;
        this._hash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                HashStructure actualHash = finalHash;
                if (actualHash == null) {
                    actualHash = HashStructure.newInstance();
                    list.add((Object)actualHash);
                }
                OwnerMap.putReference(actualHash, OwnerMap.NODE_URL, OwnerMap.NODE_CLASS, nodeRef);
                OwnerMap.putReference(actualHash, OwnerMap.OWNER_URL, OwnerMap.OWNER_CLASS, ownerRef);
            }
        });
    }

    private void addToOwnerMapDirectly(Reference nodeRef, Reference ownerRef) {
        Node node = nodeRef.getData();
        this._ownerMap.put(node.getURL(), ownerRef);
        this.addOwnedChild(node);
    }

    private void removeFromOwnerMap(URL nodeURL) {
        this._ownerMap.remove(nodeURL);
        ListStructure list = this.getOwnerMapListStructure();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            HashStructure curHash = (HashStructure)iter.next();
            URL curNodeURL = curHash.getURL(NODE_URL);
            if (!ModelUtil.areEqual((Object)nodeURL, (Object)curNodeURL)) continue;
            iter.remove();
        }
    }

    private void addOwnedChild(Node child) {
        if (this._ownedChildren == null) {
            this._ownedChildren = new ArrayList();
        }
        if (!this._ownedChildren.contains(child)) {
            this._ownedChildren.add(child);
            child.attach(this._project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNodeRenamed(URL oldURL, Node node, Node owner) {
        if (owner != null) {
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                this.removeFromOwnerMap(oldURL);
                this.addToOwnerMap(new Reference(node), this.getOwnerReference(owner));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyOwnedChildrenListTo(List list) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List ownedChildren = this.getOwnedChildrenList();
            if (ownedChildren.size() > 0) {
                list.addAll(ownedChildren);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getContainerOwner(URL url) {
        if (url != null) {
            Reference ref;
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                ref = (Reference)this._ownerMap.get(url);
            }
            if (ref != null) {
                return ref.getData();
            }
        }
        return null;
    }

    Node getContainerOwner(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            return this.getContainerOwner(node.getURL());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getOwnedChildrenList() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownedChildren != null) {
                return this._ownedChildren;
            }
            this._ownedChildren = new ArrayList();
            for (URL url : this._ownerMap.keySet()) {
                try {
                    this.addOwnedChild(NodeFactory.findOrCreate(url));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this._ownedChildren;
    }

    private Reference getOwnerReference(Node container) {
        HashMap referenceMap = this.getReferenceMap();
        Reference reference = (Reference)referenceMap.get(container);
        if (reference == null) {
            reference = new Reference(container);
            referenceMap.put(container, reference);
            container.attach(this._project);
        }
        return reference;
    }

    private Reference findOwnerReference(Node container) {
        HashMap referenceMap = this.getReferenceMap();
        return (Reference)referenceMap.get(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Element element) {
        boolean removeOK = false;
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List ownedChildren = this.getOwnedChildrenList();
            if (ownedChildren.contains(element)) {
                removeOK = ownedChildren.remove(element);
            }
        }
        if (removeOK) {
            this.detachOwnerObserver(element);
            if (element instanceof SubDirtyable) {
                ((SubDirtyable)element).setOwner(null);
            }
            Node node = (Node)element;
            this.removeFromOwnerMap(node.getURL());
            node.detach(this._project);
        }
        if (element instanceof Folder) {
            this.removeOwnedChildren((Folder)element);
        }
    }

    private void detachOwnerObserver(Element element) {
        Node container;
        Reference reference;
        if (element instanceof Node && (reference = this.findOwnerReference(container = (Node)element)) != null) {
            container.detach(this._project);
        }
    }

    public void removeOwnedChildren(Folder owner) {
        ArrayList removals = new ArrayList();
        this.removeOwnedChildren(owner, removals);
        if (removals.size() > 0) {
            UpdateMessage.fireChildrenRemoved(this._project, removals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOwnedChildren(Folder folder, List removals) {
        int lastIndex = removals.size();
        Iterator<Element> children = folder.getChildren();
        if (children != null) {
            while (children.hasNext()) {
                Element child = children.next();
                if (!(child instanceof Folder)) continue;
                if (this.containsOwnedChild(child)) {
                    removals.add(child);
                    continue;
                }
                this.removeOwnedChildren((Folder)child, removals);
            }
        }
        if (!(folder instanceof Node)) {
            return;
        }
        Node container = (Node)((Object)folder);
        Reference reference = this.findOwnerReference(container);
        if (reference != null) {
            ArrayList<URL> removedEntries = new ArrayList<URL>();
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                for (Map.Entry entry : this._ownerMap.entrySet()) {
                    if (entry.getValue() != reference) continue;
                    URL url = (URL)entry.getKey();
                    Node node = NodeFactory.find(url);
                    if (node != null) {
                        removals.add(node);
                        continue;
                    }
                    removedEntries.add(url);
                }
                for (int i = 0; i < removedEntries.size(); ++i) {
                    this.removeFromOwnerMap((URL)removedEntries.get(i));
                }
            }
            if (this._referenceMap != null) {
                this._referenceMap.remove(container);
            }
        }
        int newIndex = removals.size();
        for (int i = lastIndex; i < newIndex; ++i) {
            Node node = (Node)removals.get(i);
            this.removeElement(node);
        }
    }
}

