/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.net.URLFileSystem;

public final class NodeIdentityUtils {
    public static boolean isNodeClass(URL url, Class nodeClass, boolean matchIfEqual) {
        String suffix = NodeIdentityUtils.getSuffix(url);
        return NodeIdentityUtils.getNodeExtensions(nodeClass, matchIfEqual).contains(suffix);
    }

    public static boolean isNodeClass(String name, Class nodeClass, boolean matchIfEqual) {
        String suffix = NodeIdentityUtils.getSuffix(name);
        return NodeIdentityUtils.getNodeExtensions(nodeClass, matchIfEqual).contains(suffix);
    }

    public static boolean isNodeClass(URL url, Class[] nodeClasses, boolean matchIfEqual) {
        String suffix = NodeIdentityUtils.getSuffix(url);
        return NodeIdentityUtils.getNodeExtensions(nodeClasses, matchIfEqual).contains(suffix);
    }

    public static boolean isNodeClass(String name, Class[] nodeClasses, boolean matchIfEqual) {
        String suffix = NodeIdentityUtils.getSuffix(name);
        return NodeIdentityUtils.getNodeExtensions(nodeClasses, matchIfEqual).contains(suffix);
    }

    public static boolean isNodeClass(URL[] urls, Class nodeClass, boolean matchIfEqual) {
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClass, matchIfEqual);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < urls.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(urls[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNodeClass(String[] names, Class nodeClass, boolean matchIfEqual) {
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClass, matchIfEqual);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < names.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(names[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNodeClass(URL[] urls, Class[] nodeClasses, boolean matchIfEqual) {
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClasses, matchIfEqual);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < urls.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(urls[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNodeClass(String[] names, Class[] nodeClasses, boolean matchIfEqual) {
        Set nodeExtensions = NodeIdentityUtils.getNodeExtensions(nodeClasses, matchIfEqual);
        if (!nodeExtensions.isEmpty()) {
            for (int i = 0; i < names.length; ++i) {
                if (!nodeExtensions.contains(NodeIdentityUtils.getSuffix(names[i]))) continue;
                return true;
            }
        }
        return false;
    }

    private static String getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
            suffix = suffix.toLowerCase();
        }
        return suffix;
    }

    private static String getSuffix(String name) {
        int index = name.lastIndexOf(46);
        String suffix = index != -1 ? name.substring(index) : "";
        if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
            suffix = suffix.toLowerCase();
        }
        return suffix;
    }

    private static Set getNodeExtensions(Class nodeClass, boolean matchIfEqual) {
        return NodeIdentityUtils.getNodeExtensions(new Class[]{nodeClass}, matchIfEqual);
    }

    private static Set getNodeExtensions(Class[] nodeClasses, boolean matchIfEqual) {
        ClientSetting settings = ClientSetting.findOrCreate(Ide.getProductID());
        DocumentExtensions docExtensions = (DocumentExtensions)settings.getData("document-extensions-options");
        if (docExtensions == null) {
            docExtensions = new DocumentExtensions();
            settings.putData("document-extensions-options", docExtensions);
        }
        Set nodeExtensions = docExtensions.getNodeExtensions(nodeClasses, matchIfEqual);
        return nodeExtensions;
    }

    private NodeIdentityUtils() {
    }
}

