/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.model.Element;
import oracle.ide.model.FactoryMonitor;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Node2Dom;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.javatools.util.ArrayIterator;
import oracle.javatools.util.Maps;

public final class NodeFactory {
    public static final int NODE_CACHED = UpdateMessage.newMessageID("NodeFactory.NODE_CACHED");
    public static final int NODE_UNCACHED = UpdateMessage.newMessageID("NodeFactory.NODE_UNCACHED");
    private static boolean _suppressNodeCachedNotify = false;
    private static final Map<URL, Node> allNodes = new Maps.ManagedCacheMap(Maps.CacheMap.WEAK, "NodeFactory,items=allNodes");
    private static final Map<URL, Node> loadedNodes = new Maps.ManagedCacheMap(Maps.CacheMap.WEAK, "NodeFactory,items=loadedNodes");
    private static final Map<URL, Node> openedNodes = new Maps.ManagedCacheMap("NodeFactory,items=openedNodes");
    private static final NodeTracker _nodeTracker = new NodeTracker();

    public static Node findOrCreateOrFail(URL url) {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        try {
            return NodeFactory.findOrCreate(url);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Node findOrCreate(URL url) throws IllegalAccessException, InstantiationException {
        return NodeFactory.findOrCreateUsingDefault(url, Recognizer.getDefaultNodeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreate(Class<? extends Node> type, URL url) throws IllegalAccessException, InstantiationException {
        Node node = null;
        if (url != null) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                node = NodeFactory.find(url);
                if (node != null) {
                    return node;
                }
                try {
                    _suppressNodeCachedNotify = true;
                    node = NodeFactory.createImpl(type, url);
                }
                finally {
                    _suppressNodeCachedNotify = false;
                }
            }
            if (node != null) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
        return node;
    }

    public static <T extends Node> T findOrCreateOrFail(Class<T> type, URL url) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        try {
            return (T)NodeFactory.findOrCreate(type, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreateUsingDefault(URL url, Class<? extends Node> defaultNodeType) throws IllegalAccessException, InstantiationException {
        Node node = null;
        if (url != null) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                node = NodeFactory.find(url);
                if (node != null) {
                    return node;
                }
                try {
                    _suppressNodeCachedNotify = true;
                    Iterator iter = Recognizer.getRecognizerIterator(url);
                    while (iter.hasNext()) {
                        Recognizer recognizer = (Recognizer)iter.next();
                        Class<? extends Node> cls = recognizer.recognize(url);
                        if (cls == null || (node = recognizer.create(url, cls)) == null) continue;
                        NodeFactory.cache(url, node, false);
                        break;
                    }
                    if (node == null && defaultNodeType != null) {
                        node = NodeFactory.createImpl(defaultNodeType, url);
                    }
                }
                finally {
                    _suppressNodeCachedNotify = false;
                }
            }
            if (node != null) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node find(URL url) {
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            return allNodes.get(url);
        }
    }

    public static Node findInFolder(Folder folder, URL url) {
        if (folder == null || url == null) {
            return null;
        }
        Iterator<Element> iter = folder.getChildren();
        if (iter == null) {
            return null;
        }
        while (iter.hasNext()) {
            Node node;
            Element child = iter.next();
            if (!(child instanceof Node) || !url.equals((node = (Node)child).getURL())) continue;
            return node;
        }
        return null;
    }

    public static Node clone(Node srcNode, URL dstNodeURL) {
        URL srcNodeURL = srcNode.getURL();
        Class<?> nodeClass = srcNode.getClass();
        try {
            Node dstNode = (Node)nodeClass.newInstance();
            dstNode.setURL(dstNodeURL);
            URLFileSystem.copy((URL)srcNodeURL, (URL)dstNodeURL);
            return dstNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node uncache(URL url) {
        return NodeFactory.uncache(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node uncache(URL url, boolean notify) {
        Node node;
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            node = allNodes.remove(url);
        }
        if (notify) {
            FactoryMonitor.notify(node, NODE_UNCACHED);
        }
        return node;
    }

    public static void recache(URL oldURL, URL newURL, Node node) {
        NodeFactory.recache(oldURL, newURL, node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recache(URL oldURL, URL newURL, Node node, boolean notify) {
        if (!URLFileSystem.equals((URL)oldURL, (URL)newURL)) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                if (oldURL != null) {
                    Node oldNode = NodeFactory.find(oldURL);
                    notify = notify && oldNode != node;
                    NodeFactory.uncache(oldURL, notify);
                }
                if (newURL != null && node != null) {
                    NodeFactory.cache(newURL, node, notify);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Node> getCachedNodes() {
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            Object[] array = new Node[allNodes.size()];
            int i = 0;
            for (Node node : allNodes.values()) {
                if (node == null) continue;
                array[i++] = node;
            }
            return new ArrayIterator(array, 0, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Node> getOpenNodes() {
        Map<URL, Node> map = openedNodes;
        synchronized (map) {
            return Collections.unmodifiableCollection(new HashSet<Node>(openedNodes.values())).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Node> getLoadedNodes() {
        Map<URL, Node> map = loadedNodes;
        synchronized (map) {
            return Collections.unmodifiableCollection(new HashSet<Node>(loadedNodes.values())).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCachedNodeCount() {
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            return allNodes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOpenNodeCount() {
        Map<URL, Node> map = openedNodes;
        synchronized (map) {
            return openedNodes.size();
        }
    }

    public static final void attach(Observer observer, Class<? extends Node> type) {
        FactoryMonitor.attach(observer, type);
    }

    public static final void detach(Observer observer, Class<? extends Node> type) {
        FactoryMonitor.detach(observer, type);
    }

    private NodeFactory() {
    }

    private static Node createImpl(Class type, URL url) throws IllegalAccessException, InstantiationException {
        Node node = (Node)type.newInstance();
        node.setURL(url);
        NodeFactory.cache(url, node, true);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cache(URL url, Node node, boolean notify) {
        Node other = NodeFactory.find(url);
        if (other == null || other != node) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                allNodes.put(url, node);
            }
            if (notify && !_suppressNodeCachedNotify) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
    }

    private static Class recognize(URL url) {
        Iterator iter = Recognizer.getRecognizerIterator(url);
        while (iter.hasNext()) {
            Recognizer recognizer = (Recognizer)iter.next();
            Class<? extends Node> cls = recognizer.recognize(url);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    static {
        Node.addNodeListenerForTypeHierarchy(Node.class, _nodeTracker);
        Object2Dom.registerConverter((ToDomConverter)new Node2Dom());
        URLFileSystem.addExistsTest((URLExistsTest)new URLExistsTest(){

            public boolean urlExists(URL url) {
                return NodeFactory.find(url) != null;
            }
        });
        URLFileSystem.addURLFileSystemListener(null, (URLFileSystemListener)new URLFileSystemListener(){

            public void notifyEvent(URLFileSystemEvent event) {
                Node node;
                if (event.getEventType() == 13 && (node = NodeFactory.find(event.getURL())) != null) {
                    node.urlReadOnlyChanged();
                }
            }
        });
    }

    private static class NodeTracker
    extends NodeListener {
        private NodeTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeLoaded(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            if (url != null) {
                Map map = loadedNodes;
                synchronized (map) {
                    loadedNodes.put(url, node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeUnloaded(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            Map map = loadedNodes;
            synchronized (map) {
                Object curNode = loadedNodes.get(url);
                if (curNode == node) {
                    loadedNodes.remove(url);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeOpened(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            if (url != null) {
                Map map = openedNodes;
                synchronized (map) {
                    openedNodes.put(url, node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeClosed(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            Map map = openedNodes;
            synchronized (map) {
                Object curNode = openedNodes.get(url);
                if (curNode == node) {
                    openedNodes.remove(url);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            Map map;
            Node newNode = NodeFactory.find(newURL);
            if (newNode == null) {
                return;
            }
            if (newNode.isLoaded()) {
                map = loadedNodes;
                synchronized (map) {
                    loadedNodes.remove(oldURL);
                    loadedNodes.put(newURL, newNode);
                }
            }
            if (newNode.isOpen()) {
                map = openedNodes;
                synchronized (map) {
                    openedNodes.remove(oldURL);
                    openedNodes.put(newURL, newNode);
                }
            }
        }
    }

    private static class NodeTypeValidator
    implements Runnable {
        private final Node _node;

        NodeTypeValidator(Node node) {
            this._node = node;
        }

        @Override
        public void run() {
            if (!URLFileSystem.exists((URL)this._node.getURL())) {
                return;
            }
            Class cls = NodeFactory.recognize(this._node.getURL());
        }
    }
}

