/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Version;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ListUtil;

abstract class HashStructureNodeMigrator
extends NodeMigrator {
    HashStructureNodeMigrator() {
        this.addHelper(new NodeMigratorHelper(){

            @Override
            public void migrate(MigrationInfo[] infos, TraversableContext tc) {
            }

            @Override
            public String getNodeMigratorHelperKey() {
                return "oracle.ide.model.Project";
            }
        });
    }

    @Override
    public MigrationInfo getMigrationInfo(Node node) {
        return new HSNodeMigrationInfo(node, this.getHelpers(), this.getRootQname());
    }

    abstract String getRootQname();

    @Override
    protected NodeMigratorHelper[] getHelpers(MigrationInfo info) {
        ArrayList helpers = new ArrayList();
        if (info instanceof HSNodeMigrationInfo) {
            HSNodeMigrationInfo hsInfo = (HSNodeMigrationInfo)info;
            helpers.addAll(hsInfo.getActiveHelpers());
        }
        return helpers.toArray(new NodeMigratorHelper[helpers.size()]);
    }

    private static boolean isSkipMigration(HashStructure hash) {
        ProjectVersion jwsVersion;
        VersionNumber ideVersionNumber;
        if (hash.getBoolean("doNoMigration")) {
            return true;
        }
        return hash.getBoolean("doLimitedMigration") && (ideVersionNumber = new VersionNumber(Version.VER)).isBefore((jwsVersion = new ProjectVersion(hash)).getCurrentVersion(), true);
    }

    private static class HSNodeMigrationInfo
    extends MigrationInfo {
        private final ArrayList _helpers = new ArrayList();
        private final String _rootQname;

        HSNodeMigrationInfo(Node node, NodeMigratorHelper[] helpers, String rootQname) {
            super(node);
            if (helpers != null) {
                this._helpers.addAll(Arrays.asList(helpers));
            }
            this._rootQname = rootQname;
        }

        @Override
        protected void ensureVersionInfo() {
            if (this.getVersionDirectly() == null) {
                this.ensureVersionInfoImpl();
            }
        }

        private void ensureVersionInfoImpl() {
            block25: {
                this.setVersionStatusDirectly(VERSION_UNKNOWN);
                this.setMigrationStatus(MIGRATION_NOT_POSSIBLE);
                this.setVersionDirectly("");
                try {
                    Node node = this.getNode();
                    URL url = node.getURL();
                    StartElementPacket sep = XMLUtil.getXMLRootElement((URL)url);
                    if (sep != null && sep.namespaceURI != null && sep.namespaceURI.length() > 0) {
                        String uriVersion = HSNodeMigrationInfo.getVersionFromNamespaceURI(sep.namespaceURI);
                        if (uriVersion == null) break block25;
                        if (uriVersion.equals("10130") || !uriVersion.matches("^\\d+$")) {
                            HashStructure hash = null;
                            try {
                                HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/project", this._rootQname);
                                hash = (HashStructure)io.load(url);
                            }
                            catch (Exception e) {
                                String msg = IdeArb.format(507, node.getLongLabel(), this.getErrorMessage(e));
                                this.addError(new MigrationInfo.ErrorInformation(msg));
                                return;
                            }
                            ProjectVersion hashVersion = new ProjectVersion(hash);
                            Iterator helpersIter = this._helpers.iterator();
                            while (helpersIter.hasNext()) {
                                int compare;
                                NodeMigratorHelper helper = (NodeMigratorHelper)helpersIter.next();
                                VersionNumber migratorVersion = new VersionNumber(helper.getNodeMigratorHelperVersion());
                                String migratorKey = helper.getNodeMigratorHelperKey();
                                VersionNumber versionInHash = migratorKey != null ? hashVersion.getCurrentVersion(migratorKey) : hashVersion.getCurrentVersion();
                                if (versionInHash == null || (compare = migratorVersion.compareTo(versionInHash)) > 0) continue;
                                if (compare == 0) {
                                    helpersIter.remove();
                                    continue;
                                }
                                helpersIter.remove();
                            }
                            boolean skipMigration = false;
                            if (node instanceof Workspace) {
                                skipMigration = HashStructureNodeMigrator.isSkipMigration(hash);
                            }
                            if (this._helpers.size() > 0 && !skipMigration) {
                                this.setMigrationStatus(MIGRATION_PENDING);
                                this.setVersionStatusDirectly(VERSION_OLDER);
                                this.setVersionDirectly("10.1.3");
                            } else if (node instanceof Workspace) {
                                ListStructure listOfChildren;
                                ArrayList<String> missingProjects = new ArrayList<String>();
                                boolean atLeastOneProjectNeedsMigration = false;
                                if (!skipMigration && (listOfChildren = hash.getListStructure("listOfChildren")) != null) {
                                    for (Object childObj : listOfChildren) {
                                        if (!(childObj instanceof HashStructure)) continue;
                                        HashStructure child = (HashStructure)childObj;
                                        URL projectURL = child.getURL("URL");
                                        if (url == null || !URLFileSystem.hasSuffix((URL)projectURL, (String)".jpr")) continue;
                                        HashStructureIO projectIO = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                                        try {
                                            NodeMigratorHelper[] projectHelpers;
                                            NodeMigrator projectMigrator;
                                            HashStructure projectHash = (HashStructure)projectIO.load(projectURL);
                                            if (HashStructureNodeMigrator.isSkipMigration(projectHash)) continue;
                                            ProjectVersion projectVersion = new ProjectVersion(projectHash);
                                            if (projectVersion.getCurrentVersion() == null && !URLFileSystem.exists((URL)projectURL)) {
                                                missingProjects.add(URLFileSystem.getPlatformPathName((URL)projectURL));
                                                continue;
                                            }
                                            if (atLeastOneProjectNeedsMigration || (projectMigrator = NodeMigrator.getNodeMigrator(Project.class.getName())) == null || (projectHelpers = projectMigrator.getHelpers()).length <= 0) continue;
                                            for (int i = 0; i < projectHelpers.length; ++i) {
                                                String migratorKey;
                                                VersionNumber versionInProject;
                                                NodeMigratorHelper projectHelper = projectHelpers[i];
                                                VersionNumber migratorVersion = new VersionNumber(projectHelper.getNodeMigratorHelperVersion());
                                                int compare = migratorVersion.compareTo(versionInProject = (migratorKey = projectHelper.getNodeMigratorHelperKey()) != null ? projectVersion.getCurrentVersion(migratorKey) : projectVersion.getCurrentVersion());
                                                if (compare <= 0) continue;
                                                atLeastOneProjectNeedsMigration = true;
                                            }
                                        }
                                        catch (Exception e) {
                                            String msg = IdeArb.format(508, URLFileSystem.getPlatformPathName((URL)projectURL), this.getErrorMessage(e));
                                            this.addError(new MigrationInfo.ErrorInformation(msg));
                                            return;
                                        }
                                    }
                                }
                                if (atLeastOneProjectNeedsMigration) {
                                    this.setMigrationStatus(MIGRATION_PENDING);
                                    this.setVersionStatusDirectly(VERSION_OLDER);
                                    this.setVersionDirectly("10.1.3");
                                    if (!missingProjects.isEmpty()) {
                                        this.addError(new MigrationInfo.ErrorInformation(IdeArb.format(missingProjects.size() == 1 ? 503 : 504, node.getShortLabel(), ListUtil.join(missingProjects, (String)"\n")), MigrationInfo.ErrorInformation.ActionType.PROMPT));
                                    }
                                } else if (!missingProjects.isEmpty()) {
                                    this.setMigrationStatus(MIGRATION_PENDING);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                    this.addError(new MigrationInfo.ErrorInformation(IdeArb.format(missingProjects.size() == 1 ? 503 : 504, node.getShortLabel(), ListUtil.join(missingProjects, (String)"\n")), MigrationInfo.ErrorInformation.ActionType.PROMPT));
                                } else {
                                    this.setVersionStatusDirectly(VERSION_CURRENT);
                                    this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                }
                            } else {
                                this.setVersionStatusDirectly(VERSION_CURRENT);
                                this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                            }
                            break block25;
                        }
                        this.setMigrationStatus(MIGRATION_PENDING);
                        this.setVersionStatusDirectly(VERSION_OLDER);
                        this.setVersionDirectly(uriVersion);
                        break block25;
                    }
                    this.setMigrationStatus(MIGRATION_PENDING);
                    this.setVersionStatusDirectly(VERSION_OLDER);
                    this.setVersionDirectly("900");
                }
                catch (FileNotFoundException e) {
                    this.setVersionStatusDirectly(VERSION_CURRENT);
                    this.setMigrationStatus(MIGRATION_NOT_NEEDED);
                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        List getActiveHelpers() {
            return this._helpers;
        }

        String getErrorMessage(Exception e) {
            String msg = e.getMessage();
            if ((msg == null || msg.length() == 0) && e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            if (msg == null || msg.length() == 0) {
                msg = "Unknown problem";
            }
            return msg;
        }

        @Override
        public NodeMigratorHelper[] getHelpers() {
            return this._helpers.toArray(new NodeMigratorHelper[this._helpers.size()]);
        }
    }
}

