/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.GuardedBy;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.javatools.data.HashStructure;

public class DependableFactory {
    private final List<DependableRecognizer> _factories = new CopyOnWriteArrayList<DependableRecognizer>();
    @GuardedBy(value="this")
    private final WeakHashMap<Element, List<DependableEntry>> _cache = new WeakHashMap();

    public void registerFactory(DependableRecognizer factory) {
        this._factories.add(factory);
    }

    public void removeFactory(DependableRecognizer factory) {
        this._factories.remove(factory);
    }

    public boolean hasFactory(Element source) {
        for (DependableRecognizer factory : this._factories) {
            if (!factory.recognize(source)) continue;
            return true;
        }
        return false;
    }

    public synchronized Dependable findOrCreate(Element source, Folder owner) throws IllegalAccessException, InstantiationException {
        if (source == null) {
            return null;
        }
        List<DependableEntry> dependables = this.findList(source);
        Dependable dependable = this.findOwnedBy(owner, dependables);
        if (dependable == null) {
            for (DependableRecognizer factory : this._factories) {
                if (!factory.recognize(source)) continue;
                dependable = factory.create(source, owner);
                if (dependable == null) break;
                this.cache(dependable, source, owner, dependables);
                break;
            }
        }
        return dependable;
    }

    public synchronized Dependable find(Element source) {
        if (source != null) {
            return this.find(source, null);
        }
        return null;
    }

    public synchronized Dependable find(Element source, Folder owner) {
        return this.findOwnedBy(owner, this.findList(source));
    }

    public synchronized Dependable[] findAll(Element source) {
        List<DependableEntry> list = this.findList(source);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator<DependableEntry> iter = list.iterator();
        ArrayList<Dependable> dependables = new ArrayList<Dependable>();
        while (iter.hasNext()) {
            DependableEntry entry = iter.next();
            Dependable dependable = (Dependable)entry.dependable.get();
            if (dependable == null) {
                iter.remove();
            }
            dependables.add(dependable);
        }
        return dependables.toArray(new Dependable[dependables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Dependable dependable) {
        Element source = dependable.getSource();
        Folder owner = dependable.getSourceOwner();
        DependableFactory dependableFactory = this;
        synchronized (dependableFactory) {
            List<DependableEntry> dependables = this.findList(source);
            if (this.findOwnedBy(owner, dependables) == null) {
                this.cache(dependable, source, owner, dependables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(Dependable dependable) {
        Element source = dependable.getSource();
        Folder owner = dependable.getSourceOwner();
        DependableFactory dependableFactory = this;
        synchronized (dependableFactory) {
            List<DependableEntry> dependables = this.findList(source);
            if (dependables != null) {
                Iterator<DependableEntry> iter = dependables.iterator();
                while (iter.hasNext()) {
                    DependableEntry entry = iter.next();
                    Dependable dep = (Dependable)entry.dependable.get();
                    if (dep != null && (entry.owner != owner || !dep.equals(dependable))) continue;
                    iter.remove();
                }
            }
        }
    }

    static HashStructure toHashStructure(Dependable dep) throws Exception {
        Class<?> type = dep.getClass();
        try {
            Method getHashStructure = type.getMethod("getHashStructure", new Class[0]);
            HashStructure hash = (HashStructure)getHashStructure.invoke((Object)dep, new Object[0]);
            return hash;
        }
        catch (NoSuchMethodException e) {
            Method getSourceOwnerURL = type.getMethod("getSourceOwnerURL", null);
            URL sourceOwnerURL = (URL)getSourceOwnerURL.invoke((Object)dep, null);
            Method getSourceURL = type.getMethod("getSourceURL", null);
            URL sourceURL = (URL)getSourceURL.invoke((Object)dep, null);
            HashStructure depHash = HashStructure.newInstance();
            depHash.putString("class", type.getName());
            depHash.putURL("sourceOwnerURL", sourceOwnerURL);
            depHash.putURL("sourceURL", sourceURL);
            return depHash;
        }
    }

    static Dependable toDependable(HashStructure hash) throws Exception {
        try {
            String className = hash.getString("class");
            if (className == null) {
                throw new ClassNotFoundException();
            }
            Object depObj = Class.forName(className).newInstance();
            Class<?> type = depObj.getClass();
            Method setSourceOwnerURL = type.getMethod("setSourceOwnerURL", URL.class);
            URL sourceOwnerURL = hash.getURL("sourceOwnerURL");
            setSourceOwnerURL.invoke(depObj, sourceOwnerURL);
            Method setSourceURL = type.getMethod("setSourceURL", URL.class);
            URL sourceURL = hash.getURL("sourceURL");
            setSourceURL.invoke(depObj, sourceURL);
            Dependable dep = (Dependable)depObj;
            return dep;
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> type = Class.forName("oracle.jdeveloper.deploy.dt.AbstractHashDependable");
                Method createDependable = type.getMethod("createDependable", HashStructure.class);
                Dependable dep = (Dependable)createDependable.invoke(null, hash);
                return dep;
            }
            catch (Exception f) {
                throw e;
            }
        }
    }

    private List<DependableEntry> findList(Element source) {
        return this._cache.get(source);
    }

    private Dependable findOwnedBy(Folder owner, List<DependableEntry> dependables) {
        if (dependables != null) {
            Iterator<DependableEntry> iter = dependables.iterator();
            while (iter.hasNext()) {
                DependableEntry entry = iter.next();
                Dependable dependable = (Dependable)entry.dependable.get();
                if (dependable == null) {
                    iter.remove();
                    continue;
                }
                if (owner != null && entry.owner != owner) continue;
                return dependable;
            }
        }
        return null;
    }

    private void cache(Dependable dependable, Element source, Folder owner, List<DependableEntry> dependables) {
        if (dependables == null) {
            dependables = new ArrayList<DependableEntry>(3);
            this._cache.put(source, dependables);
        }
        dependables.add(new DependableEntry(dependable, owner));
    }

    private static final class DependableEntry {
        private WeakReference<Dependable> dependable;
        private Folder owner;

        public DependableEntry(Dependable dependable, Folder owner) {
            this.dependable = new WeakReference<Dependable>(dependable);
            this.owner = owner;
        }
    }
}

