/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.Project;
import oracle.ide.panels.Navigable;

public abstract class ContentSetProvider {
    private final String _key;
    private final String _shortLabel;

    public ContentSetProvider(String key, String shortLabel) {
        this._key = key;
        this._shortLabel = shortLabel;
    }

    public final String getKey() {
        return this._key;
    }

    public final String getShortLabel() {
        return this._shortLabel;
    }

    public boolean displayFoldersAsPackages() {
        return false;
    }

    public boolean canContainJavaSources() {
        return false;
    }

    public boolean canExtendURLPath(Project project) {
        return true;
    }

    public ContentSetHelper getContentSetHelper() {
        return new ContentSetHelper(this._key);
    }

    public boolean isFlatLevelEnabled() {
        return this.canContainJavaSources();
    }

    public abstract void initContentSet(ContentSet var1, URL var2, Context var3);

    public abstract Navigable getNavigable();

    public String toString() {
        return this._shortLabel;
    }
}

