/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.AsynchronousContentLevelFilter;
import oracle.ide.model.ContentAtom;
import oracle.ide.model.ContentLevelFilter;
import oracle.ide.model.ContentLevelFolder;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetFolder;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.concurrent.AsynchronousCallableCompletionService;
import oracle.ide.model.concurrent.CallableResultHandler;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.CollectionUtil;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;

public abstract class ContentLevel {
    public static final String FLAT_LEVEL = "flat-level";
    public static final String FLAT_LEVEL_ENABLED = "flat-level-enabled";
    public static final String WEBCONTENT_FLAT_LEVEL = "webcontent-flat-level";
    public static final String WEBCONTENT_FLAT_LEVEL_ENABLED = "webcontent-flat-level-enabled";
    public static final String SHOW_ROOT_DIRS = "show-root-dirs";
    public static final String SORT_BY_TYPE = "sort-by-type";
    public static final String SHOW_CONTENT_SET_NAMES = "show-content-set-names";
    public static final String ENABLE_CONTENT_LEVEL_FILTERS = "enable-content-level-filters";
    public static final String ENABLE_WORKING_SETS = "enable-working-sets";
    private boolean _skip;
    private static final String WEB_CONTENT_SET_LOCAL_KEY = "webContentSet";
    private static Comparator _contentLevelDefaultComparator = ContentLevel.getChildrenComparator();
    private static Comparator _packageFirstOrElseDefaultComparator = null;
    private static Comparator _displayableComparator;
    private static Comparator _sortByTypeComparator;
    private static Comparator _contentSetDisplayableComparator;
    private String _shortLabel;
    private String _toolTip;
    private static final CopyOnWriteArrayList<ContentLevelFilter> _filters;
    private static final CopyOnWriteArrayList<AsynchronousContentLevelFilter> _asyncFilters;
    private static final CallableResultHandler<List<Subject>> callableResultHandler;
    private static Comparator _childrenComparator;
    private static int debugLevel;

    private ContentLevel() {
    }

    public static ContentLevel newInstanceForShowDirs(URL url, IntersectedFilters filters, boolean displayFoldersAsPackages) {
        ContentAtom atom = new ContentAtom(url, filters, null);
        atom.setDisplayFoldersAsPackages(displayFoldersAsPackages);
        return new Impl(0, atom, "", "");
    }

    public static ContentLevel newInstanceForHideDirs(ContentSet contentSet, PatternFilters workingSetFilters, boolean displayFoldersAsPackages) {
        ContentAtom[] atoms = ContentAtom.atomize(contentSet, workingSetFilters);
        int n = atoms.length;
        for (int i = 0; i < n; ++i) {
            atoms[i].setDisplayFoldersAsPackages(displayFoldersAsPackages);
        }
        return new Group(atoms);
    }

    public static void initChildren(Context context, List children) {
        if (context != null) {
            Project project = context.getProject();
            ProjectContent projectContent = ProjectContent.getInstance(project);
            if (context.getBoolean(SHOW_CONTENT_SET_NAMES)) {
                ContentLevel.initContentSetFolders(projectContent, context, children);
            } else {
                context.setBoolean(FLAT_LEVEL_ENABLED, true);
                ContentSet allContents = projectContent.getAllContents();
                if (context.getBoolean(SHOW_ROOT_DIRS)) {
                    ContentLevel.initSourceRootFolders(allContents, context, children);
                } else {
                    ContentLevel.initMergedChildren(allContents, context, children);
                }
            }
        }
    }

    private static void initContentSetFolders(ProjectContent projectContent, Context context, List children) {
        ArrayList<ContentSetFolder> contentSetFolders = new ArrayList<ContentSetFolder>();
        HashMap<String, Object> shortLabelToProviders = new HashMap<String, Object>();
        ArrayList<String> keysWithNoRegisteredProvider = new ArrayList<String>();
        ListStructure keys = projectContent.getContentSetList();
        Iterator iter = keys.iterator();
        ContentSetProvider[] providers = ProjectContent.getContentSetProviders();
        int n = providers.length;
        block0: while (iter.hasNext()) {
            String key = (String)iter.next();
            for (int i = 0; i < n; ++i) {
                ContentSetProvider provider = providers[i];
                String curKey = provider.getKey();
                if (!key.equals(curKey)) continue;
                String shortLabel = provider.getShortLabel();
                if (shortLabelToProviders.containsKey(shortLabel)) {
                    Object obj = shortLabelToProviders.get(shortLabel);
                    if (obj instanceof ArrayList) {
                        ((ArrayList)obj).add(provider);
                        continue block0;
                    }
                    if (obj instanceof ContentSetProvider) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(obj);
                        list.add(provider);
                        shortLabelToProviders.put(shortLabel, list);
                        continue block0;
                    }
                    new IllegalStateException("Unexpected object").printStackTrace();
                    continue block0;
                }
                shortLabelToProviders.put(shortLabel, provider);
                continue block0;
            }
            keysWithNoRegisteredProvider.add(key);
        }
        for (Map.Entry entry : shortLabelToProviders.entrySet()) {
            String shortLabel = (String)entry.getKey();
            Object obj = entry.getValue();
            Context contextCopy = new Context(context);
            if (obj instanceof ArrayList) {
                ArrayList list = (ArrayList)obj;
                ContentSet compositeContentSet = new ContentSet(HashStructure.newInstance(), false);
                for (ContentSetProvider provider : list) {
                    ContentLevel.initProviderContext(provider, contextCopy);
                    ContentSet cs = projectContent.getContentSet(provider.getKey());
                    compositeContentSet.addContentSet(cs);
                }
                ContentLevel.addContentSetFolder(compositeContentSet, shortLabel, contentSetFolders, contextCopy);
                continue;
            }
            if (obj instanceof ContentSetProvider) {
                ContentSetProvider provider = (ContentSetProvider)obj;
                ContentLevel.initProviderContext(provider, contextCopy);
                ContentSet cs = projectContent.getContentSet(provider.getKey());
                ContentLevel.addContentSetFolder(cs, shortLabel, contentSetFolders, contextCopy);
                continue;
            }
            new IllegalStateException("Unexpected object").printStackTrace();
        }
        for (String key : keysWithNoRegisteredProvider) {
            int lastSlash = key.lastIndexOf(47);
            int afterLastSlash = lastSlash + 1;
            String leafName = afterLastSlash < key.length() ? key.substring(afterLastSlash) : key.substring(0, lastSlash);
            String label = "<" + leafName + ">";
            ContentSet contentSet = projectContent.getContentSet(key);
            Context contextCopy = new Context(context);
            contextCopy.setBoolean(key, true);
            ContentLevel.addContentSetFolder(contentSet, label, contentSetFolders, contextCopy);
        }
        Collections.sort(contentSetFolders, ContentLevel.getContentSetDisplayableComparator());
        children.addAll(contentSetFolders);
    }

    private static void initProviderContext(ContentSetProvider provider, Context context) {
        String key = provider.getKey();
        context.setBoolean(key, true);
        if (provider.isFlatLevelEnabled()) {
            if (key.contains(WEB_CONTENT_SET_LOCAL_KEY)) {
                context.setBoolean(WEBCONTENT_FLAT_LEVEL_ENABLED, true);
            } else {
                context.setBoolean(FLAT_LEVEL_ENABLED, true);
            }
        }
    }

    private static void addContentSetFolder(ContentSet cs, String label, ArrayList<ContentSetFolder> contentSetFolders, Context context) {
        URLPath urlPath = cs.getAllRootDirs();
        for (URL url : urlPath) {
            if (!URLFileSystem.exists((URL)url)) continue;
            List firstLevel = cs.getFilesAndDirectories("", null, null);
            if (firstLevel.size() > 0) {
                contentSetFolders.add(new ContentSetFolder(cs, label, context));
            }
            return;
        }
    }

    static void initSourceRootFolders(ContentSet contentSet, Context context, List children) {
        ContentLevel[] levels = ContentLevel.extractContentLevels(contentSet, context);
        int n = levels.length;
        URL projectURL = context.getProject().getURL();
        URL projectDirURL = URLFileSystem.getParent((URL)projectURL);
        ContentLevel projectContentLevel = null;
        for (int i = 0; i < n; ++i) {
            ContentLevel level = levels[i];
            if (URLFileSystem.equals((URL)projectDirURL, (URL)level.getDirectoryURL())) {
                projectContentLevel = level;
                continue;
            }
            children.add(level.newFolder(context));
        }
        if (projectContentLevel != null) {
            projectContentLevel.addFlatDirs(context, children);
        }
    }

    static void initMergedChildren(ContentSet contentSet, Context context, List children) {
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        boolean enableWorkingSets = context.getBoolean(ENABLE_WORKING_SETS);
        ContentAtom[] atoms = ContentAtom.atomize(contentSet, project, workspace, enableWorkingSets);
        Group contentLevel = new Group(atoms);
        contentLevel.addFlatDirs(context, children);
    }

    private static ContentLevel[] extractContentLevels(ContentSet contentSet, Context context) {
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        boolean enableWorkingSets = context.getBoolean(ENABLE_WORKING_SETS);
        ContentAtom[] atoms = ContentAtom.atomize(contentSet, project, workspace, enableWorkingSets);
        HashMap<URL, ArrayList<ContentAtom>> rootToAtoms = new HashMap<URL, ArrayList<ContentAtom>>();
        ArrayList<URL> roots = new ArrayList<URL>();
        for (ContentAtom atom : atoms) {
            URL atomContentRoot = atom.getContentRoot();
            if (!URLFileSystem.exists((URL)atomContentRoot)) continue;
            ContentLevel.put(rootToAtoms, roots, atomContentRoot, atom);
        }
        int numLevels = roots.size();
        ContentLevel[] levels = new ContentLevel[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            URL groupRoot = (URL)roots.get(i);
            ArrayList<ContentAtom> atomsList = rootToAtoms.get(groupRoot);
            ContentAtom[] groupAtoms = atomsList.toArray(new ContentAtom[atomsList.size()]);
            levels[i] = new Group(groupAtoms);
        }
        return levels;
    }

    private static final Comparator getPackageFirstOrElseDefaultComparator() {
        if (_packageFirstOrElseDefaultComparator == null) {
            _packageFirstOrElseDefaultComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int sortPackageResult;
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    Element e1 = (Element)o1;
                    Element e2 = (Element)o2;
                    int byFolder = ContentLevel.sortFolderBeforeLeaf(e1, e2);
                    if (byFolder != 0) {
                        return byFolder;
                    }
                    if (e1 instanceof ContentLevelFolder && !(e2 instanceof ContentLevelFolder)) {
                        return -1;
                    }
                    if (!(e1 instanceof ContentLevelFolder) && e2 instanceof ContentLevelFolder) {
                        return 1;
                    }
                    if (e1 instanceof ContentLevelFolder && e2 instanceof ContentLevelFolder && (sortPackageResult = ContentLevel.sortPackageOrNot(e1, e2)) != 0) {
                        return sortPackageResult;
                    }
                    return _contentLevelDefaultComparator.compare(o1, o2);
                }
            };
        }
        return _packageFirstOrElseDefaultComparator;
    }

    private static int sortPackageOrNot(Element e1, Element e2) {
        if (IdeUtil.isPackageIdentifier(e1.getShortLabel())) {
            return IdeUtil.isPackageIdentifier(e2.getShortLabel()) ? 0 : -1;
        }
        if (IdeUtil.isPackageIdentifier(e2.getShortLabel())) {
            return 1;
        }
        return 0;
    }

    public static final Comparator getDisplayableComparator() {
        if (_displayableComparator == null) {
            _displayableComparator = new Comparator(){
                private final Collator _collator = Collator.getInstance();

                public int compare(Object o1, Object o2) {
                    String n1 = ContentLevel.getShortLabel(o1);
                    String n2 = ContentLevel.getShortLabel(o2);
                    return this._collator.compare(n1, n2);
                }
            };
        }
        return _displayableComparator;
    }

    private static int sortFolderBeforeLeaf(Element e1, Element e2) {
        if (ContentLevel.isFolder(e1)) {
            return ContentLevel.isFolder(e2) ? 0 : -1;
        }
        return ContentLevel.isFolder(e2) ? 1 : 0;
    }

    private static boolean isFolder(Element elem) {
        return elem != null && elem.mayHaveChildren();
    }

    private static final Comparator getSortByTypeComparator() {
        if (_sortByTypeComparator == null) {
            _sortByTypeComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Element e1 = (Element)o1;
                    Element e2 = (Element)o2;
                    int byFolder = ContentLevel.sortFolderBeforeLeaf(e1, e2);
                    if (byFolder != 0) {
                        return byFolder;
                    }
                    int comp = ContentLevel.sortByIcon(e1, e2);
                    if (comp == 0) {
                        comp = ContentLevel.sortByShortLabel(e1, e2);
                    }
                    return comp;
                }
            };
        }
        return _sortByTypeComparator;
    }

    private static int sortByIcon(Element e1, Element e2) {
        String s1 = ContentLevel.getIconString(e1);
        String s2 = ContentLevel.getIconString(e2);
        return Collator.getInstance().compare(s1, s2);
    }

    private static int sortByShortLabel(Element e1, Element e2) {
        String s1 = ContentLevel.getShortLabel(e1);
        String s2 = ContentLevel.getShortLabel(e2);
        return Collator.getInstance().compare(s1, s2);
    }

    private static String getIconString(Element elem) {
        Icon icon;
        if (elem != null && (icon = elem.getIcon()) != null) {
            return icon.toString();
        }
        return "<null>";
    }

    private static String getShortLabel(Object o) {
        if (o != null) {
            if (o instanceof Displayable) {
                String label = ((Displayable)o).getShortLabel();
                if (label != null) {
                    return label;
                }
            } else {
                return o.toString();
            }
        }
        return "<null>";
    }

    public static final Comparator getContentSetDisplayableComparator() {
        if (_contentSetDisplayableComparator == null) {
            _contentSetDisplayableComparator = new Comparator(){
                private final Collator _collator = Collator.getInstance();

                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    String label1 = ContentLevel.getShortLabel(o1);
                    String label2 = ContentLevel.getShortLabel(o2);
                    if (label1.startsWith("<")) {
                        if (label2.startsWith("<")) {
                            String key1 = label1.substring(1);
                            String key2 = label2.substring(1);
                            return this._collator.compare(key1, key2);
                        }
                        return 1;
                    }
                    if (label2.startsWith("<")) {
                        return -1;
                    }
                    return this._collator.compare(label1, label2);
                }

                @Override
                public boolean equals(Object o) {
                    return o != null && this.getClass() == o.getClass();
                }
            };
        }
        return _contentSetDisplayableComparator;
    }

    public abstract URL getDirectoryURL();

    public URLPath getDirectoryURLPath() {
        return new URLPath(this.getDirectoryURL());
    }

    public abstract String getRelPath();

    abstract void getContentSetKeys(ArrayList var1);

    public abstract int getLevel();

    public abstract List getFiles();

    public final List getDirectories() {
        return this._skip ? Collections.EMPTY_LIST : this.getDirectoriesImpl();
    }

    public final List<URL> getDirectoriesAsURLs() {
        return this._skip ? Collections.EMPTY_LIST : this.getDirectoriesAsURLsImpl();
    }

    public abstract ContentLevel getContentLevel(String var1);

    public final void getNodes(List nodeList) {
        List urls = this.getFiles();
        for (URL url : urls) {
            try {
                Node node = NodeFactory.findOrCreate(url);
                nodeList.add(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final RelativeDirectoryContextFolder newFolder(Context context) {
        return new ContentLevelFolder(this, context);
    }

    public final void addFlatDirs(Context context, List children) {
        int flatLevel = ContentLevel.getFlatLevel(context);
        if (flatLevel <= 0) {
            ArrayList elementList = new ArrayList();
            this.getAllNodes(elementList);
            this.applyContentLevelFilters(context, elementList, Collections.EMPTY_LIST);
            Collections.sort(elementList, ContentLevel.getDisplayableComparator());
            Iterator iter = elementList.iterator();
            if (iter.hasNext()) {
                Object prev = iter.next();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next == prev) {
                        iter.remove();
                    }
                    prev = next;
                }
            }
            children.addAll(elementList);
        } else {
            List elementList = Collections.synchronizedList(new ArrayList());
            this.getNodes(elementList);
            List<RelativeDirectoryContextFolder> subdirList = Collections.synchronizedList(new ArrayList());
            ArrayList flattenedDirs = this.getFlattenedDirs(flatLevel);
            for (ContentLevel nextLevel : flattenedDirs) {
                String relPath = nextLevel.getRelPath();
                if (relPath == null || relPath.length() <= 0) continue;
                subdirList.add(nextLevel.newFolder(context));
            }
            this.applyContentLevelFilters(context, elementList, subdirList);
            Iterator iter = subdirList.iterator();
            while (iter.hasNext()) {
                ContentLevelFolder folder = (ContentLevelFolder)iter.next();
                ContentLevel contentLevel = folder.getContentLevel();
                if (contentLevel.getLevel() >= flatLevel || contentLevel.containsFile()) continue;
                iter.remove();
            }
            elementList.addAll(subdirList);
            _contentLevelDefaultComparator = context.getBoolean(SORT_BY_TYPE) ? ContentLevel.getSortByTypeComparator() : ContentLevel.getChildrenComparator();
            Collections.sort(elementList, ContentLevel.getPackageFirstOrElseDefaultComparator());
            children.addAll(elementList);
        }
    }

    private static int getFlatLevel(Context context) {
        if (context.getBoolean(FLAT_LEVEL_ENABLED)) {
            return context.getInt(FLAT_LEVEL);
        }
        if (context.getBoolean(WEBCONTENT_FLAT_LEVEL_ENABLED)) {
            return context.getInt(WEBCONTENT_FLAT_LEVEL);
        }
        return 1;
    }

    final String getShortLabel(Context context) {
        this.ensureShortLabelToolTipInitialized(context);
        return this._shortLabel;
    }

    final String getToolTip(Context context) {
        this.ensureShortLabelToolTipInitialized(context);
        return this._toolTip;
    }

    private void ensureShortLabelToolTipInitialized(Context context) {
        if (this._shortLabel == null) {
            String packageName;
            String shortLabel;
            boolean couldBeJava;
            boolean isJavaPackage = false;
            String relPathForLabel = this.getRelPath();
            int flatLevel = ContentLevel.getFlatLevel(context);
            boolean isFirstFlatLevel = this.getLevel() <= flatLevel;
            boolean bl = couldBeJava = this.getDisplayFoldersAsPackages() && this.getLevel() > 0;
            while (relPathForLabel.endsWith("/")) {
                relPathForLabel = relPathForLabel.substring(0, relPathForLabel.length() - 1);
            }
            String toolTip = relPathForLabel;
            if ("".equals(relPathForLabel)) {
                URL dirURL = this.getDirectoryURL();
                shortLabel = URLFileSystem.getFileName((URL)dirURL);
            } else {
                int lastSlash;
                shortLabel = isFirstFlatLevel ? relPathForLabel : ((lastSlash = relPathForLabel.lastIndexOf(47)) < 0 ? relPathForLabel : relPathForLabel.substring(lastSlash + 1));
            }
            if (couldBeJava && IdeUtil.isPackageIdentifier(packageName = shortLabel.replace('/', '.'))) {
                shortLabel = packageName;
                toolTip = toolTip.replace('/', '.');
                isJavaPackage = true;
            }
            if (!isJavaPackage && '/' != File.separatorChar) {
                shortLabel = shortLabel.replace('/', File.separatorChar);
            }
            this._shortLabel = shortLabel;
            this._toolTip = toolTip;
        }
    }

    final void setShortLabel(String shortLabel) {
        this._shortLabel = shortLabel;
    }

    final Icon getIcon(Context context) {
        String path;
        if (this.getDisplayFoldersAsPackages() && this.getLevel() > 0 && IdeUtil.isPackageIdentifier(path = this.getPackageFormattedRelPath())) {
            return OracleIcons.getIcon((String)"package.png");
        }
        return this.getIcon();
    }

    Icon getIcon() {
        return ContentLevel.getFolderIcon();
    }

    abstract boolean containsFile();

    abstract boolean getDisplayFoldersAsPackages();

    abstract List getDirectoriesImpl();

    abstract List<URL> getDirectoriesAsURLsImpl();

    abstract void prepareRefresh();

    public static void addContentLevelFilter(ContentLevelFilter filter) {
        if (filter != null) {
            _filters.addIfAbsent(filter);
        }
    }

    public static void removeContentLevelFilter(ContentLevelFilter filter) {
        if (filter != null) {
            _filters.remove(filter);
        }
    }

    public static void addAsynchronousContentLevelFilter(AsynchronousContentLevelFilter asyncFilter) {
        if (asyncFilter != null) {
            _asyncFilters.addIfAbsent(asyncFilter);
        }
    }

    public static void removeAsynchronousContentLevelFilter(AsynchronousContentLevelFilter asyncFilter) {
        if (asyncFilter != null) {
            _asyncFilters.remove(asyncFilter);
        }
    }

    private void applyContentLevelFilters(Context context, List elementList, List subdirList) {
        if (context.getBoolean(ENABLE_CONTENT_LEVEL_FILTERS)) {
            URLPath srcRoots = this.getDirectoryURLPath();
            String dirRelPath = this.getRelPath();
            EL elementListWrapper = new EL(elementList);
            SL subdirListWrapper = new SL(subdirList);
            for (ContentLevelFilter contentLevelFilter : _filters) {
                if (!ContentLevel.filterAppliesToContext(contentLevelFilter, context)) continue;
                try {
                    long startTime = System.nanoTime();
                    contentLevelFilter.updateDir(srcRoots, dirRelPath, elementListWrapper, subdirListWrapper, context);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ContentLevelFilter.updateDir", contentLevelFilter.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (AsynchronousContentLevelFilter asynchronousContentLevelFilter : _asyncFilters) {
                if (!ContentLevel.filterAppliesToContext(asynchronousContentLevelFilter, context)) continue;
                try {
                    long startTime = System.nanoTime();
                    asynchronousContentLevelFilter.updateDir(srcRoots, dirRelPath, elementListWrapper, subdirListWrapper, context);
                    Callable<List<Subject>> updateDirHandler = asynchronousContentLevelFilter.getUpdateDirRequestHandler();
                    if (updateDirHandler != null) {
                        AsynchronousCallableCompletionServiceSingleton.getInstance().submit(updateDirHandler);
                        asynchronousContentLevelFilter.postUpdateDirRequestHandlerSubmitted(srcRoots, dirRelPath, elementListWrapper);
                    }
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("AsynchronousContentLevelFilter.updateDir", asynchronousContentLevelFilter.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean filterAppliesToContext(ContentLevelFilter filter, Context context) {
        String[] csKeys = filter.getContentSetKeys();
        int n = csKeys.length;
        for (int i = 0; i < n; ++i) {
            if (!context.getBoolean(csKeys[i])) continue;
            return true;
        }
        return false;
    }

    private String getPackageFormattedRelPath() {
        String relPath = this.getRelPath();
        if (relPath != null) {
            if (relPath.endsWith("/")) {
                relPath = relPath.substring(0, relPath.length() - 1);
            }
            relPath = relPath.replaceAll("/", ".");
        }
        return relPath;
    }

    private void getAllNodes(ArrayList children) {
        this.getNodes(children);
        List subdirs = this.getDirectories();
        Iterator iter = subdirs.iterator();
        while (iter.hasNext()) {
            String subdir = iter.next().toString();
            ContentLevel nextLevel = this.getContentLevel(subdir);
            if (nextLevel == null) continue;
            nextLevel.getAllNodes(children);
        }
    }

    private ArrayList getFlattenedDirs(int flatLevel) {
        int levelNum = this.getLevel();
        int gotoDepth = levelNum >= flatLevel ? 0 : flatLevel - levelNum - 1;
        ArrayList<ContentLevel> flattenedDirs = new ArrayList<ContentLevel>();
        ArrayList<ContentLevel> curLevels = new ArrayList<ContentLevel>();
        curLevels.add(this);
        ArrayList<ContentLevel> nextLevels = new ArrayList<ContentLevel>();
        for (int i = 0; curLevels.size() > 0 && i <= gotoDepth; ++i) {
            boolean isLastLevel;
            Iterator iter = curLevels.iterator();
            boolean bl = isLastLevel = i == gotoDepth;
            while (iter.hasNext()) {
                ContentLevel curContentLevel = (ContentLevel)iter.next();
                List dirs = curContentLevel.getDirectories();
                for (Object nextDirObj : dirs) {
                    String nextDir;
                    ContentLevel nextLevel;
                    if (nextDirObj == null || (nextLevel = curContentLevel.getContentLevel(nextDir = nextDirObj.toString())) == null) continue;
                    if (isLastLevel) {
                        flattenedDirs.add(nextLevel);
                        continue;
                    }
                    ContentLevel copyOfNextLevel = curContentLevel.getContentLevel(nextDir);
                    copyOfNextLevel.setSkipDirectories(true);
                    flattenedDirs.add(copyOfNextLevel);
                    nextLevels.add(nextLevel);
                }
            }
            curLevels.clear();
            curLevels.addAll(nextLevels);
            nextLevels.clear();
        }
        return flattenedDirs;
    }

    private static Comparator getChildrenComparator() {
        if (_childrenComparator == null) {
            _childrenComparator = new Comparator(){
                private Comparator _displayableComparator = ContentLevel.getDisplayableComparator();

                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 instanceof ContentSetFolder) {
                        if (o2 instanceof ContentSetFolder) {
                            return this._displayableComparator.compare(o1, o2);
                        }
                        return 1;
                    }
                    if (o2 instanceof ContentSetFolder) {
                        return -1;
                    }
                    Element e1 = (Element)o1;
                    Element e2 = (Element)o2;
                    int byFolder = ContentLevel.sortFolderBeforeLeaf(e1, e2);
                    if (byFolder != 0) {
                        return byFolder;
                    }
                    return this._displayableComparator.compare(o1, o2);
                }
            };
        }
        return _childrenComparator;
    }

    private void setSkipDirectories(boolean skip) {
        this._skip = skip;
    }

    public static ContentLevel newInstance(ContentSet contentSet, IntersectedFilters filters) {
        ContentAtom[] atoms = ContentAtom.atomize(contentSet, filters);
        return new Group(atoms);
    }

    static Icon getFolderIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    private static Icon getJarIcon() {
        return OracleIcons.getIcon((String)"archivefile.png");
    }

    private static void put(HashMap<URL, ArrayList<ContentAtom>> map, ArrayList<URL> keys, URL key, ContentAtom atom) {
        ArrayList<ContentAtom> obj = map.get(key);
        if (obj != null) {
            obj.add(atom);
        } else {
            ArrayList<ContentAtom> list = new ArrayList<ContentAtom>();
            list.add(atom);
            map.put(key, list);
            keys.add(key);
        }
    }

    static {
        _filters = new CopyOnWriteArrayList();
        _asyncFilters = new CopyOnWriteArrayList();
        callableResultHandler = new CallableResultHandler<List<Subject>>(){

            @Override
            public void onException(ExecutionException executionException) {
                executionException.printStackTrace();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(List<Subject> listOfUpdatedSubjects) {
                assert (listOfUpdatedSubjects != null);
                List<Subject> list = listOfUpdatedSubjects;
                synchronized (list) {
                    for (Subject subject : listOfUpdatedSubjects) {
                        UpdateMessage.fireStructureChanged(subject);
                    }
                }
            }
        };
        debugLevel = Integer.getInteger("Project.debug.level", 0);
    }

    private static final class Group
    extends ContentLevel {
        private final int _level;
        private final ContentLevel[] _levels;
        private final URLComparator _urlComparator = new URLComparator();

        private Group(ContentAtom[] atoms) {
            this._level = 0;
            ArrayList<Impl> levels = new ArrayList<Impl>();
            if (atoms == null || atoms.length == 0) {
                if (debugLevel >= 1) {
                    new IllegalArgumentException("no contents specified").printStackTrace();
                }
            } else {
                for (ContentAtom atom : atoms) {
                    levels.add(new Impl(0, atom, "", ""));
                }
            }
            this._levels = levels.toArray(new ContentLevel[levels.size()]);
        }

        private Group(int level, ContentLevel[] levels) {
            this._level = level;
            this._levels = levels;
        }

        @Override
        public URL getDirectoryURL() {
            return this._levels.length > 0 ? this._levels[0].getDirectoryURL() : null;
        }

        @Override
        public URLPath getDirectoryURLPath() {
            URLPath urlPath = new URLPath();
            for (ContentLevel level : this._levels) {
                URL url = level.getDirectoryURL();
                if (url != null) {
                    urlPath.add(url);
                    continue;
                }
                urlPath.add(level.getDirectoryURLPath());
            }
            return urlPath;
        }

        @Override
        public String getRelPath() {
            return this._levels.length > 0 ? this._levels[0].getRelPath() : "";
        }

        @Override
        void getContentSetKeys(ArrayList keys) {
            for (ContentLevel level : this._levels) {
                level.getContentSetKeys(keys);
            }
        }

        @Override
        public int getLevel() {
            return this._level;
        }

        @Override
        boolean getDisplayFoldersAsPackages() {
            for (ContentLevel level : this._levels) {
                if (!level.getDisplayFoldersAsPackages()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getFiles() {
            ArrayList files = new ArrayList();
            for (ContentLevel level : this._levels) {
                files.addAll(level.getFiles());
            }
            CollectionUtil.sortListAndEliminateDuplicates(files, (Comparator)this._urlComparator);
            return files;
        }

        @Override
        List getDirectoriesImpl() {
            ArrayList dirs = new ArrayList();
            for (ContentLevel level : this._levels) {
                dirs.addAll(level.getDirectories());
            }
            CollectionUtil.sortListAndEliminateDuplicates(dirs, null);
            return dirs;
        }

        @Override
        List<URL> getDirectoriesAsURLsImpl() {
            ArrayList<URL> dirs = new ArrayList<URL>();
            for (ContentLevel level : this._levels) {
                dirs.addAll(level.getDirectoriesAsURLs());
            }
            CollectionUtil.sortListAndEliminateDuplicates(dirs, (Comparator)this._urlComparator);
            return dirs;
        }

        @Override
        void prepareRefresh() {
            for (ContentLevel level : this._levels) {
                level.prepareRefresh();
            }
        }

        @Override
        boolean containsFile() {
            for (ContentLevel level : this._levels) {
                if (!level.containsFile()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ContentLevel getContentLevel(String relPath) {
            ArrayList<ContentLevel> levelsList = new ArrayList<ContentLevel>();
            for (ContentLevel level : this._levels) {
                ContentLevel nextLevel = level.getContentLevel(relPath);
                if (nextLevel == null) continue;
                levelsList.add(nextLevel);
            }
            int numNewLevels = levelsList.size();
            if (numNewLevels > 0) {
                ContentLevel[] levels = levelsList.toArray(new ContentLevel[numNewLevels]);
                return new Group(this._level + 1, levels);
            }
            return null;
        }
    }

    private static final class Impl
    extends ContentLevel {
        private final int _level;
        private final ContentAtom _atom;
        private final String _relPath;
        private final String _relPathDisplayPrefix;
        private final Icon _icon;
        private URL _dir;
        private URL[] _files;
        private URL[] _dirs;
        private List _cachedDirsList;

        private Impl(int level, ContentAtom atom, String relPath, String relPathDisplayPrefix) {
            this._level = level;
            this._atom = atom;
            this._relPath = Impl.sanitizeRelPath(relPath);
            this._relPathDisplayPrefix = relPathDisplayPrefix;
            this._icon = "".equals(this._relPath) && JarUtil.isJarURL((URL)this._atom.getContentRoot()) && "".equals(JarUtil.getJarEntry((URL)this._atom.getContentRoot())) ? ContentLevel.getJarIcon() : Impl.getFolderIcon();
        }

        @Override
        public URL getDirectoryURL() {
            return this._atom.getContentRoot();
        }

        @Override
        public String getRelPath() {
            if ("".equals(this._relPathDisplayPrefix)) {
                return this._relPath;
            }
            return this._relPathDisplayPrefix + this._relPath;
        }

        @Override
        void getContentSetKeys(ArrayList keys) {
            String key = this._atom._contentSetKey;
            if (key != null && !keys.contains(key)) {
                keys.add(key);
            }
        }

        @Override
        public int getLevel() {
            return this._level;
        }

        @Override
        Icon getIcon() {
            return this._icon;
        }

        @Override
        boolean getDisplayFoldersAsPackages() {
            return this._atom.getDisplayFoldersAsPackages();
        }

        @Override
        public List getFiles() {
            this.maybeGetFilesAndDirectories();
            return Collections.unmodifiableList(Arrays.asList(this._files));
        }

        @Override
        List getDirectoriesImpl() {
            if (this._cachedDirsList == null) {
                this.maybeGetFilesAndDirectories();
                int n = this._dirs.length;
                String[] dirs = new String[n];
                for (int i = 0; i < n; ++i) {
                    URL dir = this._dirs[i];
                    dirs[i] = URLFileSystem.toRelativeSpec((URL)dir, (URL)this._dir, (boolean)true);
                }
                this._cachedDirsList = Arrays.asList(dirs);
            }
            return this._cachedDirsList;
        }

        @Override
        List<URL> getDirectoriesAsURLsImpl() {
            this.maybeGetFilesAndDirectories();
            return Collections.unmodifiableList(Arrays.asList(this._dirs));
        }

        @Override
        void prepareRefresh() {
            this._files = null;
            this._dirs = null;
            this._cachedDirsList = null;
        }

        @Override
        boolean containsFile() {
            this.maybeGetFilesAndDirectories();
            return this._files.length > 0;
        }

        @Override
        public ContentLevel getContentLevel(String relPath) {
            List dirs = this.getDirectories();
            if (!dirs.contains(relPath)) {
                return null;
            }
            String newRelPath = this._relPath + relPath;
            return new Impl(this._level + 1, this._atom, newRelPath, this._relPathDisplayPrefix);
        }

        private static String sanitizeRelPath(String relPath) {
            if (relPath == null || relPath.equals("")) {
                return "";
            }
            if (relPath.endsWith("/")) {
                return relPath;
            }
            return relPath + "/";
        }

        private void maybeGetFilesAndDirectories() {
            if (this._files == null) {
                ArrayList<URL> files = new ArrayList<URL>();
                ArrayList<URL> dirs = new ArrayList<URL>();
                this._dir = URLFactory.newDirURL((URL)this._atom.getContentRoot(), (String)this._relPath);
                URL[] urls = URLFileSystem.list((URL)this._dir);
                if (urls != null) {
                    for (URL url : urls) {
                        String relSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)this._atom.getContentRoot(), (boolean)true);
                        if (relSpec == null) {
                            relSpec = Impl.relativeURL(url, this._atom.getContentRoot());
                        }
                        if (URLFileSystem.isDirectoryPath((URL)url)) {
                            TriStateBoolean tsb = this._atom.getFilters().inferFromFilters(relSpec);
                            if (!tsb.isTrue() && !tsb.isTriState()) continue;
                            dirs.add(url);
                            continue;
                        }
                        if (!this._atom.getFilters().isIncluded(relSpec)) continue;
                        files.add(url);
                    }
                }
                this._files = Impl.toArray(files);
                this._dirs = Impl.toArray(dirs);
            }
        }

        private static URL[] toArray(ArrayList list) {
            return list.toArray(new URL[list.size()]);
        }

        private static String relativeURL(URL url, URL base) {
            String basePath;
            String urlPath = url.getPath();
            int indexOfBase = urlPath.indexOf(basePath = base.getPath());
            if (indexOfBase == 0) {
                return urlPath.substring(basePath.length());
            }
            return null;
        }
    }

    private static class SL
    extends ListWrapper {
        private SL(List list) {
            super(list);
        }

        @Override
        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i, Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int i, Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List subList(int i, int j) {
            return new SL(super.subList(i, j));
        }
    }

    private static class EL
    extends ListWrapper {
        private EL(List list) {
            super(list);
        }

        @Override
        public boolean add(Object obj) {
            this.checkAdd(obj);
            return super.add(obj);
        }

        @Override
        public void add(int i, Object obj) {
            this.checkAdd(obj);
            super.add(i, obj);
        }

        @Override
        public boolean addAll(Collection c) {
            this.checkAdd(c);
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int i, Collection c) {
            this.checkAdd(c);
            return super.addAll(i, c);
        }

        @Override
        public Object set(int i, Object obj) {
            this.checkAdd(obj);
            return super.set(i, obj);
        }

        @Override
        public List subList(int i, int j) {
            return new EL(super.subList(i, j));
        }

        private void checkAdd(Object obj) {
            if (!(obj instanceof Element)) {
                throw new IllegalArgumentException();
            }
        }

        private void checkAdd(Collection c) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.checkAdd(iter.next());
            }
        }
    }

    private static class ListWrapper
    implements List {
        private final List _list;

        public ListWrapper(List list) {
            this._list = list;
        }

        @Override
        public boolean add(Object obj) {
            return this._list.add(obj);
        }

        public void add(int i, Object obj) {
            this._list.add(i, obj);
        }

        @Override
        public boolean addAll(Collection c) {
            return this._list.addAll(c);
        }

        public boolean addAll(int i, Collection c) {
            return this._list.addAll(i, c);
        }

        @Override
        public void clear() {
            this._list.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return this._list.contains(obj);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this._list.containsAll(c);
        }

        public Object get(int i) {
            return this._list.get(i);
        }

        @Override
        public int indexOf(Object obj) {
            return this._list.indexOf(obj);
        }

        @Override
        public boolean isEmpty() {
            return this._list.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return this._list.iterator();
        }

        @Override
        public int lastIndexOf(Object obj) {
            return this._list.lastIndexOf(obj);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int i) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            return this._list.remove(i);
        }

        @Override
        public boolean remove(Object obj) {
            return this._list.remove(obj);
        }

        @Override
        public boolean removeAll(Collection c) {
            return this._list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            return this._list.retainAll(c);
        }

        public Object set(int i, Object obj) {
            return this._list.set(i, obj);
        }

        @Override
        public int size() {
            return this._list.size();
        }

        public List subList(int i, int j) {
            return this._list.subList(i, j);
        }

        @Override
        public Object[] toArray() {
            return this._list.toArray();
        }

        @Override
        public Object[] toArray(Object[] arr) {
            return this._list.toArray(arr);
        }
    }

    private static class AsynchronousCallableCompletionServiceSingleton {
        private static AsynchronousCallableCompletionService<List<Subject>> instance = null;

        private AsynchronousCallableCompletionServiceSingleton() {
        }

        static AsynchronousCallableCompletionService getInstance() {
            if (instance == null) {
                instance = new AsynchronousCallableCompletionService(Executors.newFixedThreadPool(4), callableResultHandler);
            }
            return instance;
        }
    }
}

