/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.naming.Context;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import oracle.bali.ewt.text.NoWrapper;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationWizard;
import oracle.ide.migration.NodeMigratorComparator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.ProjectVersion;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.SwingUtils;

public abstract class NodeMigrator {
    public static final String MIGRATOR_MAP_DATA = "node-migrator-data";
    private static final String MIGRATOR_MSG_DATA = "node-migrator-errors";
    private static final Boolean BACKUPS_ENABLED = Boolean.getBoolean("ide.enable.NodeMigrator.backups");
    private List _helpers = new ArrayList();
    private ProgressBar _progressBar;
    private TraversableContext _context;

    public static NodeMigrator getNodeMigrator(String name) {
        return (NodeMigrator)Names.lookup((Context)Names.newInitialContext(), (String)name);
    }

    public static String getLookupKey(Node node) {
        return node.getClass().getName();
    }

    public abstract MigrationInfo getMigrationInfo(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MigrationInfo[] migrate(MigrationInfo[] infos) {
        this._context = new TraversableContext(new Namespace(), 1);
        int oldCompareUtilsLimit = CompareUtils.setLimit((int)0);
        try {
            this.preMigrate(infos, this._context);
            List pages = this.getPages(infos, this._context);
            MigrationInfo.MigrationStatus migrationStatusFromUserInput = this.invokeWizard(this._context, pages, infos);
            if (migrationStatusFromUserInput == MigrationInfo.MIGRATION_PENDING) {
                if (!this.checkVersioning(infos)) {
                    for (MigrationInfo migrationInfo : infos) {
                        migrationInfo.setMigrationStatus(MigrationInfo.MIGRATION_NOT_POSSIBLE);
                    }
                    MigrationInfo[] arr$ = infos;
                    return arr$;
                }
                NodeMigrator.logTimestampedMessage(407);
                List infoList = null;
                try {
                    ArrayList msgs = new ArrayList();
                    this._context.putDesignTimeObject(MIGRATOR_MSG_DATA, msgs);
                    infoList = this.doMigration(this._context);
                    ArrayList<String> migrationFailed = new ArrayList<String>();
                    ArrayList<String> filesNotBackedUp = new ArrayList<String>();
                    ArrayList<String> migrationDoneButNotSaved = new ArrayList<String>();
                    ArrayList<String> migrationDone = new ArrayList<String>();
                    for (MigrationInfo info : infoList) {
                        Node node = info.getNode();
                        URL url = node.getURL();
                        String pathname = URLFileSystem.getPlatformPathName((URL)url);
                        MigrationInfo.MigrationStatus status = info.getMigrationStatus();
                        if (status == MigrationInfo.MIGRATION_DONE) {
                            migrationDone.add(pathname);
                        } else if (status == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
                            migrationDoneButNotSaved.add(pathname);
                            if (info.hasErrors()) {
                                Iterator<MigrationInfo.ErrorInformation> it = info.getErrors();
                                while (it.hasNext()) {
                                    migrationDoneButNotSaved.add("  CAUSE: " + it.next().getMessage());
                                }
                            }
                        } else {
                            migrationFailed.add(pathname);
                        }
                        if (!BACKUPS_ENABLED.booleanValue() || info.getBackupURL() != null) continue;
                        filesNotBackedUp.add(pathname);
                    }
                    NodeMigrator.emitMessages(migrationFailed, msgs, 403);
                    NodeMigrator.emitMessages(filesNotBackedUp, msgs, 404);
                    NodeMigrator.emitMessages(migrationDoneButNotSaved, msgs, 405);
                    NodeMigrator.emitMessages(migrationDone, msgs, 406);
                    this.displayMessages(msgs);
                }
                catch (Throwable t) {
                    NodeMigrator.logTimestampedMessage(409);
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    t.printStackTrace();
                }
                MigrationInfo[] t = infoList != null ? infoList.toArray(new MigrationInfo[infoList.size()]) : null;
                return t;
            }
            for (MigrationInfo migrationInfo : infos) {
                migrationInfo.setMigrationStatus(migrationStatusFromUserInput);
            }
            MigrationInfo[] migrationInfoArray = infos;
            return migrationInfoArray;
        }
        finally {
            this.postMigrate(infos, this._context);
            CompareUtils.setLimit((int)oldCompareUtilsLimit);
            this._context = null;
        }
    }

    public TraversableContext getTraversableContext() {
        return this._context;
    }

    protected void preMigrate(MigrationInfo[] infos, TraversableContext context) {
    }

    protected boolean checkVersioning(MigrationInfo[] infos) {
        VCSManager vcs = VCSManager.getVCSManager();
        for (MigrationInfo info : infos) {
            URL url;
            Node node = info.getNode();
            if (node == null || (url = node.getURL()) == null || !URLFileSystem.isReadOnly((URL)url) || vcs.canCheckOut(url)) continue;
            MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(510, url.toString()), (String)IdeArb.getString(400), null);
            return false;
        }
        return true;
    }

    protected void postMigrate(MigrationInfo[] infos, TraversableContext context) {
    }

    private static void emitMessages(List<String> pathnames, ArrayList msgs, int resourceKey) {
        if (!pathnames.isEmpty()) {
            if (!msgs.isEmpty()) {
                msgs.add("");
            }
            msgs.add(IdeArb.getString(resourceKey));
            for (String next : pathnames) {
                if (next == null) continue;
                msgs.add("      " + next);
            }
        }
    }

    public MigrationInfo[] getMigrationInfos(Node[] nodes) {
        ArrayList<MigrationInfo> infos = new ArrayList<MigrationInfo>(nodes.length);
        for (Node node : nodes) {
            infos.add(this.getMigrationInfo(node));
        }
        return infos.toArray(new MigrationInfo[infos.size()]);
    }

    public List getPages(MigrationInfo[] infos, TraversableContext context) {
        Map map = this.getInfoToMigratorMap(context);
        for (MigrationInfo info : infos) {
            this.mapInfoToMigrator(this, info, map);
        }
        HashSet<NodeMigratorHelper> allHelpersWhosePagesAreRelevant = new HashSet<NodeMigratorHelper>();
        ArrayList pages = new ArrayList();
        for (MigrationInfo migrationInfo : infos) {
            NodeMigratorHelper[] helpers;
            for (NodeMigratorHelper helper : helpers = migrationInfo.getHelpers()) {
                if (allHelpersWhosePagesAreRelevant.contains(helper)) continue;
                allHelpersWhosePagesAreRelevant.add(helper);
                pages.addAll(helper.getPages(infos, context));
            }
        }
        return pages;
    }

    public final MigrationInfo migrate(MigrationInfo info) {
        MigrationInfo[] infos = new MigrationInfo[]{info};
        this.migrate(infos);
        return infos[0];
    }

    public List doMigration(final TraversableContext context) {
        final ArrayList infoList = new ArrayList();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Map map = NodeMigrator.this.getInfoToMigratorMap(context);
                    for (NodeMigrator migrator : map.keySet()) {
                        infoList.addAll(migrator.doMigration((List)map.get(migrator), context));
                    }
                    NodeMigrator.this.finishMigration(infoList);
                }
                finally {
                    NodeMigrator.this._progressBar.setDoneStatus();
                }
            }
        };
        this._progressBar = new ProgressBar((Component)((Object)Ide.getMainWindow()), IdeArb.getString(400), runnable, true);
        this._progressBar.setCancelable(false);
        this._progressBar.start(IdeArb.format(401, Version.NAME_SHORT, Version.VER), null);
        this._progressBar.waitUntilDone();
        this._progressBar = null;
        return infoList;
    }

    public List doMigration(List list, TraversableContext context) {
        MigrationInfo[] infos = list.toArray(new MigrationInfo[list.size()]);
        if (BACKUPS_ENABLED.booleanValue()) {
            this.backup(infos);
        }
        for (MigrationInfo info : infos) {
            this.callHelpersMigrate(info, context);
        }
        return list;
    }

    protected void callHelpersMigrate(MigrationInfo info, TraversableContext context) {
        NodeMigratorHelper[] helpers;
        for (NodeMigratorHelper helper : helpers = this.getHelpers(info)) {
            this.callHelperMigrate(helper, info, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void callHelperMigrate(NodeMigratorHelper helper, MigrationInfo info, TraversableContext context) {
        long start;
        long end = start = System.nanoTime();
        try {
            MigrationInfo[] infos = new MigrationInfo[]{info};
            helper.migrate(infos, context);
            end = System.nanoTime();
            Node node = info.getNode();
            if (node instanceof PropertyStorage) {
                PropertyStorage project = (PropertyStorage)info.getNode();
                ProjectVersion projectVersion = new ProjectVersion(project);
                String helperKey = helper.getNodeMigratorHelperKey();
                if (helperKey != null) {
                    String helperVersion = helper.getNodeMigratorHelperVersion();
                    projectVersion.addVersion(helperKey, new VersionNumber(helperVersion));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PerformanceLogger.get().log("NodeMigratorHelper.migrate", helper.getClass().getName(), end - start);
        }
    }

    public final void addHelper(NodeMigratorHelper helper) {
        this._helpers.add(helper);
    }

    public final void removeHelper(NodeMigratorHelper helper) {
        this._helpers.remove(helper);
    }

    public MigrationInfo.MigrationStatus checkVersions(MigrationInfo[] infos) {
        int count = 0;
        for (MigrationInfo info : infos) {
            MigrationInfo.MigrationStatus status = info.getMigrationStatus();
            if (status == MigrationInfo.MIGRATION_NOT_POSSIBLE) {
                URL url = info.getNode().getURL();
                String msg = IdeArb.format(416, Version.NAME_SHORT, URLFileSystem.getPlatformPathName((URL)url), info.getVersion());
                MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)msg, (String)IdeArb.getString(415), null);
                return status;
            }
            if (status != MigrationInfo.MIGRATION_NOT_NEEDED) continue;
            ++count;
        }
        return count != infos.length ? MigrationInfo.MIGRATION_PENDING : MigrationInfo.MIGRATION_NOT_NEEDED;
    }

    protected abstract String getTitle();

    protected abstract String getMsg(MigrationInfo[] var1);

    protected abstract String getSummaryMsg(MigrationInfo[] var1);

    protected MigrationInfo.MigrationStatus invokeWizard(TraversableContext context, List pages, MigrationInfo[] infos) {
        MigrationInfo.MigrationStatus status = this.checkVersions(infos);
        if (status == MigrationInfo.MIGRATION_PENDING) {
            String summaryMsg;
            String welcomeMsg;
            String title = this.getTitle();
            boolean ok = MigrationWizard.runWizard(title, welcomeMsg = this.getMsg(infos), summaryMsg = this.getSummaryMsg(infos), context, pages);
            if (!ok) {
                status = MigrationInfo.MIGRATION_CANCELED;
            } else {
                boolean noMigrate;
                Boolean canceled = (Boolean)context.get("user-canceled-migration");
                boolean bl = noMigrate = canceled != null ? canceled : false;
                if (noMigrate) {
                    status = MigrationInfo.MIGRATION_CANCELED;
                }
            }
        }
        return status;
    }

    public NodeMigratorHelper[] getHelpers() {
        return this._helpers.toArray(new NodeMigratorHelper[this._helpers.size()]);
    }

    protected NodeMigratorHelper[] getHelpers(MigrationInfo info) {
        return this.getHelpers();
    }

    protected Map getInfoToMigratorMap(TraversableContext context) {
        TreeMap map = (TreeMap)context.find(MIGRATOR_MAP_DATA);
        if (map == null) {
            map = new TreeMap(new NodeMigratorComparator());
            context.put(MIGRATOR_MAP_DATA, map);
        }
        return map;
    }

    protected void mapInfoToMigrator(NodeMigrator key, MigrationInfo info, Map map) {
        if (info.getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
            ArrayList<MigrationInfo> infos = (ArrayList<MigrationInfo>)map.get(key);
            if (infos == null) {
                infos = new ArrayList<MigrationInfo>(1);
                map.put(key, infos);
            }
            if (!infos.contains(info)) {
                infos.add(info);
            }
        }
    }

    protected final void finishMigration(List infos) {
        int n = infos.size();
        for (int i = 0; i < n; ++i) {
            MigrationInfo info = (MigrationInfo)infos.get(i);
            if (info.getMigrationStatus() != MigrationInfo.MIGRATION_PENDING) continue;
            info.setMigrationStatus(MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED);
            if (BACKUPS_ENABLED.booleanValue() && info.getBackupURL() == null) continue;
            try {
                Node node = info.getNode();
                if (node.isDirty()) {
                    URL url = node.getURL();
                    if (URLFileSystem.isReadOnly((URL)url) && !URLFileSystem.setReadOnly((URL)url, (boolean)false)) continue;
                    node.save();
                    info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                    node.close();
                    continue;
                }
                info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void backup(MigrationInfo[] infos) {
        for (MigrationInfo info : infos) {
            URL url = info.getNode().getURL();
            if (!URLFileSystem.exists((URL)url)) continue;
            URL dir = URLFileSystem.getParent((URL)url);
            String fname = URLFileSystem.getName((URL)url);
            String ext = URLFileSystem.getSuffix((URL)url);
            BackupNameGenerator namegen = new BackupNameGenerator(fname, ext);
            URL backupURL = URLFactory.newUniqueURL((URL)dir, (NameGenerator)namegen);
            MigrationInfo.MigrationStatus oldStatus = this.updateStatus(info, MigrationInfo.MIGRATION_IO_ERROR);
            try {
                URLFileSystem.copy((URL)url, (URL)backupURL);
                info.setBackupURL(backupURL);
            }
            catch (IOException e) {
                info.setBackupURL(null);
            }
            this.updateStatus(info, oldStatus);
        }
    }

    private MigrationInfo.MigrationStatus updateStatus(MigrationInfo info, MigrationInfo.MigrationStatus newStatus) {
        MigrationInfo.MigrationStatus oldStatus = info.getMigrationStatus();
        info.setMigrationStatus(newStatus);
        return oldStatus;
    }

    private void displayMessages(ArrayList msgs) {
        Iterator i;
        Iterator iterator = i = msgs != null ? msgs.iterator() : null;
        if (i != null) {
            StringBuffer output = new StringBuffer();
            while (i.hasNext()) {
                String text;
                Object o = i.next();
                if (o == null || "null".equals(text = o.toString())) continue;
                output.append(text);
                output.append("\n");
            }
            if (output.length() > 0) {
                LogPage logPage;
                String outputString = output.toString();
                LogManager logManager = LogManager.getLogManager();
                if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
                    logPage.log(outputString);
                    NodeMigrator.logTimestampedMessage(408);
                }
                JMultiLineLabel jMultiLabel = new JMultiLineLabel(outputString);
                jMultiLabel.setTextWrapper(NoWrapper.getTextWrapper());
                jMultiLabel.setAllowFocus(true);
                AccessibleUtils.updateAccessibleName((Accessible)((Object)jMultiLabel), (String)IdeArb.getString(400), (boolean)false);
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)jMultiLabel));
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                BaseMessageDialog dlg = BaseMessageDialog.createMessageDialogImpl((Component)SwingUtils.getToplevelWindow(), (String)IdeArb.getString(400), (int)2);
                dlg.setDefaultButton(1);
                dlg.setHelpTopic(null);
                dlg.setMessage((Object)jScrollPane);
                dlg.setResizable(true);
                dlg.runDialog();
            }
        }
    }

    private static void logTimestampedMessage(int resourceKey) {
        LogPage logPage;
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
            logPage.log(IdeArb.format(resourceKey, NodeMigrator.getFormattedTimestamp()));
            logPage.log("\n");
        }
    }

    private static String getFormattedTimestamp() {
        DateFormat timeFormatter = DateFormat.getTimeInstance();
        return timeFormatter.format(new Date());
    }

    protected float getWeight() {
        return 1.0f;
    }

    static class BackupNameGenerator
    implements NameGenerator {
        private static final String BAK = ".bak";
        private int _counter = 0;
        private String _baseName;
        private String _extension;
        private String _nextName;

        public BackupNameGenerator(String baseName, String extension) {
            this._baseName = baseName;
            this._extension = extension;
            this._nextName = this._baseName + this._extension + BAK;
        }

        public String nextName() {
            String tmp = this._nextName;
            this._nextName = this._baseName + this._extension + "." + Integer.toString(this._counter++) + BAK;
            return tmp;
        }
    }
}

