/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeField;
import oracle.ide.keyboard.KeyStrokeImporterExporter;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyStrokesConstraintFactory;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.PresetsPanel;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithHint;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.StringUtil;

public final class KeyStrokePanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener,
KeyListener,
KeyStrokesConstraint,
ListSelectionListener,
SearchListener {
    private KeyStrokeOptions _kso;
    private NiceTable _jtActions;
    private KeyStrokeTableModel _tableModel;
    private String _lastSearch;
    private KeyStrokeField _jksNewShortcut;
    private ExtendedTextField _jlblCurrentAssign;
    private JButton _jbAdd;
    private JButton _jbRemove;
    private JButton _jbPresets;
    private JButton _jbCopy;
    private JButton _jbMoreActions;
    private JCheckBox _jchkHideUnmapped;
    private AbstractAction _exportAction;
    private AbstractAction _loadPresetAction;
    private AbstractAction _importAction;
    private static final int VISIBLE_COLUMN_COUNT = 3;
    private static final String HIDE_UNMAPPED_COMMANDS = "hide-unmapped-commands";

    public KeyStrokePanel() {
        this.setHelpID("f1_idedidesetshortcuts_html");
        this._lastSearch = "";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._jksNewShortcut.setConstraint(this);
    }

    public void onEntry(TraversableContext tc) {
        if (this._kso == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            IdeSettings ideSettings = (IdeSettings)tc.find("ide-options");
            this._kso = ideSettings.getKeyStrokeOptions();
            ActionEvent event = new ActionEvent(this, 1001, "showing");
            this._kso.getKeyboardPanelEventDispatcher().actionPerformed(event);
            DTCache cache = Ide.getDTCache();
            boolean hide = cache.getBoolean(HIDE_UNMAPPED_COMMANDS, false);
            if (hide) {
                this._jchkHideUnmapped.setSelected(hide);
            }
            this.fillActions();
        }
    }

    public void onExit(TraversableContext tc) {
        DTCache cache = Ide.getDTCache();
        cache.putBoolean(HIDE_UNMAPPED_COMMANDS, this._jchkHideUnmapped.isSelected());
    }

    @Override
    public boolean isAcceptableKey(KeyStrokes kss, KeyStroke ksNew) {
        KeyStrokesConstraint kscon = KeyStrokesConstraintFactory.getConstraint(0);
        return kscon == null ? true : kscon.isAcceptableKey(kss, ksNew);
    }

    private void jbInit() throws Exception {
        this._tableModel = new KeyStrokeTableModel();
        this._jtActions = new NiceTable((TableModel)((Object)this._tableModel));
        this._jtActions.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                if (((TableColumnModel)e.getSource()).getColumnCount() > 3) {
                    KeyStrokePanel.this._jtActions.setHiddenColumns(KeyStrokeTableModel.HIDDEN_COLUMNS);
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this._jtActions.getTableHeader().setReorderingAllowed(false);
        this._jtActions.setRowHeight(20);
        this._jtActions.setSorted(true);
        this._jtActions.setShowGrid(true);
        this._jtActions.setDragEnabled(false);
        this._jtActions.setShowHorizontalLines(true);
        this._jtActions.setSortRetainsSelection(true);
        this._jtActions.setColumnSelectorAvailable(false);
        this._jtActions.setColumnSelectionAllowed(false);
        this._jtActions.setSelectionMode(2);
        this._jtActions.setSortColumn(1, true);
        this._jtActions.getColumnModel().getColumn(1).setCellRenderer(new ActionElementRenderer());
        JScrollPane jspActions = new JScrollPane((Component)this._jtActions);
        jspActions.setOpaque(false);
        this._jksNewShortcut = new KeyStrokeField();
        this._jlblCurrentAssign = new ExtendedTextField();
        this._jbCopy = new JButton();
        this._jbRemove = new JButton();
        this._jbAdd = new JButton();
        this._jbPresets = new JButton();
        this._jbMoreActions = new JButton();
        this._jchkHideUnmapped = new JCheckBox();
        JLabel lblNewShortcut = new JLabel();
        JLabel lblCurrent = new JLabel();
        ComponentWithHint conflictWithHint = new ComponentWithHint((Component)this._jlblCurrentAssign, KeyStrokeArb.getString(7));
        this._jbCopy.setIcon(OracleIcons.getIcon((String)"copy.png"));
        this._jbRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._jbMoreActions.setIcon(OracleIcons.getIcon((String)"extras/dropdown_small.png"));
        this._jbCopy.setToolTipText(KeyStrokeArb.getString(10));
        this._jbRemove.setToolTipText(KeyStrokeArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this._jbAdd, (String)KeyStrokeArb.getString(12));
        ResourceUtils.resButton((AbstractButton)this._jbPresets, (String)KeyStrokeArb.getString(18));
        ResourceUtils.resLabel((JLabel)lblNewShortcut, (Component)this._jksNewShortcut, (String)KeyStrokeArb.getString(5));
        ResourceUtils.resLabel((JLabel)lblCurrent, (Component)this._jlblCurrentAssign, (String)KeyStrokeArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this._jchkHideUnmapped, (String)KeyStrokeArb.getString(9));
        ResourceUtils.resButton((AbstractButton)this._jbMoreActions, (String)KeyStrokeArb.getString(13));
        this._jbMoreActions.setHorizontalTextPosition(10);
        this._jbAdd.setEnabled(false);
        this._jbCopy.setEnabled(false);
        this._jbRemove.setEnabled(false);
        this._jksNewShortcut.setEnabled(false);
        this._jksNewShortcut.setMinimumSize(new Dimension(4, 21));
        this._jlblCurrentAssign.setEditable(false);
        this._jlblCurrentAssign.setFocusable(false);
        this._jbAdd.addActionListener(this);
        this._jbRemove.addActionListener(this);
        this._jbPresets.addActionListener(this);
        this._jbCopy.addActionListener(this);
        this._jbMoreActions.addActionListener(this);
        this._jchkHideUnmapped.addItemListener(this);
        this._jtActions.addKeyListener((KeyListener)this);
        this._jtActions.getSelectionModel().addListSelectionListener(this);
        this._jksNewShortcut.getModel().addActionListener(this);
        SearchField searchField = new SearchField();
        searchField.setPrompt(KeyStrokeArb.getString(4));
        searchField.setKeyEventTargetComponent((Component)this._jtActions);
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.addSearchListener((SearchListener)this);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jbCopy);
        controlBar.add((Component)this._jbRemove);
        controlBar.add((Component)this._jbMoreActions);
        JLabel tableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)tableLabel, (Component)jspActions, (String)KeyStrokeArb.getString(3));
        ComponentWithTitlebar titledTable = new ComponentWithTitlebar((JComponent)jspActions, tableLabel, controlBar);
        int Y = -1;
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridBagLayout());
        searchPanel.add((Component)searchField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 23), 0, 0));
        searchPanel.add((Component)this._jchkHideUnmapped, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(searchPanel, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)titledTable, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 17, 1, new Insets(8, 0, 8, 0), 0, 0));
        this.add(lblNewShortcut, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 6, 6), 0, 0));
        this.add(this._jksNewShortcut, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 0, 0));
        this.add(this._jbAdd, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 6, 0), 0, 0));
        this.add(lblCurrent, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)conflictWithHint, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void whenMoreActions() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getExportAction());
        menu.add(this.getImportAction());
        menu.add(this.getLoadPresetAction());
        boolean x = false;
        int y = this._jbMoreActions.getY() + this._jbMoreActions.getSize().height;
        menu.show(this._jbMoreActions, 0, y);
    }

    private Action getImportAction() {
        if (this._importAction == null) {
            this._importAction = new AbstractAction(KeyStrokeArb.getString(14)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeyStrokeImporterExporter.importShortcuts(KeyStrokePanel.this._kso)) {
                        KeyStrokePanel.this._kso.setModifiedPreset(true);
                        KeyStrokePanel.this._tableModel.clear();
                        KeyStrokePanel.this.fillActions();
                        KeyStrokePanel.this._jksNewShortcut.clear();
                    }
                }
            };
            int mnemonic = KeyStrokeArb.getInteger(15);
            this._importAction.putValue("MnemonicKey", mnemonic);
        }
        return this._importAction;
    }

    private Action getExportAction() {
        if (this._exportAction == null) {
            this._exportAction = new AbstractAction(KeyStrokeArb.getString(16)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
                    KeyStrokeImporterExporter.exportCurrentShortcuts(kscr, KeyStrokePanel.this._kso);
                }
            };
            int mnemonic = KeyStrokeArb.getInteger(17);
            this._exportAction.putValue("MnemonicKey", mnemonic);
        }
        return this._exportAction;
    }

    private Action getLoadPresetAction() {
        if (this._loadPresetAction == null) {
            this._loadPresetAction = new AbstractAction(KeyStrokeArb.getString(18)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyStrokePanel.this.whenPreset();
                }
            };
            int mnemonic = KeyStrokeArb.getInteger(19);
            this._loadPresetAction.putValue("MnemonicKey", mnemonic);
        }
        return this._loadPresetAction;
    }

    private void fillActions() {
        TreeSet<ActionElement> actions = new TreeSet<ActionElement>(ActionElement.COMPARATOR);
        Iterator iKsc = KeyStrokePanel.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            this.fillActions(actions, ksc, true);
            this.fillActions(actions, ksc, false);
        }
        this._tableModel.clear();
        for (ActionElement nextAction : actions) {
            Set<ShortcutElement> shortcuts;
            String category = KeyStrokePanel.getCategory(nextAction._act);
            if (ModelUtil.hasLength((String)category)) {
                category = StringUtil.stripMnemonic((String)category);
            }
            if ((shortcuts = this.getShortcuts(nextAction)).size() == 0) {
                this._tableModel.addRow(category, nextAction, null);
                continue;
            }
            for (ShortcutElement shortcut : shortcuts) {
                this._tableModel.addRow(category, nextAction, shortcut);
            }
        }
        if (this._jchkHideUnmapped.isSelected()) {
            this._tableModel.search("", SearchMethod.REDO);
        }
        this.maybeRestoreSelectedRow(0);
    }

    private void fillActions(Set<ActionElement> actions, KeyStrokeContext ksc, boolean bGlobal) {
        Set setActions = KeyStrokePanel.getAllActions(ksc, bGlobal);
        if (setActions != null) {
            for (IdeAction act : setActions) {
                actions.add(new ActionElement(ksc, act, bGlobal));
            }
        }
    }

    private Set<ShortcutElement> getShortcuts(ActionElement actionElement) {
        HashSet<ShortcutElement> shortcuts = new HashSet<ShortcutElement>();
        if (actionElement != null) {
            IdeAction action = actionElement._act;
            KeyStrokeMap ksm = this._kso.getGlobalKeyMap();
            KeyStrokePanel.fillShortcuts(ksm, action, shortcuts);
            Iterator keyContextIter = KeyStrokePanel.getAllContexts();
            while (keyContextIter.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)keyContextIter.next();
                ksm = this._kso.getLocalKeyMap(ksc);
                KeyStrokePanel.fillShortcuts(ksm, action, shortcuts);
            }
        }
        return shortcuts;
    }

    private static void fillShortcuts(KeyStrokeMap ksm, IdeAction action, Set<ShortcutElement> shortcuts) {
        if (ksm != null) {
            List oStrokes = ksm.getKeyStrokesFor((Integer)action.getCommandId());
            for (KeyStrokes kss : oStrokes) {
                shortcuts.add(new ShortcutElement(ksm, kss));
            }
        }
    }

    private void fillCurrentAssign(KeyStrokes kss) {
        StringBuffer buffer = new StringBuffer();
        if (!kss.isEmpty()) {
            KeyStrokeMap ksm = this._kso.getGlobalKeyMap();
            this.getCurrentAssign(ksm, kss, buffer);
            Iterator iKsc = KeyStrokePanel.getAllContexts();
            while (iKsc.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
                ksm = this._kso.getLocalKeyMap(ksc);
                this.getCurrentAssign(ksm, kss, buffer);
            }
            this._jlblCurrentAssign.setText(buffer.toString());
        }
    }

    private void getCurrentAssign(KeyStrokeMap ksm, KeyStrokes kss, StringBuffer sBuffer) {
        String delim;
        String string = delim = sBuffer.length() == 0 ? "" : ", ";
        if (ksm != null) {
            List lAssigned = ksm.getKeyStrokesStartingWith(kss);
            for (int i = 0; i < lAssigned.size(); ++i) {
                KeyStrokes kssAssigned = (KeyStrokes)lAssigned.get(i);
                Integer binding = ksm.getBindingFor(kssAssigned);
                IdeAction action = this.findAction(binding);
                if (action == null) continue;
                sBuffer.append(delim);
                String category = KeyStrokePanel.getCategory(action);
                if (category != null) {
                    sBuffer.append(category).append(".");
                }
                sBuffer.append(KeyStrokePanel.getName(action));
            }
        }
    }

    private IdeAction findAction(int nID) {
        for (IdeAction act : KeyStrokePanel.getAllActions()) {
            if (act.getCommandId() != nID) continue;
            return act;
        }
        return null;
    }

    private void loadPreset(String sPreset) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        this._kso.loadPreset(kscr, sPreset);
        this.fillActions();
        this._jksNewShortcut.clear();
    }

    private void whenPreset() {
        String sCurrentPreset = this._kso.getPresetName();
        Frame parentFrame = this.getParentFrame();
        XMLKeystrokeContextDefs defs = XMLKeystrokeContextDefs.getInstance();
        String sNewPreset = PresetsPanel.run(parentFrame, sCurrentPreset);
        if (sNewPreset != null) {
            boolean bOk = true;
            if (this._kso.isModifiedPreset()) {
                bOk = this.confirm(parentFrame);
            }
            if (bOk) {
                this.loadPreset(sNewPreset);
            }
        }
        defs.unload();
    }

    private Frame getParentFrame() {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
    }

    private boolean confirm(Frame parentFrame) {
        String title = KeyStrokeArb.getString(23);
        String message = KeyStrokeArb.getString(24);
        String ok = KeyStrokeArb.getString(25);
        String cancel = KeyStrokeArb.getString(26);
        return MessageDialog.confirm((Component)parentFrame, (Object)message, (String)title, (String)"f1_idedloadpreset_html", (boolean)true, (String)ok, (String)cancel);
    }

    private void whenCategorySelectionChange() {
        this.fillActions();
    }

    private void whenTableSelectionChange() {
        int row = this.getTableModelRowIndex();
        if (row == -1) {
            this._jksNewShortcut.setEnabled(false);
            this._jbAdd.setEnabled(false);
            this._jbRemove.setEnabled(false);
            this._jbCopy.setEnabled(false);
            return;
        }
        ActionElement actE = this._tableModel.getActionElement(row);
        this._jksNewShortcut.setEnabled(actE != null);
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        this._jbAdd.setEnabled(!kss.isEmpty());
        ShortcutElement shortcut = this._tableModel.getShortcutElement(row);
        boolean hasShortcut = shortcut != null || this.getShortcuts(actE).size() > 0;
        this._jbRemove.setEnabled(hasShortcut);
        this._jbCopy.setEnabled(hasShortcut);
    }

    private void whenShortcutFieldChange() {
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        this.fillCurrentAssign(kss);
        this._jbAdd.setEnabled(!kss.isEmpty());
    }

    private void whenRemove() {
        ActionElement actionElement;
        Set<ShortcutElement> shortcuts;
        int row = this.getTableModelRowIndex();
        ShortcutElement se = this._tableModel.getShortcutElement(row);
        if (se != null) {
            se._map.remove(se._kss);
            this._kso.setModifiedPreset(true);
            this._tableModel.shortcutRemoved(row);
            this._jtActions.repaint();
        }
        if (!(shortcuts = this.getShortcuts(actionElement = this._tableModel.getActionElement(row))).isEmpty()) {
            int viewRow = this._jtActions.getSelectedRow();
            this._tableModel.removeRow(row);
            this._jtActions.reSort();
            this.maybeRestoreSelectedRow(viewRow);
        } else {
            this._jbRemove.setEnabled(false);
        }
    }

    private void whenAdd() {
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        int row = this.getTableModelRowIndex();
        ActionElement actionElement = this._tableModel.getActionElement(row);
        if (actionElement != null) {
            boolean bGlobal = actionElement._bGlobal;
            KeyStrokeContext ksc = actionElement._ksc;
            Iterator i = KeyStrokePanel.getAllContexts();
            while (i.hasNext()) {
                KeyStrokeContext kscI = (KeyStrokeContext)i.next();
                this.removeShortcutsStartingWith(kscI, kss, true);
                if (!bGlobal && kscI != ksc) continue;
                this.removeShortcutsStartingWith(kscI, kss, false);
            }
            KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
            IdeAction action = actionElement._act;
            ksm.put(kss, action.getCommandId());
            this._jlblCurrentAssign.setText("");
            this._jksNewShortcut.clear();
            this._kso.setModifiedPreset(true);
            this._jbRemove.setEnabled(true);
            this._jbCopy.setEnabled(true);
            this._tableModel.removeShortcutsStartingWith(kss);
            int modelRow = this._jtActions.convertRowToModelIndex(this._jtActions.getSelectedRow());
            this._tableModel.shortcutAdded(modelRow, new ShortcutElement(ksm, kss));
            this._jtActions.repaint();
        }
    }

    private void whenCopy() {
        int viewRow = this._jtActions.getSelectedRow();
        int modelRow = this._jtActions.convertRowToModelIndex(viewRow);
        int newModelRow = this._tableModel.duplicateRow(modelRow);
        this._jtActions.reSort();
        int newViewRow = this._jtActions.convertRowToViewIndex(newModelRow);
        this.maybeRestoreSelectedRow(newViewRow);
    }

    private void whenSearch(SearchMethod method) {
        Vector rowData = this.getSelectedRowData();
        this._tableModel.search(this._lastSearch, method);
        this._jtActions.reSort();
        this.maybeRestoreSelectedRow(rowData);
    }

    private void whenHideUnmappedCommands() {
        boolean hide = this._jchkHideUnmapped.isSelected();
        Vector rowData = this.getSelectedRowData();
        this._tableModel.setHideUnmappedCommands(hide);
        this._jtActions.reSort();
        this.maybeRestoreSelectedRow(rowData);
    }

    private int getTableModelRowIndex() {
        int[] rows = this._jtActions.getSelectedRowsInModel();
        return rows.length == 1 ? rows[0] : -1;
    }

    private Vector getSelectedRowData() {
        int row = this.getTableModelRowIndex();
        if (row != -1) {
            return this._tableModel.getFullRow(row);
        }
        return null;
    }

    private void maybeRestoreSelectedRow(Vector lastSelectedRow) {
        int modelRow = this._tableModel.getIndexForRow(lastSelectedRow);
        int tableRow = modelRow != -1 ? this._jtActions.convertRowToViewIndex(modelRow) : modelRow;
        this.maybeRestoreSelectedRow(tableRow);
    }

    private void maybeRestoreSelectedRow(int row) {
        int count = this._tableModel.getRowCount();
        int restore = Math.max(0, row < count ? row : 0);
        if (count > 0) {
            this._jtActions.getSelectionModel().setSelectionInterval(restore, restore);
            this._jtActions.scrollToSelection();
        }
    }

    private void removeShortcutsStartingWith(KeyStrokeContext ksc, KeyStrokes kss, boolean bGlobal) {
        KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
        KeyStrokePanel.removeShortcutsStartingWith(ksm, kss);
    }

    private static void removeShortcutsStartingWith(KeyStrokeMap ksm, KeyStrokes kss) {
        if (ksm != null) {
            List lKeys = ksm.getKeyStrokesStartingWith(kss);
            for (KeyStrokes key : lKeys) {
                ksm.remove(key);
            }
        }
    }

    private static String getName(IdeAction act) {
        return (String)act.getValue("Name");
    }

    private static String getCategory(IdeAction act) {
        String sCategory = (String)act.getValue("Category");
        if (sCategory == null) {
            sCategory = KeyStrokeArb.getString(8);
        }
        return sCategory;
    }

    private static Iterator getAllContexts() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        return kscr.getAllContexts();
    }

    private static Set getAllActions() {
        HashSet set = new HashSet();
        Iterator iter = KeyStrokePanel.getAllContexts();
        while (iter.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iter.next();
            for (int i = 0; i < 2; ++i) {
                Set setAllActions = KeyStrokePanel.getAllActions(ksc, i == 0);
                if (setAllActions == null) continue;
                set.addAll(setAllActions);
            }
        }
        return set;
    }

    private static Set getAllActions(KeyStrokeContext ksc, boolean global) {
        Set allActions = ksc.getAllActions(global);
        if (allActions == null || allActions.remove(null)) {
            // empty if block
        }
        return allActions;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (!e.getValueIsAdjusting() && src == this._jtActions.getSelectionModel()) {
            this.whenTableSelectionChange();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._jbRemove) {
            this.whenRemove();
        } else if (src == this._jbAdd) {
            this.whenAdd();
        } else if (src == this._jbCopy) {
            this.whenCopy();
        } else if (src == this._jbPresets) {
            this.whenPreset();
        } else if (src == this._jbMoreActions) {
            this.whenMoreActions();
        } else if (src == this._jksNewShortcut.getModel()) {
            this.whenShortcutFieldChange();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._jchkHideUnmapped) {
            this.whenHideUnmappedCommands();
        }
    }

    public void searchPerformed(SearchEvent se) {
        String searchStr = se.getSearchText().toLowerCase();
        if (searchStr.equals(this._lastSearch)) {
            return;
        }
        SearchMethod method = se.isFromClear() || this._lastSearch != null && !searchStr.startsWith(this._lastSearch) ? SearchMethod.REDO : (this._lastSearch != null && searchStr.startsWith(this._lastSearch) && searchStr.length() < this._lastSearch.length() ? SearchMethod.EXPAND : SearchMethod.REFINE);
        this._lastSearch = searchStr;
        this.whenSearch(method);
    }

    public void searchCategoryChanged(SearchEvent se) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keycode = e.getKeyCode();
        if ((127 == keycode || 8 == keycode) && this._jbRemove.isEnabled()) {
            this.whenRemove();
        }
    }

    private static enum SearchMethod {
        REFINE,
        EXPAND,
        REDO;

    }

    private static class KeyStrokeTableModel
    extends DefaultNiceTableModel {
        private String _matchText = "";
        private boolean _hideUnmapped;
        private final Vector _hiddenRows = new Vector();
        static final int CATEGORY_COLUMN = 0;
        static final int COMMAND_COLUMN = 1;
        static final int SHORTCUT_COLUMN = 2;
        static final int INTERNAL_KEY_COLUMN = 3;
        static int[] HIDDEN_COLUMNS = new int[]{3};
        static final String[] COLUMNS = new String[]{KeyStrokeArb.getString(0), KeyStrokeArb.getString(1), KeyStrokeArb.getString(2), "INTERNAL_ONLY"};

        KeyStrokeTableModel() {
            super.setColumnIdentifiers((Object[])COLUMNS);
        }

        public Comparator getColumnSortComparator(int column) {
            if (column >= 0 && column < COLUMNS.length) {
                switch (column) {
                    case 0: {
                        return String.CASE_INSENSITIVE_ORDER;
                    }
                    case 1: {
                        return ActionElement.COMPARATOR;
                    }
                    case 2: {
                        return ShortcutElement.COMPARATOR;
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            throw new IllegalStateException("Column index out of range: " + column);
        }

        String getCategory(int row) {
            return (String)this.getValueAt(row, 0);
        }

        ActionElement getActionElement(int row) {
            return (ActionElement)this.getValueAt(row, 1);
        }

        ShortcutElement getShortcutElement(int row) {
            return (ShortcutElement)this.getValueAt(row, 2);
        }

        Vector getFullRow(int row) {
            return (Vector)this.getDataVector().get(row);
        }

        void shortcutRemoved(int row) {
            super.setValueAt(null, row, 2);
            this.refreshKey(row);
        }

        void shortcutAdded(int row, ShortcutElement shortcut) {
            super.setValueAt((Object)shortcut, row, 2);
            this.refreshKey(row);
        }

        private void refreshKey(int row) {
            String key = this.key(this.getCategory(row), this.getActionElement(row), this.getShortcutElement(row));
            super.setValueAt((Object)key, row, 3);
        }

        void clear() {
            this.setRowCount(0);
            this._hiddenRows.clear();
        }

        void addRow(String category, ActionElement action, ShortcutElement shortcut) {
            Object[] rowData = this.newRow(category, action, shortcut);
            super.addRow(rowData);
        }

        private Object[] newRow(String category, ActionElement action, ShortcutElement shortcut) {
            Object[] rowData = new Object[COLUMNS.length];
            rowData[0] = category;
            rowData[1] = action;
            rowData[2] = shortcut;
            String key = this.key(category, action, shortcut);
            rowData[3] = key;
            return rowData;
        }

        private String key(String category, ActionElement action, ShortcutElement shortcut) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(category);
            buffer.append('$');
            buffer.append(action.toString());
            if (shortcut != null) {
                buffer.append('$');
                buffer.append(shortcut.toString());
            }
            return buffer.toString().toLowerCase();
        }

        int duplicateRow(int row) {
            Object[] rowData = this.newRow(this.getCategory(row), this.getActionElement(row), null);
            int newRow = row + 1;
            super.insertRow(newRow, rowData);
            return newRow;
        }

        private void search(String searchStr, SearchMethod method) {
            this._matchText = searchStr;
            if (method == SearchMethod.REFINE) {
                this.hideRows();
            } else if (method == SearchMethod.EXPAND) {
                this.unhideRows();
            } else if (method == SearchMethod.REDO) {
                Vector vector = this.getDataVector();
                int originalSize = vector.size();
                vector.addAll(this._hiddenRows);
                this.fireTableRowsInserted(originalSize, originalSize + this._hiddenRows.size());
                this._hiddenRows.clear();
                if (searchStr.length() > 0 || this.isHideUnmappedCommands()) {
                    this.hideRows();
                }
            }
        }

        private void unhideRows() {
            this.moveRows(this._hiddenRows, this.getDataVector(), true, EventNotification.INSERT);
        }

        private void hideRows() {
            this.moveRows(this.getDataVector(), this._hiddenRows, false, EventNotification.REMOVE);
        }

        private void moveRows(Vector from, Vector to, boolean matchCondition, EventNotification fireEvent) {
            if (!from.isEmpty()) {
                int i = from.size();
                while (--i >= 0) {
                    Vector nextRow = (Vector)from.get(i);
                    if (this.match(nextRow) != matchCondition) continue;
                    to.add(nextRow);
                    from.remove(i);
                    if (EventNotification.INSERT == fireEvent) {
                        int newRow = to.size() + 1;
                        this.fireTableRowsInserted(newRow, newRow);
                        continue;
                    }
                    if (EventNotification.REMOVE != fireEvent) continue;
                    this.fireTableRowsDeleted(i, i);
                }
            }
        }

        private boolean match(Vector rowData) {
            if (this.isHideUnmappedCommands() && rowData.get(2) == null) {
                return false;
            }
            if (this._matchText == null || this._matchText.length() == 0) {
                return true;
            }
            String toMatch = rowData.get(3).toString();
            return toMatch.indexOf(this._matchText) != -1;
        }

        private boolean isHideUnmappedCommands() {
            return this._hideUnmapped;
        }

        void setHideUnmappedCommands(boolean hide) {
            if (hide != this._hideUnmapped) {
                this._hideUnmapped = hide;
                this.showHideShortcuts();
            }
        }

        private void showHideShortcuts() {
            Vector visibleRows = this.getDataVector();
            if (this.isHideUnmappedCommands()) {
                int i = visibleRows.size();
                while (--i >= 0) {
                    Vector rowData = (Vector)visibleRows.get(i);
                    if (rowData.get(2) != null) continue;
                    this._hiddenRows.add(rowData);
                    visibleRows.remove(i);
                    this.fireTableRowsDeleted(i, i);
                }
            } else {
                int i = this._hiddenRows.size();
                while (--i >= 0) {
                    Vector rowData = (Vector)this._hiddenRows.get(i);
                    if (rowData.get(2) != null || !this.match(rowData)) continue;
                    visibleRows.add(rowData);
                    this._hiddenRows.remove(i);
                    int newRow = visibleRows.size() - 1;
                    this.fireTableRowsInserted(newRow, newRow);
                }
            }
        }

        int getIndexForRow(Vector rowData) {
            int ret = -1;
            try {
                String key;
                if (rowData != null && (key = (String)rowData.get(3)) != null) {
                    Vector vector = this.getDataVector();
                    for (int i = 0; i < vector.size(); ++i) {
                        Vector nextRow = (Vector)vector.get(i);
                        if (!key.equals(nextRow.get(3))) continue;
                        return i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }

        private void removeShortcutsStartingWith(KeyStrokes kss) {
            Vector rowData;
            int i;
            Vector v = this._hiddenRows;
            for (i = 0; i < v.size(); ++i) {
                rowData = (Vector)v.get(i);
                this.maybeRemoveConflict(kss, rowData);
            }
            v = this.getDataVector();
            for (i = 0; i < v.size(); ++i) {
                rowData = (Vector)v.get(i);
                if (!this.maybeRemoveConflict(kss, rowData)) continue;
                this.fireTableCellUpdated(i, 2);
            }
        }

        private boolean maybeRemoveConflict(KeyStrokes kss, Vector rowData) {
            ShortcutElement shortcut = (ShortcutElement)rowData.get(2);
            if (shortcut != null && shortcut._kss.startWith(kss)) {
                rowData.set(2, null);
                return true;
            }
            return false;
        }

        private static enum EventNotification {
            INSERT,
            REMOVE;

        }
    }

    private static final class ShortcutElement {
        final KeyStrokeMap _map;
        final KeyStrokes _kss;
        String _sortable;
        static final Comparator<ShortcutElement> COMPARATOR = new ShortcutElementComparator();

        ShortcutElement(KeyStrokeMap map, KeyStrokes kss) {
            this._map = map;
            this._kss = kss;
        }

        public final String toString() {
            return this._kss.toString();
        }

        private final String toSortableString() {
            if (this._sortable == null) {
                if (this._kss.isEmpty()) {
                    this._sortable = "";
                }
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < this._kss.getData().size(); ++i) {
                    KeyStroke keyStroke = this._kss.getKeyStroke(i);
                    b.append(KeyUtil.toSortableString(keyStroke));
                }
                this._sortable = b.toString();
            }
            return this._sortable;
        }

        private static class ShortcutElementComparator
        implements Comparator<ShortcutElement> {
            private ShortcutElementComparator() {
            }

            @Override
            public int compare(ShortcutElement o1, ShortcutElement o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.toSortableString().compareTo(o2.toSortableString());
            }
        }
    }

    private static class ActionElementRenderer
    extends DefaultTableCellRenderer {
        private final Icon nullIcon = new NullIcon();
        private final Border emptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);

        private ActionElementRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof ActionElement) {
                ActionElement ae = (ActionElement)value;
                Icon icon = (Icon)ae._act.getValue("SmallIcon");
                if (icon == null) {
                    icon = this.nullIcon;
                }
                this.setIcon(icon);
                this.setBorder(this.emptyBorder);
            }
            return c;
        }
    }

    private static final class ActionElement {
        final IdeAction _act;
        final KeyStrokeContext _ksc;
        final boolean _bGlobal;
        static final Comparator<ActionElement> COMPARATOR = new ActionElementComparator();

        ActionElement(KeyStrokeContext ksc, IdeAction act, boolean bGlobal) {
            this._ksc = ksc;
            this._act = act;
            this._bGlobal = bGlobal;
        }

        public final String toString() {
            String s = (String)this._act.getValue("NoCtxName");
            if (s != null && s.length() > 0) {
                return s;
            }
            String name = (String)this._act.getValue("Name");
            if (name != null) {
                return name;
            }
            int commandId = this._act.getCommandId();
            String command = this._act.getCommand();
            String message = "Action has no name: Command id= " + commandId + " ; Command = " + String.valueOf(command);
            FeedbackManager.reportException(message, new IllegalArgumentException());
            return "";
        }

        private static final class ActionElementComparator
        implements Comparator<ActionElement> {
            private ActionElementComparator() {
            }

            @Override
            public int compare(ActionElement action1, ActionElement action2) {
                String s1 = action1.toString() + action1._act.getCommand();
                String s2 = action2.toString() + action2._act.getCommand();
                int ret = String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                return ret;
            }
        }
    }
}

