/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.ExitNotAllowedException;
import oracle.ide.feedback.NullFeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.feedback.shared.MessageFeedback;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class FeedbackManager {
    private static final String FEEDBACK_MANAGER_NAME = "ide/feedback-manager";
    private static FeedbackManager _nullManager;
    private static boolean _isOn;
    public static final String PROPERTY_EXCEPTIONS = "exceptions";
    public static final String PROPERTY_INTERNAL = "internal";
    private final PropertyChangeSupport _pcs;
    @GuardedBy(value="hasExceptionsLock")
    private boolean _hasExceptions;
    private final Object _hasExceptionsLock = new Object();

    public FeedbackManager() {
        this._pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this._pcs.firePropertyChange(event);
    }

    protected abstract void addFeedbackImpl(Feedback var1);

    protected abstract void reportExceptionImpl(String var1, Throwable var2, boolean var3);

    protected abstract void reportExceptionImpl(String var1, Throwable var2, int var3, boolean var4);

    protected abstract void reportApiExceptionImpl(String var1, Throwable var2, String var3, boolean var4);

    public static void addFeedback(String message) {
        if (FeedbackManager.isOn()) {
            MessageFeedback feedback = new MessageFeedback(message);
            FeedbackManager.getFeedbackManager().addFeedbackImpl(feedback);
        }
    }

    public static void addFeedback(String message, Context context) {
        if (FeedbackManager.isOn()) {
            View view;
            if (context != null && (view = context.getView()) != null) {
                Class<?> viewClass = view.getClass();
                String viewName = viewClass.getName();
                message = message + "[ from " + viewName + " ]";
            }
            MessageFeedback feedback = new MessageFeedback(message);
            FeedbackManager.getFeedbackManager().addFeedbackImpl(feedback);
        }
    }

    public static boolean isOn() {
        return _isOn;
    }

    public static void reportException(String message, Throwable exception) {
        if (!(exception instanceof ExitNotAllowedException)) {
            FeedbackManager.getFeedbackManager().reportExceptionImpl(message, exception, true);
        }
    }

    public static void reportException(Throwable exception) {
        FeedbackManager.reportException("", exception);
    }

    public static void reportAPIException(String message, Throwable exception, String apiName) {
        FeedbackManager.getFeedbackManager().reportApiExceptionImpl(message, exception, apiName, true);
    }

    public static void reportAPIException(String message, Throwable exception, int apiDepth) {
        FeedbackManager.getFeedbackManager().reportExceptionImpl(message, exception, apiDepth, true);
    }

    public static FeedbackManager getFeedbackManager() {
        FeedbackManager feedbackManager = (FeedbackManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME);
        if (feedbackManager == null) {
            return FeedbackManager.getNullFeedbackManager();
        }
        return feedbackManager;
    }

    private static FeedbackManager getNullFeedbackManager() {
        if (_nullManager == null) {
            _nullManager = new NullFeedbackManager();
        }
        return _nullManager;
    }

    protected static void setFeedbackManager(FeedbackManager feedbackManager) {
        _isOn = feedbackManager != null;
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME, (Object)feedbackManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExceptions() {
        Object object = this._hasExceptionsLock;
        synchronized (object) {
            return this._hasExceptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptions(boolean exceptions) {
        Object object = this._hasExceptionsLock;
        synchronized (object) {
            final boolean oldHasExceptions = this._hasExceptions;
            this._hasExceptions = exceptions;
            if (oldHasExceptions == exceptions) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FeedbackManager.this.firePropertyChange(FeedbackManager.PROPERTY_EXCEPTIONS, oldHasExceptions, FeedbackManager.this._hasExceptions);
                }
            });
        }
    }

    public void showFeedbackDialog(boolean reportEnabled) {
    }

    public void flush() throws IOException {
    }

    public void clearExceptions() {
    }
}

