/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.JARExtensionSource;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;

public abstract class URLPathHandler
extends ElementVisitor {
    private static String DIRPATH = "Library-dirpath";

    public void start(ElementStartContext context) {
        try {
            JARExtensionSource source = (JARExtensionSource)context.getScopeData().get("extSource");
            context.getScopeData().put(DIRPATH, this.getDirPath(source.getURI().toURL()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected URL getDirPath(URL url) {
        if (url == null) {
            return null;
        }
        URL purl = url;
        if (JarUtil.isJarURL((URL)url)) {
            purl = JarUtil.getJarFileURL((URL)url);
        }
        return URLFileSystem.isDirectory((URL)purl) ? purl : URLFileSystem.getParent((URL)purl);
    }

    protected URL getDirPath(ElementContext context) {
        return (URL)context.getScopeData().get(DIRPATH);
    }

    protected void getURLPaths(URLPath newPath, String text, URL localpath) {
        if ((text = text.trim()).startsWith("http") || text.startsWith("https")) {
            newPath.add(URLFactory.newURL((String)text));
        } else {
            StringTokenizer tok = new StringTokenizer(text, ";");
            while (tok.hasMoreTokens()) {
                String entry;
                String base = entry = tok.nextToken().trim();
                String archiveEntry = null;
                String delimiter = "!" + File.separator;
                int idx = entry.indexOf(delimiter);
                if (idx > 0) {
                    base = entry.substring(0, idx);
                    archiveEntry = entry.substring(idx + delimiter.length());
                    if (File.separatorChar != '/') {
                        archiveEntry = archiveEntry.replace(File.separatorChar, '/');
                    }
                } else {
                    String ext;
                    idx = entry.lastIndexOf(46);
                    if (idx >= 0 && ("zip".equals(ext = entry.substring(idx + 1).toLowerCase()) || "jar".equals(ext))) {
                        archiveEntry = "";
                    }
                }
                URL url = this.relativePath(base) ? URLFactory.newURL((URL)localpath, (String)base) : URLFactory.newURL((String)base);
                url = archiveEntry != null ? URLFactory.newJarURL((URL)url, (String)archiveEntry) : URLFactory.newURL((URL)url, (String)"");
                newPath.add(url);
            }
        }
    }

    private boolean relativePath(String path) {
        return !path.startsWith("/") && path.length() > 2 && path.charAt(1) != ':';
    }
}

