/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerInfo;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.PinnableManager;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class ExplorerManager
extends PinnableManager {
    private static final String EXP_MGR_NAME = "ide/explorer-manager";
    public static final String SELECT_IN_STRUCTURE_CMD = "Explorer.SELECT_IN_STRUCTURE_CMD_ID";
    public static final int SELECT_IN_STRUCTURE_CMD_ID = Ide.findOrCreateCmdID("Explorer.SELECT_IN_STRUCTURE_CMD_ID");
    private static NullExplorerManager nullExplorerManager = null;

    public static ExplorerManager getExplorerManager() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullExplorerManager == null) {
                nullExplorerManager = new NullExplorerManager();
            }
            return nullExplorerManager;
        }
        return (ExplorerManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)EXP_MGR_NAME);
    }

    public static void setExplorerManager(ExplorerManager explorerManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)EXP_MGR_NAME, (Object)explorerManager);
    }

    public abstract boolean supportsStructure(View var1);

    public abstract ContextMenu getContextMenu();

    public abstract void register(Class var1, Class var2, Class var3);

    public abstract void register(Class var1, Class var2, Class var3, String var4, ArrayResourceBundle var5, int var6);

    public abstract void register(Class var1, Class var2, Class var3, String var4, ResourceBundle var5, String var6);

    public abstract void register(Class var1, Class var2, Class var3, String var4, Icon var5);

    public abstract void registerDynamic(ExplorerInfo var1);

    public abstract void unregister(ExplorerInfo var1);

    public abstract List getExplorerTypes(Class var1);

    public abstract List getExplorerTypes(Element var1);

    public abstract Icon getExplorerIcon(Class var1, Class var2);

    public abstract String getExplorerCaption(Class var1, Class var2);

    public abstract Explorer getExplorerForHost(View var1, Context var2);

    public abstract TreeExplorer createTreeExplorer(Folder var1);

    public void addStructureSupportForClass(MetaClass metaClass) {
    }

    public void removeStructureSupportForClass(MetaClass metaClass) {
    }

    private static class NullExplorerManager
    extends ExplorerManager {
        private NullExplorerManager() {
        }

        @Override
        public boolean supportsStructure(View view) {
            return false;
        }

        @Override
        public ContextMenu getContextMenu() {
            return null;
        }

        @Override
        public void register(Class dataType, Class explorerType, Class viewType) {
        }

        @Override
        @Deprecated
        public void register(Class dataType, Class explorerType, Class viewType, String caption, ArrayResourceBundle bundle, int key) {
        }

        @Override
        public void register(Class dataType, Class explorerType, Class viewType, String caption, ResourceBundle bundle, String key) {
        }

        @Override
        public void register(Class dataType, Class explorerType, Class viewType, String caption, Icon icon) {
        }

        @Override
        public void registerDynamic(ExplorerInfo info) {
        }

        @Override
        public void unregister(ExplorerInfo info) {
        }

        @Override
        public List getExplorerTypes(Class dataType) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getExplorerTypes(Element document) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Icon getExplorerIcon(Class explorerType, Class dataType) {
            return null;
        }

        @Override
        public String getExplorerCaption(Class explorerType, Class dataType) {
            return null;
        }

        @Override
        public Explorer getExplorerForHost(View host, Context context) {
            return null;
        }

        @Override
        public TreeExplorer createTreeExplorer(Folder folder) {
            return null;
        }

        @Override
        protected String getViewCategory() {
            return null;
        }

        @Override
        protected String getDefaultName() {
            return null;
        }

        @Override
        protected DockableView createDockableView(Context ctx, ViewId viewId) {
            return null;
        }

        @Override
        protected IdeAction createShowAction() {
            return null;
        }

        @Override
        protected DockableFactory getDockableFactory() {
            return null;
        }
    }
}

