/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DataContainer;
import oracle.javatools.util.ModelUtil;

public final class ExplorerContext {
    private static final String TNODES = "ExplorerContext.TNODES";
    private static final String EXPLORER_TYPE = "ExplorerContext.EXPLORER_TYPE";

    private ExplorerContext() {
    }

    public static TNode[] getTNodes(Context context) {
        TNode[] tnodes;
        if (context != null && (tnodes = (TNode[])context.getProperty(TNODES)) != null) {
            return tnodes;
        }
        return null;
    }

    public static void setTNodes(Context context, TNode[] tnodes) {
        if (context != null) {
            context.setProperty(TNODES, tnodes);
        }
    }

    public static Class getExplorerType(Context context) {
        if (context != null) {
            return (Class)context.getProperty(EXPLORER_TYPE);
        }
        return null;
    }

    public static void setExplorerType(Context context, Class explorerType) {
        if (context != null) {
            context.setProperty(EXPLORER_TYPE, explorerType);
        }
    }

    public static TNode getSingleTNode(Context context) {
        TNode[] tnodes = ExplorerContext.getTNodes(context);
        return tnodes != null && tnodes.length == 1 ? tnodes[0] : null;
    }

    public static TNode getFirstTNode(Context context) {
        TNode[] tnodes = ExplorerContext.getTNodes(context);
        return tnodes != null && tnodes.length > 0 ? tnodes[0] : null;
    }

    public static boolean hasNonSiblingTNodes(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes(context);
        if (nodes == null || nodes.length <= 1) {
            return false;
        }
        int i = 0;
        TNode parent = (TNode)nodes[i++].getParent();
        while (i < nodes.length) {
            if (nodes[i].getParent() != parent) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List storeExpansionState(TNode root, TreeExplorer explorer) {
        explorer.getContext();
        JTree tree = explorer.getJTree();
        Enumeration<TreePath> e = tree.getExpandedDescendants(new TreePath(root.getPath()));
        TreeSet<TreePath> expandedSet = new TreeSet<TreePath>(new TreePathComparator());
        if (e != null) {
            while (e.hasMoreElements()) {
                TreePath tp = e.nextElement();
                expandedSet.add(tp);
            }
        }
        Iterator iter = expandedSet.iterator();
        ArrayList<ExpandInfo> result = new ArrayList<ExpandInfo>();
        while (iter.hasNext()) {
            TreePath tp = (TreePath)iter.next();
            String tpStr = ExplorerContext.convertTreePathToString(tp);
            ExpandInfo info = new ExpandInfo(tpStr);
            result.add(info);
            TNode tnode = (TNode)tp.getLastPathComponent();
            Object tnodeData = tnode.getData().getData();
            if (!(tnodeData instanceof DataContainer)) continue;
            DataContainer dc = (DataContainer)tnodeData;
            info._url = dc.getURL();
        }
        return result;
    }

    public static void restoreExpansionState(TNode tnode, TreeExplorer explorer, List expandDataList) {
        explorer.getContext();
        JTree tree = explorer.getJTree();
        if (tree != null) {
            if (!tree.isRootVisible()) {
                TNode root = explorer.getRoot();
                explorer.expand(root, false, false);
            }
            if (expandDataList != null) {
                ArrayList expandedTNodes = new ArrayList(expandDataList.size());
                ExplorerContext.checkExpansionState(tnode, expandDataList, 0, expandedTNodes);
                for (int i = 0; i < expandedTNodes.size(); ++i) {
                    TreePath tp = (TreePath)expandedTNodes.get(i);
                    tree.expandPath(tp);
                }
            }
        }
    }

    public static List storeSelectionState(TreeExplorer explorer) {
        JTree tree = explorer.getJTree();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        int count = selectionPaths != null ? selectionPaths.length : 0;
        ArrayList<TreePath> result = new ArrayList<TreePath>(count);
        for (int i = 0; i < count; ++i) {
            result.add(selectionPaths[i]);
        }
        return result;
    }

    public static void restoreSelectionState(TreeExplorer explorer, List selectionData) {
        int count;
        JTree tree = explorer.getJTree();
        explorer.getRoot();
        int n = count = selectionData != null ? selectionData.size() : 0;
        if (count == 1 && selectionData.contains(tree.getSelectionPath())) {
            return;
        }
        tree.clearSelection();
        for (int i = 0; i < count; ++i) {
            TreePath tpOld = (TreePath)selectionData.get(i);
            TreePath tp = ExplorerContext.findNewPath(explorer.getRoot(), tpOld, false);
            if (tp == null) continue;
            tree.addSelectionPath(tp);
            tree.scrollPathToVisible(tp);
        }
    }

    private static String convertTreePathToString(TreePath tp) {
        String path = "";
        Object[] objs = tp.getPath();
        for (int i = 0; i < objs.length; ++i) {
            TNode tnode = (TNode)objs[i];
            path = path + tnode.getData().getLongLabel() + ",";
        }
        return path;
    }

    private static void checkExpansionState(TNode tnode, List savedStates, int level, List expandedTNodes) {
        TreePath tp = new TreePath(tnode.getPath());
        String tpStr = ExplorerContext.convertTreePathToString(tp);
        if (!ExplorerContext.wasExpanded(tpStr, savedStates, level)) {
            return;
        }
        TreeExplorer explorer = tnode.getOwner();
        if (explorer != null) {
            explorer.open(tnode);
        }
        Enumeration children = tnode.getChildTNodes();
        expandedTNodes.add(tp);
        ++level;
        while (children.hasMoreElements()) {
            tnode = (TNode)children.nextElement();
            if (level >= savedStates.size()) continue;
            ExplorerContext.checkExpansionState(tnode, savedStates, level, expandedTNodes);
        }
    }

    private static boolean wasExpanded(String livePath, List savedPaths, int level) {
        for (int i = level; i < savedPaths.size(); ++i) {
            ExpandInfo savedInfo = (ExpandInfo)savedPaths.get(i);
            if (!livePath.equals(savedInfo._nodePath)) continue;
            return true;
        }
        return false;
    }

    public static TreePath findNewPath(TNode currentRoot, TreePath oldPath, boolean matchFullPath) {
        if (currentRoot == null || oldPath == null) {
            return null;
        }
        Object[] oldNodes = oldPath.getPath();
        if (oldNodes == null || oldNodes.length == 0) {
            return null;
        }
        Object[] currentNodes = new Object[oldNodes.length];
        TNode node = currentRoot;
        currentNodes[0] = currentRoot;
        for (int i = 1; i < oldNodes.length; ++i) {
            TNode oldNode = (TNode)oldNodes[i];
            String longLabel = oldNode.getData().getLongLabel();
            TNode child = ExplorerContext.findChildWithLongLabel(node, longLabel);
            if (child == null) {
                if (matchFullPath) {
                    return null;
                }
                Object[] result = new Object[i];
                System.arraycopy(currentNodes, 0, result, 0, i);
                return new TreePath(result);
            }
            currentNodes[i] = child;
            node = child;
        }
        return new TreePath(currentNodes);
    }

    private static TNode findChildWithLongLabel(TNode node, String longLabel) {
        Enumeration children = node.getChildTNodes();
        while (children.hasMoreElements()) {
            TNode child = (TNode)children.nextElement();
            if (child == null || !ModelUtil.areEqual((Object)child.getData().getLongLabel(), (Object)longLabel)) continue;
            return child;
        }
        return null;
    }

    public static TNode findDescendentWithLongLabel(TNode node, String longLabel) {
        Enumeration children = node.getChildTNodes();
        while (children.hasMoreElements()) {
            TNode possibleDescendant;
            TNode child = (TNode)children.nextElement();
            if (child != null && ModelUtil.areEqual((Object)child.getData().getLongLabel(), (Object)longLabel)) {
                return child;
            }
            if (child.getChildCount() <= 0 || (possibleDescendant = ExplorerContext.findDescendentWithLongLabel(child, longLabel)) == null) continue;
            return possibleDescendant;
        }
        return null;
    }

    static class TreePathComparator
    implements Comparator {
        TreePathComparator() {
        }

        public int compare(Object o1, Object o2) {
            int len2;
            if (o1 == o2) {
                return 0;
            }
            int len1 = ((TreePath)o1).getPathCount();
            if (len1 < (len2 = ((TreePath)o2).getPathCount())) {
                return -1;
            }
            return 1;
        }
    }

    public static class ExpandInfo {
        public URL _url;
        public String _nodePath;

        public ExpandInfo() {
        }

        public ExpandInfo(String nodePath) {
            this(nodePath, null);
        }

        public ExpandInfo(String nodePath, URL url) {
            this._url = url;
            this._nodePath = nodePath;
        }
    }
}

