/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.ide.editor.FileSaveListener;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class FileSaveHook
extends HashStructureHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "file-save-hook");
    private List<FileSaveListener> listeners = null;

    public static FileSaveHook getHook() {
        return (FileSaveHook)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
    }

    public FileSaveHook() {
        super(true);
    }

    public synchronized List<FileSaveListener> fileSaveListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<FileSaveListener>();
            for (MetaClass type : this.fileSaveListenerTypes()) {
                try {
                    FileSaveListener l = (FileSaveListener)type.newInstance();
                    this.listeners.add(l);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return this.listeners;
    }

    private List<MetaClass> fileSaveListenerTypes() {
        List<HashStructure> listeners = this.fileSaveListenersList();
        ArrayList<MetaClass> classes = new ArrayList<MetaClass>();
        ArrayList<String> addedClasses = new ArrayList<String>();
        for (HashStructure listener : listeners) {
            List metaClasses = listener.getAsList("file-save-listener");
            if (metaClasses == null) continue;
            for (int i = 0; i < metaClasses.size(); ++i) {
                String metaClassName;
                HashStructure hash = (HashStructure)metaClasses.get(i);
                MetaClass metaClass = LazyClassAdapter.getInstance(hash).getMetaClass("class");
                if (metaClass == null || addedClasses.contains(metaClassName = metaClass.getClassName())) continue;
                classes.add(metaClass);
                addedClasses.add(metaClassName);
            }
        }
        return classes;
    }

    private List<HashStructure> fileSaveListenersList() {
        ArrayList<HashStructure> list = new ArrayList<HashStructure>();
        HashStructure hashStructure = this.getHashStructure();
        List listeners = hashStructure.getAsList("file-save-listeners");
        if (listeners == null) {
            return list;
        }
        for (Object o : listeners) {
            if (!(o instanceof HashStructure)) continue;
            list.add((HashStructure)o);
        }
        return list;
    }
}

