/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerDecorator;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.view.View;

final class DrawerWindowModel {
    private final DrawerWindow drawerWindow;
    private final List<Drawer> drawers = new ArrayList<Drawer>();
    private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();

    DrawerWindowModel(DrawerWindow drawerWindow) {
        this.drawerWindow = drawerWindow;
    }

    Drawer addDrawer(View view, DrawerConfig config) {
        config.uniqueName(view.getId());
        DrawerDecorator decorator = DrawerDecorator.decorate(view, config);
        Drawer drawer = new Drawer(decorator, config, this.drawerWindow);
        return this.add(drawer, config, decorator);
    }

    Drawer addDrawerThatCanHideHandle(DockableWindow view) {
        Drawer added = this.addDrawer(view);
        added.canHideHandle();
        return added;
    }

    Drawer addCloseableDrawer(DockableWindow view, int index) {
        DrawerConfig config = new DrawerConfig(view, index);
        Drawer drawer = new Drawer(view, config, this.drawerWindow);
        drawer.beClosable();
        return this.add(drawer, config, view);
    }

    Drawer addDrawer(DockableWindow view) {
        DrawerConfig config = new DrawerConfig(view);
        Drawer drawer = new Drawer(view, config, this.drawerWindow);
        return this.add(drawer, config, view);
    }

    Drawer addDrawer(DockableWindow view, int index) {
        DrawerConfig config = new DrawerConfig(view, index);
        Drawer drawer = new Drawer(view, config, this.drawerWindow);
        return this.add(drawer, config, view);
    }

    private Drawer add(Drawer drawer, DrawerConfig config, DockableWindow view) {
        int index = this.index(config);
        this.drawers.add(index, drawer);
        DockStation.getDockStation().addToCache(view);
        this.fire(new ListDataEvent(this, 1, index, index));
        return drawer;
    }

    private int index(DrawerConfig config) {
        return config.index() >= 0 ? config.index() : this.drawers.size();
    }

    List<Drawer> drawers() {
        return new ArrayList<Drawer>(this.drawers);
    }

    void addListener(ListDataListener l) {
        this.listeners.add(l);
    }

    void removeListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    int drawerCount() {
        return this.drawers.size();
    }

    boolean hasDrawers() {
        return !this.drawers.isEmpty();
    }

    Drawer drawerAt(int index) {
        return this.drawers.get(index);
    }

    int indexOf(DrawerUI drawerUI) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            if (!drawerUI.equals(this.drawers.get(i).drawerUI())) continue;
            return i;
        }
        return -1;
    }

    public List<View> views() {
        ArrayList<View> views = new ArrayList<View>(this.drawerCount());
        for (Drawer drawer : this.drawers) {
            views.add(drawer.viewWithoutDecoration());
        }
        return views;
    }

    int indexOf(View view) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            if (!this.drawers.get(i).hasView(view)) continue;
            return i;
        }
        return -1;
    }

    Drawer removeDrawerIfPresent(View view) {
        int index = this.indexOf(view);
        if (index >= 0) {
            return this.removeDrawer(index);
        }
        return null;
    }

    Drawer removeDrawer(View view) {
        return this.removeDrawer(this.indexOf(view));
    }

    private Drawer removeDrawer(int index) {
        ListDataEvent event = new ListDataEvent(this, 2, index, index);
        this.fire(event);
        Drawer removed = this.drawers.remove(index);
        if (removed != null) {
            DockStation.getDockStation().removeFromCache(removed.uniqueName());
        }
        return removed;
    }

    private void fire(ListDataEvent e) {
        for (ListDataListener l : this.listeners) {
            if (!this.contentsChangedEventFired(e, l) && !this.intervalAddedEventFired(e, l) && !this.intervalRemovedEventFired(e, l)) continue;
        }
    }

    private boolean contentsChangedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 0) {
            return false;
        }
        l.contentsChanged(e);
        return true;
    }

    private boolean intervalAddedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 1) {
            return false;
        }
        l.intervalAdded(e);
        return true;
    }

    private boolean intervalRemovedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 2) {
            return false;
        }
        l.intervalRemoved(e);
        return true;
    }

    void move(Drawer drawer, int newIndex) {
        int oldIndex = this.drawers.indexOf(drawer);
        this.drawers.remove(oldIndex);
        if (oldIndex < newIndex) {
            --newIndex;
        }
        this.drawers.add(newIndex, drawer);
    }
}

