/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RotatingIcon;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DrawerLabel;
import oracle.ide.docking.DrawerWindowUI;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

final class DrawerUI
extends JPanel {
    private static final int MIN_TITLE_HEIGHT = 17;
    private static final Border TITLE_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 2);
    private static final int CURSOR_EDGE_THRESHOLD = 3;
    private boolean mouseOver = false;
    private boolean menuRaised = false;
    private final Subcomponents subcomponents;
    private View view;
    private Component hosted;
    private double ratio = 1.0;
    private double expansionRatio = 0.0;
    private boolean active;
    private boolean shouldRotateIcon = true;
    private MenuToolButton dropDownButton;
    private final DropDownMouseOver dropDownMouseOver = new DropDownMouseOver();
    private boolean canHideHandle;

    DrawerUI(String text, View view) {
        super(new GridBagLayout());
        this.makeDebuggingEasier(text);
        this.view = view;
        Toolbar customToolbar = view.getToolbar();
        this.forceCustomToolbarToHaveNoVisualStyles(customToolbar);
        this.subcomponents = new Subcomponents(text, customToolbar);
        this.init();
        Component gui = view.getGUI();
        if (gui == null) {
            throw new IllegalStateException(view.getClass().getName() + "(" + text + ") should have a GUI");
        }
        this.hostComponent(gui);
    }

    private void makeDebuggingEasier(String drawerText) {
        this.setName("DrawerUI: " + drawerText);
    }

    private void forceCustomToolbarToHaveNoVisualStyles(Toolbar customToolbar) {
        if (customToolbar != null) {
            customToolbar.forcePrimaryViewToolbar(false);
        }
    }

    void shouldRotateIcon() {
        this.shouldRotateIcon = true;
    }

    void shouldNotRotateIcon() {
        this.shouldRotateIcon = false;
    }

    private void init() {
        this.addSubcomponents();
        this.initBackgroundColor();
        this.addMouseListener(this.dropDownMouseOver);
    }

    private void addSubcomponents() {
        this.showComponents();
    }

    private GridBagConstraints constraintsForTitle() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 1;
        return c;
    }

    private GridBagConstraints constraintsForCustomToolbar() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        return c;
    }

    private GridBagConstraints constraintsForButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = this.subcomponents.customToolbar != null ? 2 : 1;
        c.gridy = 0;
        c.fill = 1;
        return c;
    }

    private void initBackgroundColor() {
        this.setOpaque(false);
    }

    void canHideHandle() {
        this.canHideHandle = true;
    }

    void hideHandle() {
        if (!this.canHideHandle) {
            return;
        }
        this.hideComponents();
    }

    void showHandle() {
        this.showComponents();
    }

    private void showComponents() {
        this.add((Component)this.subcomponents.title, this.constraintsForTitle());
        if (this.subcomponents.customToolbar != null) {
            this.add((Component)this.subcomponents.customToolbar, this.constraintsForCustomToolbar());
        }
        this.add((Component)this.subcomponents.buttons, this.constraintsForButtons());
    }

    private void hideComponents() {
        this.remove(this.subcomponents.title);
        if (this.subcomponents.customToolbar != null) {
            this.remove(this.subcomponents.customToolbar);
        }
        this.remove(this.subcomponents.buttons);
    }

    Component hostedComponent() {
        return this.hosted;
    }

    void hostComponent(Component toHost) {
        if (this.hosted != null) {
            this.remove(this.hosted);
        }
        this.hosted = toHost;
        this.addActivationFocusListener();
        this.addHostedComponent();
    }

    private void addActivationFocusListener() {
        if (this.hosted == null) {
            return;
        }
        JComponent focusable = this.focusableFromHosted();
        if (focusable == null) {
            return;
        }
        focusable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DrawerWindowUI parent = DrawerUI.this.parent();
                if (parent == null) {
                    return;
                }
                parent.activate(DrawerUI.this);
                parent.expandIfNecessary(DrawerUI.this);
                DrawerUI.this.ensureSomethingIsSelected(e.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
                DrawerWindowUI parent = DrawerUI.this.parent();
                if (parent != null) {
                    parent.deactivate(DrawerUI.this);
                }
            }
        });
    }

    private void ensureSomethingIsSelected(Component c) {
        if (!(c instanceof JTree)) {
            return;
        }
        JTree tree = (JTree)c;
        int count = tree.getSelectionCount();
        if (count == 0 && tree.getRowCount() > 0) {
            tree.setSelectionRow(0);
        }
    }

    private void addHostedComponent() {
        if (this.hosted == null) {
            return;
        }
        this.add(this.hosted, this.constraintsForHostedComponent());
    }

    private GridBagConstraints constraintsForHostedComponent() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 99;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        return c;
    }

    private Insets defaultInsets() {
        return new Insets(2, 0, 0, 0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (Themes.isThemed()) {
            this.paintWithTheme(graphics);
        } else {
            this.paintWithoutTheme(graphics);
        }
    }

    private Painter getThemePainter(String state) {
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion", state);
        return properties.getPainter("bg");
    }

    private void paintWithTheme(Graphics graphics) {
        Painter painter = this.getThemePainter(this.active ? "active" : "inactive");
        Insets insets = this.getInsets();
        painter.paint(graphics, insets.left, insets.top, this.widthForPainting(), this.heightForPainting());
        if (this.mouseOver) {
            this.paintMouseOverHighlight(graphics);
        }
    }

    private void paintMouseOverHighlight(Graphics g) {
        if (this.isTopDrawer()) {
            return;
        }
        Painter painter = this.getThemePainter("mouseover");
        Insets insets = this.getInsets();
        painter.paint(g, insets.left, insets.top, this.widthForPainting(), this.heightForPainting());
    }

    private void paintWithoutTheme(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int height = this.heightForPainting();
        int width = this.widthForPainting();
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setPaint(new GradientPaint(insets.left, insets.top, this.lightColor(), insets.left, height - 1, this.darkColor()));
        g2d.fillRect(insets.left, insets.top, width, height);
    }

    private int heightForPainting() {
        Insets insets = this.getInsets();
        return this.hosted.getHeight() > 0 ? this.hosted.getY() - insets.top : this.getHeight() - insets.top - insets.bottom;
    }

    private int widthForPainting() {
        Insets insets = this.getInsets();
        return this.getWidth() - (insets.left + insets.right);
    }

    private Color lightColor() {
        return this.active ? IdeUIManager.getActiveTitleGradientLightColor() : IdeUIManager.getInactiveTitleGradientLightColor();
    }

    private Color darkColor() {
        return this.active ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor();
    }

    private boolean isTopDrawer() {
        return this.parent().visibleDrawers().indexOf(this) == 0;
    }

    private void expand(MouseEvent event) {
        if (event.isControlDown() && !this.expanded()) {
            this.parent().expand(this);
            return;
        }
        this.parent().toggleVisibility(this);
    }

    private DrawerWindowUI parent() {
        return (DrawerWindowUI)this.getParent();
    }

    boolean expanded() {
        return this.expansionRatio > 0.0;
    }

    private void minimize() {
        this.parent().minimizeWithAnimation(this);
    }

    private void maximize() {
        this.parent().maximize(this);
    }

    void activate() {
        this.active = true;
        this.repaintTitle();
    }

    JComponent focusableFromHosted() {
        return GraphicsUtils.getFocusableComponentOrChild((Component)this.hostedComponent(), (boolean)true);
    }

    void deactivate() {
        this.active = false;
        this.repaintTitle();
    }

    private void repaintTitle() {
        this.repaint(0, 0, this.getWidth(), this.getHeight() - this.hosted.getHeight());
    }

    boolean active() {
        return this.active;
    }

    void minimizable(boolean minimizable) {
    }

    void updateDropDownButton(MenuToolButton button) {
        this.dropDownButton = button;
        this.dropDownMouseOver.hideIcon();
        button.addMouseListener(this.dropDownMouseOver);
        button.getPopupMenu().addPopupMenuListener(this.dropDownMouseOver);
        if (this.subcomponents.customToolbar instanceof Toolbar) {
            this.subcomponents.buttons.addSeparator();
        }
        this.addButton(button);
    }

    void addButton(JComponent button) {
        button.setRequestFocusEnabled(false);
        this.subcomponents.buttons.add(button);
    }

    void expanded(boolean expanded) {
        this.expansionRatio(expanded ? 1.0 : 0.0);
    }

    double expansionRatio() {
        return this.expansionRatio;
    }

    void expansionRatio(double expansionRatio) {
        double oldExpansionRatio = this.expansionRatio;
        this.expansionRatio = expansionRatio;
        if (this.shouldRotateIcon) {
            RotatingIcon rotatingIcon = (RotatingIcon)this.subcomponents.title.getIcon();
            rotatingIcon.setRotation(Math.PI * expansionRatio / 2.0);
        }
        if (oldExpansionRatio == 0.0 && this.expansionRatio != 0.0) {
            this.view.fireViewExpanded();
        } else if (oldExpansionRatio != 0.0 && this.expansionRatio == 0.0) {
            this.view.fireViewCollapsed();
        }
    }

    double ratio() {
        return this.ratio * this.expansionRatio;
    }

    void ratio(double ratio) {
        this.ratio = ratio;
    }

    int titlebarHeight() {
        int h = this.getPreferredSize().height;
        if (this.hosted != null && this.hosted.isVisible()) {
            h -= this.hosted.getPreferredSize().height;
        }
        return h;
    }

    private final class Subcomponents {
        final JLabel handle = new JLabel(IdeIcons.getIcon((int)11));
        final Toolbar buttons = new Toolbar();
        final JLabel title;
        final JComponent customToolbar;

        Subcomponents(String text, Toolbar customToolbar) {
            this.title = new DrawerLabel(text, this.rotatingIcon(), 10);
            this.title.setBorder(TITLE_BORDER);
            this.customToolbar = this.visibleToolbar(customToolbar) ? customToolbar : this.fakeToolbar();
            this.init();
        }

        private JComponent fakeToolbar() {
            return (JComponent)Box.createVerticalStrut(17);
        }

        private boolean visibleToolbar(Toolbar customToolbar) {
            return customToolbar != null && customToolbar.isVisible();
        }

        private Icon rotatingIcon() {
            return new RotatingIcon(OracleIcons.getIcon((String)"extras/accordion_open.png"));
        }

        private void init() {
            this.setUpDropDownButtons();
            this.disableRequestForFocus();
            this.registerMouseAdapter();
            this.setUpCustomToolbar();
        }

        private void setUpDropDownButtons() {
            this.buttons.setOpaque(false);
            this.buttons.setBorderPainted(false);
        }

        private void disableRequestForFocus() {
            this.handle.setRequestFocusEnabled(false);
            this.title.setRequestFocusEnabled(false);
        }

        private void registerMouseAdapter() {
            MouseAdapter mouseAdapter = new MouseAdapter();
            mouseAdapter.registerWith(this.handle);
            mouseAdapter.registerWith(this.title);
            DrawerUI.this.dropDownMouseOver.registerWith(this.handle);
            DrawerUI.this.dropDownMouseOver.registerWith(this.title);
        }

        private void setUpCustomToolbar() {
            if (this.customToolbar == null) {
                return;
            }
            this.customToolbar.setOpaque(false);
            this.customToolbar.setBorder(BorderFactory.createEmptyBorder());
            if (this.customToolbar instanceof Toolbar) {
                ((Toolbar)this.customToolbar).setPrimaryViewToolbar(false);
            }
        }
    }

    private final class MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    ActionListener {
        private MouseAdapter() {
        }

        void registerWith(Component host) {
            host.addMouseListener(this);
            host.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (((DrawerUI)DrawerUI.this).subcomponents.title == event.getSource()) {
                DrawerUI.this.expand(event);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            DrawerUI.this.parent().mousePressed(DrawerUI.this, event);
            DrawerUI.this.parent().activate(DrawerUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            DrawerUI.this.parent().mouseReleased(DrawerUI.this, event);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            DrawerUI.this.parent().mouseDragged(DrawerUI.this, event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.minimizeHandled(event.getActionCommand())) {
                return;
            }
            this.maximizeHandled(event.getActionCommand());
        }

        private boolean minimizeHandled(String actionCommand) {
            if (!"Minimize".equals(actionCommand)) {
                return false;
            }
            DrawerUI.this.minimize();
            return true;
        }

        private boolean maximizeHandled(String actionCommand) {
            if (!"Maximize".equals(actionCommand)) {
                return false;
            }
            DrawerUI.this.maximize();
            return true;
        }
    }

    private final class DropDownMouseOver
    extends java.awt.event.MouseAdapter
    implements MouseMotionListener,
    PopupMenuListener {
        private boolean canHideIcon = true;

        private DropDownMouseOver() {
        }

        private void registerWith(Component c) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateCursor(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.showIcon();
            this.updateCursor(e);
            DrawerUI.this.mouseOver = true;
            DrawerUI.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hideIcon();
            this.updateCursor(e);
            DrawerUI.this.mouseOver = false;
            DrawerUI.this.repaint();
            this.canHideIcon = true;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.showIcon();
            this.canHideIcon = false;
            DrawerUI.this.menuRaised = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DrawerUI.this.menuRaised = false;
            this.hideIcon();
            this.canHideIcon = true;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.canHideIcon = true;
            DrawerUI.this.menuRaised = false;
        }

        void showIcon() {
            if (!Themes.isThemed() || DrawerUI.this.dropDownButton == null) {
                return;
            }
            String state = DrawerUI.this.active ? "active" : "inactive";
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion.dropdown", state);
            DrawerUI.this.dropDownButton.setIcon(properties.getIcon("icon"));
        }

        void hideIcon() {
            if (!Themes.isThemed() || DrawerUI.this.dropDownButton == null || !this.canHideIcon || DrawerUI.this.menuRaised) {
                return;
            }
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion.dropdown", "invisible");
            DrawerUI.this.dropDownButton.setIcon(properties.getIcon("icon"));
        }

        void updateCursor(MouseEvent e) {
            int y;
            if (e.getID() == 505) {
                this.hideMoveCursor();
            }
            if ((y = e.getY()) >= 0 && y < 3 || y > DrawerUI.this.heightForPainting() - 3 && y < DrawerUI.this.heightForPainting()) {
                this.showMoveCursor();
            } else {
                this.hideMoveCursor();
            }
        }

        void hideMoveCursor() {
            DrawerUI.this.setCursor(Cursor.getDefaultCursor());
        }

        void showMoveCursor() {
            if (DrawerUI.this.isTopDrawer()) {
                return;
            }
            DrawerUI.this.setCursor(Cursor.getPredefinedCursor(9));
        }
    }
}

