/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.view.View;

final class DrawerDecorator
extends DockableWindow {
    private String tabName;
    private String uniqueName;
    final View decorated;

    static DrawerDecorator decorate(View toDecorate, DrawerConfig config) {
        if (!(toDecorate instanceof DrawerDecorator)) {
            return new DrawerDecorator(toDecorate, config);
        }
        DrawerDecorator decorator = (DrawerDecorator)toDecorate;
        decorator.applyConfig(config);
        return decorator;
    }

    private DrawerDecorator(View decorated, DrawerConfig config) {
        super(decorated);
        this.decorated = decorated;
        this.applyConfig(config);
    }

    private void applyConfig(DrawerConfig config) {
        String tabName;
        if (config != null) {
            this.tabName = config.tabName();
            this.uniqueName = config.uniqueName();
        }
        if ((tabName = this.decorated.getTabName()) != null) {
            this.tabName = tabName;
        }
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public String getTitleName() {
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }
}

