/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import oracle.ide.docking.DockableWindow;
import oracle.ide.util.PropertyAccess;

public final class DrawerConfig {
    private static final String STATE_PROPERTY = "State";
    private static final String TAB_NAME_PROPERTY = "TabName";
    private static final String UNIQUE_NAME_PROPERTY = "UniqueName";
    private State state = State.defaultState();
    private String tabName;
    private String uniqueName;
    private int index = -1;

    public DrawerConfig() {
    }

    public DrawerConfig(DockableWindow view, int index) {
        this(view);
        this.index(index);
    }

    public DrawerConfig(DockableWindow view) {
        this.uniqueName(view.getUniqueName());
        this.tabName(view.getTabName());
    }

    public DrawerConfig(String tabName, State state) {
        this(tabName);
        this.state(state);
    }

    public DrawerConfig(String tabName) {
        this.tabName(tabName);
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        this.state = state;
    }

    public String tabName() {
        return this.tabName;
    }

    public void tabName(String tabName) {
        this.tabName = tabName;
    }

    public int index() {
        return this.index;
    }

    public void index(int index) {
        this.index = index;
    }

    String uniqueName() {
        return this.uniqueName;
    }

    void uniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    void storeProperties(PropertyAccess p) {
        p.setProperty(STATE_PROPERTY, this.state().name());
        p.setProperty(TAB_NAME_PROPERTY, this.tabName);
        p.setProperty(UNIQUE_NAME_PROPERTY, this.uniqueName());
    }

    public static enum State {
        VISIBLE,
        HIDDEN,
        DETACHED,
        MINIMIZED,
        HIDDEN_AND_MINIMIZED;


        public static State defaultState() {
            return VISIBLE;
        }
    }
}

