/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.net.URL;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@Immutable
public final class URLChooserShortcut {
    private final String _label;
    private final Icon _icon;
    private final URL _url;

    public URLChooserShortcut(Icon icon, String label, URL url) {
        if (icon == null) {
            throw new NullPointerException("icon is null");
        }
        if (label == null) {
            throw new NullPointerException("label is null");
        }
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        this._icon = icon;
        this._label = label;
        this._url = url;
    }

    public Icon icon() {
        return this._icon;
    }

    public String label() {
        return this._label;
    }

    public URL url() {
        return this._url;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URLChooserShortcut)) {
            return false;
        }
        URLChooserShortcut other = (URLChooserShortcut)object;
        if (!this._label.equals(other._label)) {
            return false;
        }
        if (!this._icon.equals(other._icon)) {
            return false;
        }
        return this._url.toString().equals(other._url.toString());
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + this._label.hashCode();
        result = 37 * result + this._icon.hashCode();
        result = 37 * result + this._url.hashCode();
        return result;
    }

    public String toString() {
        return "URLChooserShortcut[label=" + this._label + ", url=" + this._url + "]";
    }
}

