/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.resource.DialogsArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;

public abstract class DialogUtil {
    private static final List _urlFilters = new ArrayList();
    private static SizeKeeperCallback _standardKeeper = new SizeKeeperCallback("file.chooser");
    private static final List<URLChooserShortcutProvider> _shortcutProviders = new CopyOnWriteArrayList<URLChooserShortcutProvider>();
    private static final DefaultShortcutProvider _defaultShortcutProvider = new DefaultShortcutProvider();

    public static URLChooser newURLChooser() {
        return DialogUtil.newURLChooser(Context.newIdeContext());
    }

    public static URLChooser newURLChooser(Context context) {
        return DialogUtil.newURLChooser(context, null);
    }

    public static URLChooser newURLChooser(URL initialURL) {
        return DialogUtil.newURLChooser(null, initialURL);
    }

    public static URLChooser newURLChooser(Context context, URL initialURL) {
        URLChooser chooser = new URLChooser();
        DialogUtil.initURLChooser(chooser, context);
        if (initialURL != null) {
            chooser.setSelectedURL(initialURL);
        }
        return chooser;
    }

    public static void initURLChooser(URLChooser urlChooser, Context context) {
        URL defaultURL = DialogUtil.getDefaultURLFromContext(context);
        if (URLFileSystem.canRead((URL)defaultURL)) {
            urlChooser.setSelectedURL(defaultURL);
        } else {
            urlChooser.setSelectedURL(DialogUtil.getDefaultDirectory());
        }
        DialogUtil.addShortcutButtons(urlChooser, context);
        DialogUtil.addURLFilters(urlChooser);
        urlChooser.setDialogRunnerCallback(_standardKeeper);
    }

    public static void addURLChooserShortcutProvider(URLChooserShortcutProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is null");
        }
        _shortcutProviders.add(provider);
    }

    public static void removeURLChooserShortcutProvider(URLChooserShortcutProvider provider) {
        _shortcutProviders.remove(provider);
    }

    public static void addShortcutButtons(URLChooser uc, Context context) {
        uc.removeShortcutButtons();
        ListIterator<URLChooserShortcutProvider> li = _shortcutProviders.listIterator(_shortcutProviders.size());
        while (li.hasPrevious()) {
            URLChooserShortcutProvider provider = li.previous();
            for (URLChooserShortcut s : provider.createShortcuts(context)) {
                uc.addShortcutButton(s.icon(), s.label(), s.url());
            }
        }
    }

    public static URLChooserInit getURLChooserInit(final Context context) {
        return new URLChooserInit(){

            @Override
            public void initURLChooser(URLChooser urlChooser) {
                DialogUtil.initURLChooser(urlChooser, context);
            }
        };
    }

    public static void registerShortcutButton(Icon icon, String label, URL url) {
        DialogUtil._defaultShortcutProvider.add(new URLChooserShortcut(icon, label, url));
    }

    public static void unregisterShortcutButton(Icon icon, String label, URL url) {
        DialogUtil._defaultShortcutProvider.remove(new URLChooserShortcut(icon, label, url));
    }

    public static void addURLFilter(URLFilter filter) {
        if (filter != null && !_urlFilters.contains(filter)) {
            _urlFilters.add(filter);
        }
    }

    public static void setWorkspaceFilter(URLFilter filter) {
    }

    public static void setProjectFilter(URLFilter filter) {
    }

    public static void setDefaultFilter(URLFilter filter) {
    }

    public static Dialog getAncestorDialog(Component parent) {
        return SwingUtils.getAncestorDialog((Component)parent);
    }

    public static Frame getAncestorFrame(Component parent) {
        return SwingUtils.getAncestorFrame((Component)parent);
    }

    public static JEWTDialog createJEWTDialogOwnedBy(Component parent) {
        Dialog jdialog = SwingUtils.getAncestorDialog((Component)parent);
        if (jdialog != null) {
            return new JEWTDialog(jdialog);
        }
        Frame frame = SwingUtils.getAncestorFrame((Component)parent);
        if (frame != null) {
            return new JEWTDialog(frame);
        }
        return null;
    }

    private static URL getDefaultURLFromContext(Context context) {
        Node node;
        URL url;
        if (context == null) {
            return DialogUtil.getDefaultDirectory();
        }
        Element[] selection = context.getSelection();
        if (selection != null && selection.length == 1) {
            URL rootDir;
            RelativeDirectoryContextFolder rdcf;
            URLPath rootDirs;
            Element element = selection[0];
            if (element instanceof Locatable) {
                url = DialogUtil.getDirectoryURLFromLocatable((Locatable)((Object)element));
                if (url != null) {
                    return url;
                }
            } else if (element instanceof RelativeDirectoryContextFolder && (rootDirs = (rdcf = (RelativeDirectoryContextFolder)element).getRootDirectories()) != null && (rootDir = rootDirs.getFirstEntry()) != null) {
                String relPath = rdcf.getRelativePath();
                return URLFactory.newDirURL((URL)rootDir, (String)relPath);
            }
            if (element instanceof Workspaces) {
                url = ((Workspaces)element).getWorkDirectory();
                return DialogUtil.findExistingDir(url);
            }
        }
        if ((node = context.getNode()) != null && (url = DialogUtil.getDirectoryURLFromLocatable(node)) != null) {
            return url;
        }
        Project project = context.getProject();
        if (project != null) {
            URL url2 = ((Node)project).getURL();
            return URLFileSystem.getParent((URL)url2);
        }
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            URL url3 = ((Node)workspace).getURL();
            return URLFileSystem.getParent((URL)url3);
        }
        return DialogUtil.getDefaultDirectory();
    }

    private static URL getDirectoryURLFromLocatable(Locatable locatable) {
        if (locatable == null) {
            return null;
        }
        URL url = locatable.getURL();
        if (url == null) {
            return null;
        }
        if (!URLFileSystem.isDirectoryPath((URL)url) && (url = URLFileSystem.getParent((URL)url)) == null) {
            return null;
        }
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    private static void addURLFilters(URLChooser urlChooser) {
        for (URLFilter filter : _urlFilters) {
            urlChooser.addChooseableURLFilter(filter);
        }
    }

    private static URL getHomeDirectory() {
        String homeDirectory = Ide.getTrueUserHomeDirectory();
        if (homeDirectory != null && homeDirectory.length() > 0) {
            return URLFactory.newDirURL((String)homeDirectory);
        }
        return null;
    }

    private static URL findExistingDir(URL url) {
        if (url != null) {
            while (url != null && !URLFileSystem.exists((URL)url)) {
                url = URLFileSystem.getParent((URL)url);
            }
        }
        return url;
    }

    private static URL getDefaultDirectory() {
        URL url = DialogUtil.getWorkDirectory();
        if (url == null) {
            url = DialogUtil.getHomeDirectory();
        }
        if (url == null) {
            url = DialogUtil.getIdeDirectory();
        }
        return DialogUtil.findExistingDir(url);
    }

    private static URL getWorkDirectory() {
        String workDirectory = Ide.getWorkDirectory();
        if (workDirectory != null && workDirectory.length() > 0) {
            return URLFactory.newDirURL((String)workDirectory);
        }
        return null;
    }

    private static URL getIdeDirectory() {
        String ideDirectory = Ide.getProductHomeDirectory();
        if (ideDirectory != null && ideDirectory.length() > 0) {
            return URLFactory.newDirURL((String)ideDirectory);
        }
        return null;
    }

    static {
        DialogUtil.addURLChooserShortcutProvider(_defaultShortcutProvider);
        URL homeURL = DialogUtil.getHomeDirectory();
        if (homeURL != null) {
            DialogUtil._defaultShortcutProvider.add(new URLChooserShortcut(OracleIcons.getIcon((String)"header/homefolder.png"), DialogsArb.getString(19), homeURL));
        }
    }

    private static class DefaultShortcutProvider
    implements URLChooserShortcutProvider {
        private final Collection<URLChooserShortcut> _shortcuts = new CopyOnWriteArrayList<URLChooserShortcut>();

        private DefaultShortcutProvider() {
        }

        @Override
        public Collection<URLChooserShortcut> createShortcuts(Context context) {
            return this._shortcuts;
        }

        private void add(URLChooserShortcut shortcut) {
            this._shortcuts.add(shortcut);
        }

        private void remove(URLChooserShortcut shortcut) {
            this._shortcuts.remove(shortcut);
        }
    }
}

