/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tabbedpane;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.tabbedpane.CloseTabListener;
import oracle.javatools.icons.OracleIcons;

public class TabTitleComponent
extends JPanel {
    private final JTabbedPane tabbedPane;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private final List<CloseTabListener> closeTabListeners = new ArrayList<CloseTabListener>();

    public static TabTitleComponent addNewTitleComponentToLastTab(JTabbedPane tabbedPane) {
        int tabCount = tabbedPane.getTabCount();
        if (tabCount == 0) {
            throw new AssertionError((Object)"The JTabbedPane does not have tabs");
        }
        return TabTitleComponent.addNewTitleComponent(tabbedPane, tabCount - 1);
    }

    public static TabTitleComponent addNewTitleComponent(JTabbedPane tabbedPane, int tabIndex) {
        TabTitleComponent c = new TabTitleComponent(tabbedPane);
        tabbedPane.setTabComponentAt(tabIndex, c);
        IconLabel iconLabel = new IconLabel(c);
        TitleLabel titleLabel = new TitleLabel(c);
        AbstractButton closeButton = TabTitleComponent.createCloseButton();
        TabTitleComponent.configure(c, iconLabel, titleLabel, closeButton);
        return c;
    }

    private static void configure(TabTitleComponent titleComponent, JLabel iconLabel, JLabel titleLabel, AbstractButton closeButton) {
        titleComponent.iconLabel = iconLabel;
        titleComponent.titleLabel = titleLabel;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        if (iconLabel.getIcon() != null) {
            titleComponent.add((Component)iconLabel, c);
            ++c.gridx;
        }
        titleComponent.add((Component)titleLabel, c);
        ++c.gridx;
        titleComponent.add(Box.createHorizontalGlue(), c);
        closeButton.addActionListener(new CloseTabActionListener(titleComponent));
        ++c.gridx;
        int w = OracleIcons.getIcon((String)"extras/small_close.gif").getIconWidth();
        Component box = Box.createHorizontalStrut(w + 4);
        titleComponent.add(box, c);
        ++c.gridx;
        closeButton.setVisible(false);
        titleComponent.add((Component)closeButton, c);
        ShowHideCloseButtonMouseListener l = new ShowHideCloseButtonMouseListener(titleComponent, box, closeButton);
        titleComponent.addMouseListener(l);
        titleLabel.addMouseListener(l);
        box.addMouseListener(l);
        closeButton.addMouseListener(l);
    }

    private static AbstractButton createCloseButton() {
        SmallSquareButton b = new SmallSquareButton();
        b.setModel(new DefaultButtonModel());
        b.setIcon(OracleIcons.getIcon((String)"extras/small_close.gif"));
        return b;
    }

    private TabTitleComponent(JTabbedPane tabbedPane) {
        super(new GridBagLayout());
        if (tabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
    }

    public synchronized void addCloseTabListener(CloseTabListener l) {
        if (this.closeTabListeners.contains(l)) {
            return;
        }
        this.closeTabListeners.add(l);
    }

    public synchronized void removeCloseTabListener(CloseTabListener l) {
        this.closeTabListeners.remove(l);
    }

    @Override
    public void setFont(Font font) {
        if (this.titleLabel != null) {
            this.titleLabel.setFont(font);
            return;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        if (this.titleLabel != null) {
            return this.titleLabel.getFont();
        }
        return super.getFont();
    }

    private static class CloseTabActionListener
    implements ActionListener {
        private final TabTitleComponent owner;

        CloseTabActionListener(TabTitleComponent owner) {
            this.owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane tabbedPane = this.owner.tabbedPane;
            int i = tabbedPane.indexOfTabComponent(this.owner);
            if (i == -1) {
                return;
            }
            boolean close = true;
            for (CloseTabListener l : this.owner.closeTabListeners) {
                boolean b = l.beforeClosingTab(tabbedPane, i);
                if (b) continue;
                close = false;
            }
            if (close) {
                tabbedPane.remove(i);
            }
        }
    }

    private static class IconLabel
    extends JLabel {
        private final TabTitleComponent owner;

        IconLabel(TabTitleComponent owner) {
            this.owner = owner;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public Icon getIcon() {
            return this.iconFromTabbedPane();
        }

        private Icon iconFromTabbedPane() {
            if (this.owner == null) {
                return null;
            }
            JTabbedPane tabbedPane = this.owner.tabbedPane;
            int i = tabbedPane.indexOfTabComponent(this.owner);
            if (i != -1) {
                return tabbedPane.getIconAt(i);
            }
            return null;
        }
    }

    private static class TitleLabel
    extends JLabel {
        private final TabTitleComponent owner;

        TitleLabel(TabTitleComponent owner) {
            this.owner = owner;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public String getText() {
            return this.titleFromTabbedPane();
        }

        private String titleFromTabbedPane() {
            if (this.owner == null) {
                return null;
            }
            JTabbedPane tabbedPane = this.owner.tabbedPane;
            int i = tabbedPane.indexOfTabComponent(this.owner);
            if (i != -1) {
                return tabbedPane.getTitleAt(i);
            }
            return null;
        }
    }

    private static class ShowHideCloseButtonMouseListener
    extends MouseAdapter {
        private final TabTitleComponent owner;
        private final Component box;
        private final AbstractButton closeButton;

        ShowHideCloseButtonMouseListener(TabTitleComponent owner, Component box, AbstractButton closeButton) {
            this.owner = owner;
            this.box = box;
            this.closeButton = closeButton;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.box.setVisible(false);
            this.closeButton.setVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.box.setVisible(true);
            this.closeButton.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == this.owner || e.getSource() == this.owner.titleLabel) {
                JTabbedPane tabbedPane = this.owner.tabbedPane;
                int i = tabbedPane.indexOfTabComponent(this.owner);
                tabbedPane.setSelectedIndex(i);
                tabbedPane.requestFocusInWindow();
            }
        }
    }
}

