/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tabbedpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.ide.controls.tabbedpane.TabTitleComponent;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public class CustomTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final String THEME_PART_VIEW = "viewtab";
    private String _themeStyle = "viewtab";
    private JTabbedPane _pane;
    private boolean tabsOverlapBorder = true;
    private int oldTabLayoutPolicy;

    @Override
    public void installUI(JComponent c) {
        this._pane = (JTabbedPane)c;
        this.oldTabLayoutPolicy = this._pane.getTabLayoutPolicy();
        this._pane.setTabLayoutPolicy(1);
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.oldTabLayoutPolicy == 1 || this.oldTabLayoutPolicy == 0) {
            this._pane.setTabLayoutPolicy(1);
        }
        this._pane = null;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (Themes.isThemed()) {
            String state = this.getThemeState(tabIndex);
            if (state != null) {
                Painter p = Themes.getActiveTheme().getStateProperties(this._themeStyle, state).getPainter("bg");
                p.paint(g, x, y, w, h);
            }
            return;
        }
        super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    private String getThemeState(int tabIndex) {
        boolean selected;
        boolean bl = selected = this._pane.getSelectedIndex() == tabIndex;
        if (selected && this._pane.hasFocus()) {
            return "active";
        }
        if (selected) {
            return "inactive";
        }
        return "deselected";
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Component c = this._pane.getTabComponentAt(tabIndex);
        if (c instanceof TabTitleComponent) {
            TabTitleComponent ttc = (TabTitleComponent)c;
            Font font = ttc.getFont();
            font = isSelected ? font.deriveFont(1) : font.deriveFont(0);
            ttc.setFont(font);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Font adjustedFont = this.getAdjustedFont(tabIndex, font);
        g.setFont(adjustedFont);
        super.paintText(g, tabPlacement, adjustedFont, metrics, tabIndex, title, textRect, isSelected);
    }

    private Font getAdjustedFont(int tabIndex, Font original) {
        boolean selected = this._pane.getSelectedIndex() == tabIndex;
        boolean isItalic = false;
        boolean isBold = selected;
        Font font = original;
        if (isItalic) {
            font = font.deriveFont(2);
        }
        if (isBold) {
            font = font.deriveFont(1);
        }
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            String state = this.getThemeState(tabIndex);
            return t.getStateProperties(this._themeStyle, state).getFont(font, "label");
        }
        return font;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font.deriveFont(1));
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (Themes.isThemed()) {
            int width = this.tabPane.getWidth();
            int height = this.tabPane.getHeight();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            switch (tabPlacement) {
                case 2: {
                    x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    if (this.tabsOverlapBorder) {
                        x -= tabAreaInsets.right;
                    }
                    w -= x - insets.left;
                    break;
                }
                case 4: {
                    w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    if (!this.tabsOverlapBorder) break;
                    w += tabAreaInsets.left;
                    break;
                }
                case 3: {
                    h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    if (!this.tabsOverlapBorder) break;
                    h += tabAreaInsets.top;
                    break;
                }
                default: {
                    y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    if (this.tabsOverlapBorder) {
                        y -= tabAreaInsets.bottom;
                    }
                    h -= y - insets.top;
                }
            }
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        super.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        ++y;
        if (Themes.isThemed()) {
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.themedBorderColor());
            if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y, x + w - 2, y);
            } else {
                g.drawLine(x, y - 2, selRect.x - 1, y - 2);
                if (selRect.x + selRect.width < x + w - 2) {
                    g.drawLine(selRect.x + selRect.width, y - 2, x + w - 1, y - 2);
                }
            }
            return;
        }
        super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x, y, x, y + h - 2);
            } else {
                g.drawLine(x, y, x, selRect.y - 1);
                if (selRect.y + selRect.height < y + h - 2) {
                    g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
                }
            }
            return;
        }
        super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
                if (selRect.y + selRect.height < y + h - 2) {
                    g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
                }
            }
            return;
        }
        super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (Themes.isThemed()) {
            Rectangle selRect;
            g.setColor(this.themedBorderColor());
            Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
                if (selRect.x + selRect.width < x + w - 2) {
                    g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
                }
            }
            return;
        }
        super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    private Color themedBorderColor() {
        Color c = this._pane.getBackground();
        Theme theme = Themes.getActiveTheme();
        c = this._pane.hasFocus() ? theme.getStateProperties("view", "active").getColor("bordercolor") : theme.getStateProperties("view", "inactive").getColor("bordercolor");
        return c;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (Themes.isThemed()) {
            if (tabPlacement == 1) {
                int i = tabIndex;
                int pageCount = this._pane.getTabCount();
                int selected = this._pane.getSelectedIndex();
                if (i < pageCount - 1 && selected != i + 1 && selected != i) {
                    Painter p = Themes.getActiveTheme().getStateProperties("tabseparator", "normal").getPainter("bg");
                    p.paint(g, x + w, 6, 1, h - 6);
                }
            }
            return;
        }
        super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int diff;
        Component c;
        int w = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        if (Themes.isThemed() && (c = this._pane.getTabComponentAt(tabIndex)) instanceof TabTitleComponent && w > (diff = w - c.getWidth())) {
            return w - diff + 10;
        }
        return w;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.contentBorderInsets = new Insets(0, 1, 1, 1);
    }
}

