/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.TreeAutoExpander;
import oracle.ide.controls.elementtree.ElementCellRenderer;
import oracle.ide.controls.elementtree.ElementRegistry;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.controls.elementtree.ElementTreeRootNode;
import oracle.ide.controls.elementtree.Handler;
import oracle.ide.controls.elementtree.HierarchyChangeEvent;
import oracle.ide.controls.elementtree.HierarchyChangeListener;
import oracle.ide.model.Element;

public class ElementTree
extends JTree {
    private MyHierarchyChangeListener _myHierarchyChangeListener;
    private ElementTreeRootNode _root;
    private VisibilityListeners _visibilityListeners = new VisibilityListeners();

    public ElementTree(ElementTreeRootNode root) {
        super(new DefaultTreeModel(root));
        this.setCellRenderer(ElementCellRenderer.INSTANCE);
        ToolTipManager.sharedInstance().registerComponent(this);
        TreeAutoExpander.install(this);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addHierarchyListener(this._visibilityListeners);
    }

    public void setRoot(ElementTreeRootNode root) {
        this.setModel(new DefaultTreeModel(root));
    }

    @Override
    public void setModel(TreeModel newModel) {
        Object newRoot = newModel.getRoot();
        if (!(newRoot instanceof ElementTreeRootNode)) {
            throw new IllegalArgumentException("Root node should be a " + ElementTreeRootNode.class.getName());
        }
        if (this._root != null) {
            this.removeHierarchyChangeListener();
        }
        super.setModel(newModel);
        this._root = (ElementTreeRootNode)newRoot;
        this.addHierarchyChangeListener();
    }

    private synchronized void addHierarchyChangeListener() {
        if (this._myHierarchyChangeListener == null) {
            this._myHierarchyChangeListener = new MyHierarchyChangeListener();
            this._root.addHierarchyListener(this._myHierarchyChangeListener);
        }
    }

    private synchronized void removeHierarchyChangeListener() {
        if (this._myHierarchyChangeListener != null) {
            this._root.removeHierachyListener(this._myHierarchyChangeListener);
            this._myHierarchyChangeListener = null;
        }
    }

    private void refreshTree(ElementTreeNode elementTreeNode) {
        HashMap expansionState = this.getExpansionState(elementTreeNode);
        TreePath treePath = this.buildTreePath(elementTreeNode);
        this.setExpandedState(treePath, false);
        elementTreeNode.clearCache();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.nodeStructureChanged(elementTreeNode);
        this.restoreExpansionState(expansionState, elementTreeNode);
    }

    public HashMap getExpansionState(ElementTreeNode elementTreeNode) {
        HashMap expansionState = new HashMap();
        ElementRegistry filterRegistry = elementTreeNode.getElementRegistry();
        LinkedList<ElementTreeNode> checkExpansion = new LinkedList<ElementTreeNode>();
        checkExpansion.add(elementTreeNode);
        while (!checkExpansion.isEmpty()) {
            ElementTreeNode node = (ElementTreeNode)checkExpansion.removeFirst();
            TreePath treePath = this.buildTreePath(node);
            if (!this.isExpanded(treePath)) continue;
            Element element = node.getElement();
            Handler handler = filterRegistry.getHandler(element);
            Element[] hierarchy = this.getHierarchy(node);
            handler.storeExpansionState(expansionState, hierarchy);
            List<ElementTreeNode> children = node.getChildren();
            checkExpansion.addAll(children);
        }
        return expansionState;
    }

    public void restoreExpansionState(HashMap expansionState, ElementTreeNode elementTreeNode) {
        ElementRegistry filterRegistry = elementTreeNode.getElementRegistry();
        LinkedList<ElementTreeNode> nodesToExpand = new LinkedList<ElementTreeNode>();
        nodesToExpand.addFirst(elementTreeNode);
        while (!nodesToExpand.isEmpty()) {
            Element[] hierarchy;
            ElementTreeNode node = (ElementTreeNode)nodesToExpand.removeFirst();
            Element element = node.getElement();
            Handler handler = filterRegistry.getHandler(element);
            if (!handler.isExpanded(expansionState, hierarchy = this.getHierarchy(node))) continue;
            List<ElementTreeNode> children = node.getChildren();
            nodesToExpand.addAll(children);
            TreePath treePath = this.buildTreePath(node);
            this.expandPath(treePath);
        }
    }

    private Element[] getHierarchy(ElementTreeNode elementTreeNode) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ElementTreeNode node = elementTreeNode; node != null; node = node.getParent()) {
            Element element = node.getElement();
            elements.add(0, element);
        }
        Element[] elementArray = elements.toArray(new Element[elements.size()]);
        return elementArray;
    }

    private TreePath buildTreePath(ElementTreeNode elementTreeNode) {
        ElementTreeNode parent = elementTreeNode.getParent();
        if (parent == null) {
            return new TreePath(elementTreeNode);
        }
        TreePath treePath = this.buildTreePath(parent);
        return treePath.pathByAddingChild(elementTreeNode);
    }

    private void whenAdded() {
        this.addHierarchyChangeListener();
        this.refreshTree(this._root);
    }

    private void whenRemoved() {
        this.removeHierarchyChangeListener();
    }

    private class VisibilityListeners
    implements HierarchyListener,
    WindowListener {
        private Window _windowAncestor;

        private VisibilityListeners() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) == 1L) {
                Window windowAncestor = SwingUtilities.getWindowAncestor(ElementTree.this);
                if (windowAncestor == null) {
                    this.whenRemoved();
                } else {
                    this.whenAdded(windowAncestor);
                }
            }
        }

        private void whenAdded(Window windowAncestor) {
            if (this._windowAncestor == null) {
                this._windowAncestor = windowAncestor;
                this._windowAncestor.addWindowListener(this);
                ElementTree.this.whenAdded();
            }
        }

        private void whenRemoved() {
            if (this._windowAncestor != null) {
                this._windowAncestor.removeWindowListener(this);
                this._windowAncestor = null;
                ElementTree.this.whenRemoved();
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.whenRemoved();
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    private class MyHierarchyChangeListener
    implements HierarchyChangeListener {
        private MyHierarchyChangeListener() {
        }

        @Override
        public void structureChanged(HierarchyChangeEvent event) {
            ElementTreeNode source = event.getElementTreeNode();
            ElementTree.this.refreshTree(source);
        }

        @Override
        public void childAdded(HierarchyChangeEvent event) {
            ElementTreeNode source = event.getElementTreeNode();
            ElementTree.this.refreshTree(source);
        }

        @Override
        public void childRemoved(HierarchyChangeEvent event) {
            ElementTreeNode source = event.getElementTreeNode();
            ElementTree.this.refreshTree(source);
        }
    }
}

