/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.layout.IdeProperties;

public class TreeAutoExpander {
    private static Boolean ENABLED;
    private Listeners _listeners;
    private JTree _tree;
    private TreePath _expandedPath;
    private boolean _inputEvent;
    private TreeModel _model;

    public static void install(JTree tree) {
        if (TreeAutoExpander.isEnabled()) {
            new TreeAutoExpander(tree);
        }
    }

    private static boolean isEnabled() {
        if (ENABLED == null) {
            IdeProperties ideProperties = Ide.getIdeProperties();
            String enabledProperty = ideProperties.getProperty("TreeAutoExpander.Enabled", Boolean.TRUE.toString());
            ENABLED = Boolean.valueOf(enabledProperty);
        }
        return ENABLED;
    }

    private TreeAutoExpander(JTree tree) {
        this._tree = tree;
        this._listeners = new Listeners();
        tree.addMouseListener(this._listeners);
        tree.addKeyListener(this._listeners);
        tree.addTreeExpansionListener(this._listeners);
    }

    private void reset() {
        this._inputEvent = false;
        this._expandedPath = null;
    }

    private void whenTreeExpanded(TreeExpansionEvent event) {
        this._expandedPath = event.getPath();
        if (this._inputEvent) {
            this.expandLastPath();
        } else {
            this.whenOneConditionMet();
        }
    }

    private void whenInputEvent() {
        if (this._expandedPath != null) {
            this.expandLastPath();
        } else {
            this._inputEvent = true;
            this.whenOneConditionMet();
        }
    }

    private void whenOneConditionMet() {
        TreeModel model = this._tree.getModel();
        if (model != this._model) {
            this.setModel(model);
            this.reset();
        } else {
            SwingUtilities.invokeLater(this._listeners);
        }
    }

    private void setModel(TreeModel model) {
        if (this._model != null) {
            this._model.removeTreeModelListener(this._listeners);
        }
        this._model = model;
        if (this._model != null) {
            this._model.addTreeModelListener(this._listeners);
        }
    }

    private void expandLastPath() {
        TreeAutoExpander.expandPath(this._tree, this._expandedPath);
        this.reset();
    }

    private static void expandPath(JTree tree, TreePath path) {
        Object lastPathComponent;
        int childCount;
        TreeModel model = tree.getModel();
        while ((childCount = model.getChildCount(lastPathComponent = path.getLastPathComponent())) == 1) {
            Object firstChild = model.getChild(lastPathComponent, 0);
            if (tree.isExpanded(path = path.pathByAddingChild(firstChild))) continue;
            tree.expandPath(path);
            break;
        }
    }

    private class Listeners
    implements TreeExpansionListener,
    MouseListener,
    Runnable,
    TreeModelListener,
    KeyListener {
        private Listeners() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreeAutoExpander.this.whenTreeExpanded(event);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            TreeAutoExpander.this.whenInputEvent();
        }

        @Override
        public void run() {
            TreeAutoExpander.this.reset();
        }
    }
}

