/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class ThinBevel
extends BevelBorder {
    public static final Border RAISED_BORDER = new ThinBevel(0);
    public static final Border LOWERED_BORDER = new ThinBevel(1);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Color highlightColor;
    private static final Color shadowColor;

    public ThinBevel(int type) {
        super(type);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }

    @Override
    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(highlightColor);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(shadowColor);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(shadowColor);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(highlightColor);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    static {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        shadowColor = defaults.getColor("controlShadow");
        highlightColor = defaults.getColor("controlLtHighlight");
    }
}

