/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.ProgressTrackerControl;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class StatusBarControl
implements StatusBar {
    private JPanel _gui;
    private JLabel _label;
    private Toolbar _toolbar;
    private JDevStatusBar _statusBar = new JDevStatusBar();
    private ProgressTrackerControl _progressTrackerControl;
    private static final String THEME_PART = "statusbar";

    public StatusBarControl() {
        int rightPadding = PlatformUtils.isMac() ? 15 : 0;
        CompoundBorder guiBorder = BorderFactory.createCompoundBorder(JavatoolsBorderFactory.createTopBorder((Color)IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, 0, 0, rightPadding));
        this._progressTrackerControl = new ProgressTrackerControl();
        this._label = this._statusBar.add(" ");
        Ide.addIdeListener(new IdeListener(){

            @Override
            public void addinsLoaded(IdeEvent e) {
            }

            @Override
            public void mainWindowOpened(IdeEvent e) {
                Ide.removeIdeListener(this);
                StatusBarControl.this.installThemeForeground(StatusBarControl.this._label);
                if (Themes.isThemed()) {
                    StatusBarControl.this._gui.setBorder(Themes.getActiveTheme().getStateProperties(StatusBarControl.THEME_PART, "normal").getBorder("border"));
                    UIManager.put(StatusBarControl.this._statusBar.getUIClassID(), "oracle.ide.controls.ThemedStatusBarUI");
                    StatusBarControl.this._statusBar.updateUI();
                    for (int i = 0; i < StatusBarControl.this._toolbar.getComponentCount(); ++i) {
                        Component c = StatusBarControl.this._toolbar.getComponent(i);
                        StatusBarControl.this.installThemeForeground(c);
                    }
                }
            }

            @Override
            public void mainWindowClosing(IdeEvent e) {
            }
        });
        this._statusBar.setExpandable(this._label, true);
        this._statusBar.setItemResizeAllowed(false);
        this._gui = new JPanel();
        this._gui.setBorder(guiBorder);
        this._gui.setLayout(new GridBagLayout());
        this._gui.setOpaque(false);
        this._gui.add((Component)((Object)this._statusBar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void installThemeForeground(Component c) {
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            if (c.getForeground() == null || c.getForeground() instanceof UIResource) {
                c.setForeground(t.getStateProperties(THEME_PART, "normal").getColor("foreground"));
            }
            if (c instanceof Container) {
                for (int i = 0; i < ((Container)c).getComponentCount(); ++i) {
                    this.installThemeForeground(((Container)c).getComponent(i));
                }
            }
        }
    }

    @Override
    public String getText() {
        String s = this._label.getText();
        return s.equals(" ") ? "" : s;
    }

    @Override
    public void setText(String text) {
        String s = ModelUtil.hasLength((String)text) ? text : " ";
        this._label.setText(s);
    }

    @Override
    public JComponent getGUI() {
        return this._gui;
    }

    @Override
    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar(){

                @Override
                public Component addComponent(Component component, int index) {
                    StatusBarControl.this.installThemeForeground(component);
                    return super.addComponent(component, index);
                }
            };
            this._toolbar.setBorder(null);
            this._toolbar.setOpaque(false);
            this.installThemeForeground(this._toolbar);
            this._gui.add((Component)this._toolbar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        }
        return this._toolbar;
    }

    @Override
    public ProgressTracker getProgressTracker() {
        return this._progressTrackerControl;
    }

    public void add(JComponent comp) {
        this.installThemeForeground(comp);
        this._statusBar.add(comp);
    }

    public void remove(JComponent comp) {
        this._statusBar.remove(comp);
    }

    public boolean isExpandable(JComponent comp) {
        return this._statusBar.isExpandable(comp);
    }

    public void setExpandable(JComponent comp, boolean expandable) {
        this._statusBar.setExpandable(comp, expandable);
    }

    public int getStatusCount() {
        return this._statusBar.getComponentCount() - 1;
    }

    public void resetStatus() {
        Component[] children = this._statusBar.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == this._label) continue;
            this._statusBar.remove(children[i]);
        }
    }

    public boolean containsStatusItem(JComponent status) {
        Component[] children = this._statusBar.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (status != children[i]) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
        }
    }

    private static final class JDevStatusBar
    extends oracle.bali.ewt.statusBar.StatusBar {
        public JDevStatusBar() {
            super(1);
            this.setBorder(null);
            this.setOpaque(false);
        }

        public String getUIClassID() {
            return "oracle.ide.controls.StatusBarControlUI";
        }
    }
}

