/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import oracle.ide.controls.ForegroundSwappedIcon;
import oracle.ide.util.ModelUtil;
import oracle.javatools.ui.border.SmallSquareButtonBorder;

public final class SmallSquareButton
extends JButton {
    public SmallSquareButton(Icon icon, String tooltip) {
        this();
        this.setIcon(icon);
        this.setToolTipText(tooltip);
    }

    public SmallSquareButton() {
        SmallSquareButton.configure(this);
    }

    static void configure(AbstractButton b) {
        b.setBorder((Border)new SmallSquareButtonBorder());
        b.setContentAreaFilled(false);
        b.setRolloverEnabled(true);
        b.setRequestFocusEnabled(false);
        b.setFocusable(false);
        b.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon == null || icon instanceof ForegroundSwappedIcon) {
            super.setIcon(icon);
            return;
        }
        super.setIcon(new ForegroundSwappedIcon(icon, this.getForeground()));
    }

    @Override
    public void setForeground(Color fg) {
        if (ModelUtil.areDifferent((Object)fg, (Object)this.getForeground())) {
            super.setForeground(fg);
            SmallSquareButton.swapIconForForeground(this, fg);
        }
    }

    static void swapIconForForeground(AbstractButton b, Color fg) {
        Icon icon = b.getIcon();
        if (icon instanceof ForegroundSwappedIcon) {
            ForegroundSwappedIcon fi = (ForegroundSwappedIcon)icon;
            Icon baseIcon = fi.getBaseIcon();
            b.setIcon(new ForegroundSwappedIcon(baseIcon, fg));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(null);
        this.setForeground(null);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

