/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.BaseToggleToolButton;
import oracle.ide.controls.MenuToolButtonUtils;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolbarGroup;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.util.ModelUtil;

public class MenuToolButton
extends BaseToggleToolButton
implements ToolbarGroup {
    protected static final PopupMenuListener POPUP_MENU_LISTENER = new ButtonPopupMenuListener();
    protected static final Icon POPUP_ICON = new PopupIndicator();
    protected static final int POPUP_WIDTH = Math.max(2 + POPUP_ICON.getIconWidth() + 2, 9);
    protected ToggleAction _visibleActions;
    protected ToggleAction[] _actions;
    protected List<JMenuItem> _hiddenItems;
    protected JPopupMenu _popup;
    private boolean paintPopUpIndicator = true;

    public void setPaintPopUpIndicator(boolean paintPopUpIndicator) {
        this.paintPopUpIndicator = paintPopUpIndicator;
    }

    public MenuToolButton(ToggleAction[] actions) {
        this(actions, actions[0]);
    }

    public MenuToolButton(ToggleAction buttonAction) {
        this(new ToggleAction[0], buttonAction);
    }

    public MenuToolButton(ToggleAction[] radioActions, ToggleAction defaultAction) {
        super(defaultAction);
        if (radioActions == null) {
            radioActions = new ToggleAction[]{};
        }
        this.setHorizontalAlignment(2);
        this.setFocusable(true);
        this.createPopupMenu();
        this._actions = radioActions;
        this._visibleActions = defaultAction;
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < radioActions.length; ++i) {
            ToggleAction action = radioActions[i];
            JMenuItem item = this.addPopupItem(action);
            buttonGroup.add(item);
            if (action.getState()) {
                this.setAction(action);
            }
            PropertyChangeListener itemPropertyChangeListener = this.createMenuItemActionPropertyChangeListener(item, action);
            action.addPropertyChangeListener(itemPropertyChangeListener);
        }
        this.addItemListener(this.createButtonItemListener());
        this.addKeyListener(this.createButtonKeyListener());
    }

    public JPopupMenu getPopupMenu() {
        if (this._popup == null) {
            return this.createPopupMenu();
        }
        return this._popup;
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.getPopupMenu().addPopupMenuListener(listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        this.getPopupMenu().removePopupMenuListener(listener);
    }

    public JMenuItem addPopupItem(ToggleAction action) {
        JMenuItem item;
        if (this._popup == null) {
            this.createPopupMenu();
        }
        if ((item = this.findPopupItem(action)) == null) {
            Object hidden;
            item = Ide.getMenubar().createMenuItem(action);
            Object object = hidden = action != null ? action.getValue("Hidden") : null;
            if (Boolean.TRUE.equals(hidden)) {
                if (this._hiddenItems == null) {
                    this._hiddenItems = new ArrayList<JMenuItem>(1);
                }
                this._hiddenItems.add(item);
            } else {
                this._popup.add(item);
            }
        }
        return item;
    }

    @Override
    public Component add(Component comp) {
        return this.getPopupMenu().add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.getPopupMenu().add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.getPopupMenu().add(comp, constraints, index);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.getPopupMenu().add(comp, index);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.getPopupMenu().add(name, comp);
    }

    public void removePopupItem(ToggleAction action) {
        JMenuItem item = this.findPopupItem(action);
        if (item != null) {
            if (this._hiddenItems != null && this._hiddenItems.contains(item)) {
                this._hiddenItems.remove(item);
            } else {
                this._popup.remove(item);
            }
        }
    }

    public void removeAllPopupItems() {
        if (this._hiddenItems != null) {
            this._hiddenItems.clear();
        }
        this._popup.removeAll();
    }

    public JMenuItem findPopupItem(ToggleAction action) {
        if (this._popup != null) {
            MenuElement[] elements = this._popup.getSubElements();
            for (int i = 0; i < elements.length; ++i) {
                JMenuItem item;
                Action itemAction;
                Component c = elements[i].getComponent();
                if (!(c instanceof JMenuItem) || (itemAction = (item = (JMenuItem)c).getAction()) == null || !itemAction.equals(action)) continue;
                return item;
            }
        }
        if (this._hiddenItems != null) {
            for (int i = this._hiddenItems.size() - 1; i >= 0; --i) {
                JMenuItem item;
                Action itemAction;
                JMenuItem object = this._hiddenItems.get(i);
                if (!(object instanceof JMenuItem) || (itemAction = (item = object).getAction()) == null || !itemAction.equals(action)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public Action[] getActions() {
        return new Action[]{this._visibleActions};
    }

    @Override
    protected ButtonModel createModel() {
        return new MenuToolButtonModel();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.paintPopUpIndicator) {
            size.width += POPUP_WIDTH;
        }
        return size;
    }

    @Override
    public void setAction(Action action) {
        Action oldAction = this.getAction();
        if (!ModelUtil.areEqual((Object)action, (Object)oldAction)) {
            super.setAction(action);
            if (action == null && this._actions != null) {
                for (int i = 0; i < this._actions.length; ++i) {
                    JMenuItem menuItem = this.findPopupItem(this._actions[i]);
                    if (menuItem == null) continue;
                    menuItem.setAction(null);
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.paintPopUpIndicator) {
            return;
        }
        Insets insets = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = w - insets.left - (POPUP_WIDTH + POPUP_ICON.getIconWidth()) / 2;
        int y = (h - 1 - POPUP_ICON.getIconHeight()) / 2;
        POPUP_ICON.paintIcon(this, g, x, y);
    }

    protected JPopupMenu createPopupMenu() {
        this._popup = new JPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        return this._popup;
    }

    protected PropertyChangeListener createMenuItemActionPropertyChangeListener(JMenuItem menuItem, Action action) {
        return new InnerPropertyChangeAdaptor(this, menuItem, action);
    }

    protected ItemListener createButtonItemListener() {
        return new ButtonItemListener(this);
    }

    protected KeyListener createButtonKeyListener() {
        return new ButtonKeyListener(this);
    }

    private static final class PopupIndicator
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public PopupIndicator() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return this.getBounds().height;
        }

        @Override
        public int getIconWidth() {
            return this.getBounds().width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                this.paint(g, x, y, c.getForeground());
            } else {
                this.paint(g, x, y, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this);
            g.drawPolygon(this);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    protected static class ButtonItemListener
    implements ItemListener,
    PopupMenuListener,
    MouseListener {
        private MenuToolButton button;
        private long lastInvisible = 0L;

        public ButtonItemListener(MenuToolButton button) {
            this.button = button;
            button.getPopupMenu().addPopupMenuListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (System.currentTimeMillis() < this.lastInvisible + 500L) {
                    this.button.getModel().setArmed(false);
                    this.button.setSelected(false);
                } else {
                    MenuToolButtonUtils.showComponentPopupMenu(this.button, this.button.getPopupMenu());
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.lastInvisible = System.currentTimeMillis();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    protected static class ButtonKeyListener
    implements KeyListener {
        private MenuToolButton button;

        public ButtonKeyListener(MenuToolButton button) {
            this.button = button;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.acceptsEvent(e)) {
                if (!this.button.getPopupMenu().isVisible()) {
                    this.button.getModel().setArmed(true);
                    this.button.getModel().setPressed(true);
                    MenuToolButtonUtils.showComponentPopupMenu(this.button, this.button.getPopupMenu());
                } else {
                    this.button.getPopupMenu().setVisible(false);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.acceptsEvent(e)) {
                if (this.button.getPopupMenu().isVisible()) {
                    this.button.getModel().setArmed(true);
                    this.button.getModel().setPressed(true);
                } else {
                    this.button.getModel().setArmed(false);
                    this.button.getModel().setPressed(false);
                }
            }
        }

        private boolean acceptsEvent(KeyEvent e) {
            return e.getKeyCode() == 32 || e.getKeyCode() == 10;
        }
    }

    protected static class ButtonPopupMenuListener
    implements PopupMenuListener {
        protected ButtonPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            AbstractButton b = this.getButton(e);
            b.getModel().setArmed(false);
            b.setSelected(false);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Container source = (Container)e.getSource();
            ButtonPopupMenuListener.updateActions(source);
        }

        private static void updateActions(Container container) {
            int size = container.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component child = container.getComponent(i);
                if (child instanceof JMenuItem) {
                    JMenuItem menuItem = (JMenuItem)child;
                    Action action = menuItem.getAction();
                    if (!(action instanceof IdeAction)) continue;
                    IdeAction ideAction = (IdeAction)action;
                    ideAction.updateAction();
                    continue;
                }
                if (!(child instanceof Container)) continue;
                Container subMenu = (Container)child;
                ButtonPopupMenuListener.updateActions(subMenu);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        protected AbstractButton getButton(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            return (AbstractButton)popup.getInvoker();
        }
    }

    protected static class MenuToolButtonModel
    extends JToggleButton.ToggleButtonModel {
        protected MenuToolButtonModel() {
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
        }
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        private final WeakReference<MenuToolButton> m_MenuToolButtonWeakRef;

        public InnerPropertyChangeAdaptor(MenuToolButton menuToolButton, AbstractButton adaptee, Action action) {
            super(adaptee, action);
            this.m_MenuToolButtonWeakRef = new WeakReference<MenuToolButton>(menuToolButton);
        }

        protected void stateChanged(PropertyChangeEvent e) {
            Boolean toggledState;
            MenuToolButton menuToolButton = (MenuToolButton)this.m_MenuToolButtonWeakRef.get();
            if (menuToolButton != null && (toggledState = (Boolean)e.getNewValue()).booleanValue()) {
                JMenuItem adaptee = (JMenuItem)this.getAdaptee();
                menuToolButton.setAction(adaptee.getAction());
            }
        }
    }
}

