/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class KeyboardRedirector
implements AWTEventListener {
    private static KeyboardRedirector INSTANCE;
    private ArrayList _queue = new ArrayList();
    private boolean _frozen;
    private int _enqueued;

    private void initialize() {
    }

    public static KeyboardRedirector getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardRedirector();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public void freeze() {
        this._frozen = true;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 12L);
    }

    public void thaw() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this);
        this._frozen = false;
        for (int i = 0; i < this._queue.size(); ++i) {
            KeyEvent keyEvent = (KeyEvent)this._queue.get(i);
            Component component = keyEvent.getComponent();
            if (component == null) continue;
            component.dispatchEvent(keyEvent);
        }
        this._queue.clear();
    }

    private void deliver(Component focusedComponent) {
        this._frozen = false;
        if (focusedComponent != null) {
            boolean waitForPressed = true;
            for (int i = 0; i < this._queue.size(); ++i) {
                KeyEvent event = (KeyEvent)this._queue.get(i);
                if (waitForPressed && event.getID() == 401) {
                    waitForPressed = false;
                }
                if (waitForPressed) continue;
                event.setSource(focusedComponent);
                focusedComponent.dispatchEvent(event);
            }
        }
        this._queue.clear();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this._frozen) {
            switch (event.getID()) {
                case 400: 
                case 401: 
                case 402: {
                    this.enqueue((KeyEvent)event);
                    break;
                }
                case 1004: {
                    ++this._enqueued;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (--KeyboardRedirector.this._enqueued == 0 && KeyboardRedirector.this._frozen) {
                                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component focusOwner = focusManager.getFocusOwner();
                                KeyboardRedirector.this.deliver(focusOwner);
                            }
                        }
                    });
                }
            }
        }
    }

    private void enqueue(KeyEvent keyEvent) {
        KeyEvent newEvent = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        this._queue.add(newEvent);
        keyEvent.consume();
    }
}

