/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import javax.swing.Icon;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.IdeArb;
import oracle.javatools.icons.OracleIcons;

public final class IdeActions {
    private static final LabelUpdater m_removeFromDiskLabelUpdater = new LabelUpdater(){

        @Override
        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        @Override
        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        @Override
        public void setEnabledFormat(String format) {
        }

        @Override
        public void setDisabledFormat(String format) {
        }

        private String getLabelForCurrentElement(Context context) {
            if (context.getElement() instanceof Project) {
                return DeleteDialogArb.getString(38);
            }
            if (context.getElement() instanceof Workspace) {
                return DeleteDialogArb.getString(39);
            }
            return IdeArb.getString(101);
        }
    };

    private static IdeAction findOrCreateAction(int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, Icon icon, Object data, boolean enabled) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get(cmdID, cmd, label, actionCategory, labelMnemonic, null, null, data, enabled);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        return action;
    }

    public static IdeAction getFileOpenAction() {
        return IdeActions.findOrCreateAction(9, "oracle.ide.cmd.OpenCommand", IdeArb.getString(52), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(53), OracleIcons.getIcon((String)"open.png"), null, true);
    }

    public static IdeAction getFileCloseAction() {
        return IdeActions.findOrCreateAction(48, "oracle.ide.cmd.CloseNodeCommand", IdeArb.getString(278), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(279), null, null, true);
    }

    public static IdeAction getFileCloseAllAction() {
        return IdeActions.findOrCreateAction(39, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(196), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(197), null, null, true);
    }

    public static IdeAction getFileSaveAction() {
        return IdeActions.findOrCreateAction(11, "oracle.ide.cmd.SaveCommand", IdeArb.getString(58), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(59), OracleIcons.getIcon((String)"filesave.png"), null, false);
    }

    public static IdeAction getFileSaveAsAction() {
        return IdeActions.findOrCreateAction(12, "oracle.ide.cmd.SaveAsCommand", IdeArb.getString(61), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(62), null, null, false);
    }

    public static IdeAction getFileSaveAllAction() {
        return IdeActions.findOrCreateAction(13, "oracle.ide.cmd.SaveAllCommand", IdeArb.getString(64), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(65), OracleIcons.getIcon((String)"saveall.png"), null, true);
    }

    public static IdeAction getFileRenameAction() {
        return IdeActions.findOrCreateAction(14, "oracle.ide.cmd.RenameCommand", IdeArb.getString(67), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(68), null, null, false);
    }

    public static IdeAction getFileRevertAction() {
        return IdeActions.findOrCreateAction(52, "oracle.ide.cmd.RevertNodeCommand", IdeArb.getString(410), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(411), null, null, false);
    }

    public static IdeAction getFileRemoveFromIDEAction() {
        return IdeActions.findOrCreateAction(21, "oracle.ide.cmd.RemoveFileCommand", IdeArb.getString(223), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(225), OracleIcons.getIcon((String)"remove_file.png"), null, false);
    }

    public static IdeAction getFileRemoveFromDiskAction() {
        IdeAction removeFromDiskAction = IdeActions.findOrCreateAction(47, "oracle.ide.cmd.RemoveFromDiskCommand", IdeArb.getString(101), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(102), OracleIcons.getIcon((String)"delete.png"), null, false);
        if (removeFromDiskAction.getLabelUpdater() == null) {
            removeFromDiskAction.setLabelUpdater(m_removeFromDiskLabelUpdater);
        }
        return removeFromDiskAction;
    }

    public static IdeAction getFileExitAction() {
        return IdeActions.findOrCreateAction(4, "oracle.ide.cmd.ExitCommand", IdeArb.getString(76), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(77), null, Ide.getMainWindow(), true);
    }

    public static IdeAction getFileReloadNodesAction() {
        return IdeActions.findOrCreateAction(72, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(231), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(232), null, null, true);
    }

    public static IdeAction getEditUndoAction() {
        String undoMenuLabel = IdeArb.format(80, "");
        IdeAction action = IdeActions.findOrCreateAction(5, "oracle.ide.cmd.UndoCommand", undoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(81), OracleIcons.getIcon((String)"undo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", undoMenuLabel);
        return action;
    }

    public static IdeAction getEditRedoAction() {
        String redoMenuLabel = IdeArb.format(83, "");
        IdeAction action = IdeActions.findOrCreateAction(6, "oracle.ide.cmd.RedoCommand", redoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(84), OracleIcons.getIcon((String)"redo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", redoMenuLabel);
        return action;
    }

    public static IdeAction getEditCutAction() {
        return IdeActions.findOrCreateAction(17, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(86), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(87), OracleIcons.getIcon((String)"cut.png"), null, false);
    }

    public static IdeAction getEditCopyAction() {
        return IdeActions.findOrCreateAction(18, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(89), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(90), OracleIcons.getIcon((String)"copy.png"), null, false);
    }

    public static IdeAction getEditCopyPathAction() {
        return IdeActions.findOrCreateAction(77, "oracle.ide.cmd.CopyPath", IdeArb.getString(92), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(93), null, null, false);
    }

    public static IdeAction getEditPasteAction() {
        return IdeActions.findOrCreateAction(19, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(95), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(96), OracleIcons.getIcon((String)"paste.png"), null, false);
    }

    public static IdeAction getEditExtendedPasteAction() {
        return IdeActions.findOrCreateAction(78, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(98), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(99), null, null, false);
    }

    public static IdeAction getEditDeleteAction() {
        return IdeActions.findOrCreateAction(20, null, IdeArb.getString(101), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(102), OracleIcons.getIcon((String)"delete.png"), null, false);
    }

    public static IdeAction getEditSelectAllAction() {
        return IdeActions.findOrCreateAction(22, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(365), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(366), null, null, false);
    }

    public static IdeAction getEditPropertiesAction() {
        return IdeActions.findOrCreateAction(56, null, IdeArb.getString(346), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(347), OracleIcons.getIcon((String)"properties.png"), null, false);
    }

    public static IdeAction getEditDuplicateSelectionAction() {
        IdeAction action = IdeActions.findOrCreateAction(82, "Ide.DUPLICATE_SELECTION_CMD", IdeArb.getString(106), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(107), null, null, true);
        return action;
    }

    public static IdeAction getEditSelectWrapAction() {
        IdeAction action = IdeActions.findOrCreateAction(81, "Ide.SELECT_WRAP_CMD", IdeArb.getString(104), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(105), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        action.setState(true);
        return action;
    }

    public static IdeAction getViewNewViewAction() {
        return IdeActions.findOrCreateAction(67, null, IdeArb.getString(25), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(26), OracleIcons.getIcon((String)"navigator.png"), null, false);
    }

    public static IdeAction getViewFreezeAction() {
        IdeAction action = IdeActions.findOrCreateAction(68, null, IdeArb.getString(28), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(29), OracleIcons.getIcon((String)"pin.png"), null, false);
        action.putValue("Check", Boolean.TRUE);
        action.putValue("State", Boolean.FALSE);
        return action;
    }

    public static IdeAction getViewMainToolbarAction() {
        IdeAction action = IdeActions.findOrCreateAction(36, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(3), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(4), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        return action;
    }

    public static IdeAction getViewStatusBarAction() {
        IdeAction action = IdeActions.findOrCreateAction(69, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(6), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(7), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        return action;
    }

    public static IdeAction getViewRefreshAction() {
        return IdeActions.findOrCreateAction(51, null, IdeArb.getString(322), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(323), OracleIcons.getIcon((String)"refresh.png"), null, false);
    }

    public static IdeAction getSearchFindAction() {
        return IdeActions.findOrCreateAction(23, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(109), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(110), OracleIcons.getIcon((String)"find.png"), null, false);
    }

    public static IdeAction getSearchFindNextAction() {
        return IdeActions.findOrCreateAction(25, "oracle.ide.cmd.SearchAgainCommand", IdeArb.getString(115), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(116), null, null, false);
    }

    public static IdeAction getSearchFindPreviousAction() {
        return IdeActions.findOrCreateAction(53, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(118), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(119), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindForwardAction() {
        return IdeActions.findOrCreateAction(26, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(124), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(125), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindBackwardAction() {
        return IdeActions.findOrCreateAction(27, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(127), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(128), null, null, false);
    }

    public static IdeAction getSearchReplaceAction() {
        return IdeActions.findOrCreateAction(24, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(112), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(113), null, null, false);
    }

    public static IdeAction getSearchFindInFilesAction() {
        return IdeActions.findOrCreateAction(28, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(130), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(131), OracleIcons.getIcon((String)"search_sourcepath.png"), null, false);
    }

    public static IdeAction getReplaceInFilesAction() {
        return IdeActions.findOrCreateAction(76, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(442), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(443), OracleIcons.getIcon((String)"search_sourcepath.png"), null, false);
    }

    public static IdeAction getNavigateGoToLineAction() {
        return IdeActions.findOrCreateAction(29, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(133), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(134), null, null, false);
    }

    public static IdeAction getNavigateGoToClassAction() {
        return IdeActions.findOrCreateAction(32, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(142), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(143), null, null, true);
    }

    public static IdeAction getNavigateGoToDocAction() {
        return IdeActions.findOrCreateAction(83, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(145), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, null, null, null, true);
    }

    public static IdeAction getNavigateGoToNextMessageAction() {
        return IdeActions.findOrCreateAction(30, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(136), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(137), OracleIcons.getIcon((String)"next_message.png"), null, false);
    }

    public static IdeAction getNavigateGoToPreviousMessageAction() {
        return IdeActions.findOrCreateAction(31, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(139), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(140), OracleIcons.getIcon((String)"previous_message.png"), null, false);
    }

    public static IdeAction getToolsProjectPropertiesAction() {
        return IdeActions.findOrCreateAction(35, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(177), IdeMainWindow.ACTION_CATEGORY_APPLICATION, IdeArb.getInteger(178), OracleIcons.getIcon((String)"settings.png"), null, false);
    }

    public static IdeAction getToolsDefaultProjectPropertiesAction() {
        return IdeActions.findOrCreateAction(37, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(189), IdeMainWindow.ACTION_CATEGORY_APPLICATION, IdeArb.getInteger(190), null, null, false);
    }

    public static IdeAction getToolsPreferencesAction() {
        return IdeActions.findOrCreateAction(38, "oracle.ide.cmd.IdeSettingsCommand", IdeArb.getString(184), IdeMainWindow.ACTION_CATEGORY_TOOLS, IdeArb.getInteger(185), null, null, true);
    }

    public static IdeAction getHelpAboutAction() {
        return IdeActions.findOrCreateAction(79, "oracle.ide.cmd.AboutCommand", IdeArb.getString(419), IdeMainWindow.ACTION_CATEGORY_HELP, IdeArb.getInteger(420), null, null, true);
    }

    public static IdeAction getGoToDeclarationAction() {
        return IdeActions.findOrCreateAction(Ide.findOrCreateCmdID("ojjb.BrowseSymbol"), null, IdeArb.getString(147), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(148), null, null, true);
    }
}

