/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.OrderedProperties;

public final class PlatformProperties
extends OrderedProperties {
    private static final String PATH = "oracle/ide/resource/";
    private static final String SPECS = "psfiles.properties";
    private static PlatformProperties INSTANCE;
    private boolean _bValid;
    private static URL _forceLoad;
    private static boolean _bTrace;

    private PlatformProperties() {
    }

    public static PlatformProperties getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformProperties();
            INSTANCE.load();
        }
        return INSTANCE.isValid() ? INSTANCE : null;
    }

    public static void setForceLoad(String s) {
        if (s != null && (_forceLoad = URLFactory.newURL((String)s)) == null) {
            _bTrace = true;
        }
    }

    private boolean isValid() {
        return this._bValid;
    }

    private boolean load() {
        this._bValid = false;
        URL url = _forceLoad == null ? this.getPlatformPropertiesURL() : _forceLoad;
        if (url != null) {
            try {
                InputStream is = URLFileSystem.openInputStream((URL)url);
                this.load(is);
                this._bValid = true;
            }
            catch (FileNotFoundException fnf) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this._bValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getPlatformPropertiesURL() {
        URL ret = null;
        InputStream is = null;
        try {
            URL urlSpecs;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null && (urlSpecs = cl.getResource("oracle/ide/resource/psfiles.properties")) != null) {
                is = urlSpecs.openStream();
                String sFileName = this.getPlatformPropertiesName(is);
                if (_bTrace) {
                    System.err.println("Loading platform settings :oracle/ide/resource/" + sFileName);
                }
                if (sFileName != null) {
                    ret = cl.getResource(PATH + sFileName);
                }
            }
        }
        catch (FileNotFoundException fnf) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private String getPlatformPropertiesName(InputStream is) {
        String sRet = null;
        try {
            String sLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while (sRet == null && (sLine = in.readLine()) != null) {
                String sFileName = IdeUtil.getSubString(sLine = IdeUtil.getSubString(sLine, '#', true), ':', true);
                if (sFileName == null || (sLine = IdeUtil.getSubString(sLine, ':', false)) == null) continue;
                StringTokenizer st = new StringTokenizer(sLine, ",");
                boolean bAllGood = true;
                while (bAllGood && st.hasMoreTokens()) {
                    boolean bValidSpec = false;
                    String sSpec = st.nextToken();
                    String sKey = IdeUtil.getSubString(sSpec, '=', true);
                    String sValue = IdeUtil.getSubString(sSpec, '=', false);
                    if (sKey != null && sValue != null) {
                        sKey = IdeUtil.removeChars(sKey, " ");
                        sValue = IdeUtil.removeChars(sValue, " ");
                        String sSystemValue = System.getProperty(sKey);
                        if (sSystemValue != null) {
                            sSystemValue = IdeUtil.removeChars(sSystemValue, " ");
                            bValidSpec = true;
                            if (!sValue.equals(sSystemValue)) {
                                bAllGood = false;
                            }
                        }
                    }
                    if (bValidSpec) continue;
                    bAllGood = false;
                }
                if (!bAllGood) continue;
                sRet = sFileName;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sRet;
    }
}

