/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.config.ExtensionSettingsPage;
import oracle.ide.config.SettingsUIHook;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.ProvidesDebugInformation;
import oracle.ide.panels.ProvidesSearchTags;
import oracle.ide.panels.Traversable;

final class ExtensionNavigable
extends Navigable
implements ProvidesSearchTags,
ProvidesDebugInformation {
    private ExtensionSettingsPage _page = null;

    protected ExtensionNavigable() {
    }

    ExtensionNavigable(ExtensionSettingsPage page) {
        super(page.getLabel());
        this._page = page;
        String customizedTopic = SettingsUIRegistry.getCustomizations().getHelpTopicId(page.getIdPath());
        if (customizedTopic != null) {
            this.setHelpID(customizedTopic);
        }
    }

    ExtensionSettingsPage getPage() {
        return this._page;
    }

    protected Navigable[] getChildNavigables() {
        SettingsUIHook hook;
        ArrayList<Navigable> navigables = new ArrayList<Navigable>();
        Navigable[] superNavigables = super.getChildNavigables();
        if (superNavigables != null) {
            navigables.addAll(Arrays.asList(superNavigables));
        }
        if ((hook = (SettingsUIHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUIHook.ELEMENT)) != null) {
            Collection<String> hiddenPages = SettingsUIRegistry.getCustomizations().getHiddenPages();
            Collection<ExtensionSettingsPage> pages = hook.getExtensionSettingsUI().getChildren(this._page);
            if (!pages.isEmpty()) {
                for (ExtensionSettingsPage page : pages) {
                    if (hiddenPages.contains(page.getIdPath())) continue;
                    navigables.add(new ExtensionNavigable(page));
                }
            }
        }
        return navigables.toArray(new Navigable[navigables.size()]);
    }

    protected Traversable newTraversable() {
        return this._page.newTraversable();
    }

    public Object copyTo(Object target) {
        ExtensionNavigable copy = target != null ? (ExtensionNavigable)((Object)target) : new ExtensionNavigable();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ExtensionNavigable copy) {
        super.copyToImpl((Navigable)copy);
        copy._page = this._page;
    }

    public Collection<String> searchTags() {
        return new HashSet<String>(Arrays.asList(this._page.getSearchTags().split(",")));
    }

    public String debugInformation() {
        return String.format("id: %s traversableClass: %s", this._page.getId(), this._page.getTraversableClassAsString());
    }
}

