/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.config.RegisteredDynamicNode;
import oracle.ide.dialogs.filter.ExcludeFilterSettings;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class DocumentExtensions
implements Copyable {
    public static final String KEY_SETTINGS = "document-extensions-options";
    private Map _documentMap;
    private ExcludeFilterSettings _excludeFilterSettings;
    private Map _defaultEditorMap;
    private Map _associationMap;
    private Map _hiddenMap = new HashMap();
    private final Map<NodeExtensionKey, Reference<Set<String>>> _keyToWeakNodeExtensionSetMap = new HashMap<NodeExtensionKey, Reference<Set<String>>>();
    private boolean _cacheEnabled = true;

    void setCacheEnabled(boolean cacheEnabled) {
        this._cacheEnabled = cacheEnabled;
    }

    public DocRecord[] getUserExtensionList() {
        return this.getDocuments().toArray(new DocRecord[0]);
    }

    public void setUserExtensionList(DocRecord[] records) {
        if (records == null) {
            return;
        }
        this._setUserExtensionList0(records);
    }

    private void _setUserExtensionList0(final DocRecord[] records) {
        if (Ide.isStarting()) {
            Ide.addIdeListener(new IdeAdapter(){

                @Override
                public void addinsLoaded(IdeEvent e) {
                    DocumentExtensions.this._setUserExtensionList1(records);
                    Ide.removeIdeListener(this);
                }
            });
            return;
        }
        this._setUserExtensionList1(records);
    }

    private void _setUserExtensionList1(DocRecord[] records) {
        this.initDocumentMap();
        for (int i = 0; i < records.length; ++i) {
            DocRecord docRecord = (DocRecord)this._documentMap.get(records[i].getDocClass());
            if (docRecord == null) {
                this._documentMap.put(records[i].getDocClass(), records[i]);
                continue;
            }
            for (ExtInfo extInfo : records[i].getUserExtensions()) {
                ExtInfo createdExtInfo = docRecord.addUserExtension(extInfo.getExtension());
                createdExtInfo.setLocked(extInfo.isLocked());
            }
        }
        this.mapExtensionsToClasses(records);
    }

    void mapExtensionsToClasses(DocRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            DocRecord record = records[i];
            List extensions = record.getUserExtensions();
            for (int j = 0; j < extensions.size(); ++j) {
                ExtInfo info = (ExtInfo)extensions.get(j);
                Class docClass = record.getDocClass();
                if (docClass == null || docClass == RegisteredDynamicNode.class) continue;
                Recognizer.mapExtensionToClass(info.getExtension(), docClass);
            }
        }
    }

    public ExcludeFilterSettings getExcludeFilterSettings() {
        return this._excludeFilterSettings;
    }

    public void setExcludeFilterSettings(ExcludeFilterSettings settings) {
        this._excludeFilterSettings = settings;
    }

    public Map getExtensionToContentTypeMap() {
        HashMap contentTypeMap = new HashMap();
        this.getExtensionToContentTypeMapImpl(contentTypeMap);
        return contentTypeMap;
    }

    public void setExtensionToContentTypeMap(final Map contentTypeMap) {
        if (!Ide.isStarting()) {
            this.setExtensionToContentTypeMapImpl(contentTypeMap);
        } else {
            Ide.addIdeListener(new IdeAdapter(){

                @Override
                public void addinsLoaded(IdeEvent e) {
                    DocumentExtensions.this.setExtensionToContentTypeMapImpl(contentTypeMap);
                    Ide.removeIdeListener(this);
                }
            });
        }
    }

    public Map getDefaultEditorMap() {
        return this._defaultEditorMap;
    }

    public void setDefaultEditorMap(Map defaultEditorMap) {
        this._defaultEditorMap = defaultEditorMap;
    }

    public Map getAssociationMap() throws TransientMarker {
        return this._associationMap;
    }

    public void setAssociationMap(Map associationMap) {
        this._associationMap = associationMap;
    }

    public void _setDocumentMap(Map documentMap) {
        this._documentMap = Collections.synchronizedMap(documentMap);
    }

    public Map _getDocumentMap() {
        this.initDocumentMap();
        return new HashMap(this._documentMap);
    }

    private Map getDocumentMap() {
        if (Ide.isStarting()) {
            Map documentMap = Collections.synchronizedMap(new HashMap());
            this.addRecognizerDocuments(documentMap);
            return documentMap;
        }
        this.initDocumentMap();
        return this._documentMap;
    }

    public Collection getDocuments() {
        return this.getDocumentMap().values();
    }

    public Object copyTo(Object target) {
        DocumentExtensions copy = target != null ? (DocumentExtensions)target : new DocumentExtensions();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(DocumentExtensions copy) {
        this.initDocumentMap();
        if (copy._documentMap == null) {
            copy._documentMap = Collections.synchronizedMap(new HashMap());
        }
        ModelUtil.deepCopy((Map)this._documentMap, (Map)copy._documentMap);
        copy._hiddenMap = this._hiddenMap;
        copy._defaultEditorMap = this._defaultEditorMap;
        copy._associationMap = this._associationMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocumentExtensions)) {
            return false;
        }
        DocumentExtensions other = (DocumentExtensions)object;
        if (!(this._defaultEditorMap != null ? ((Object)this._defaultEditorMap).equals(other._defaultEditorMap) : other._defaultEditorMap == null)) {
            return false;
        }
        if (!(this._associationMap != null ? ((Object)this._associationMap).equals(other._associationMap) : other._associationMap == null)) {
            return false;
        }
        return this.getDocuments() != null ? ((Object)this.getDocuments()).equals(other.getDocuments()) : other.getDocuments() == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._defaultEditorMap == null ? 0 : ((Object)this._defaultEditorMap).hashCode());
        result = 37 * result + (this._associationMap == null ? 0 : ((Object)this._associationMap).hashCode());
        result = 37 * result + (this.getDocuments() == null ? 0 : ((Object)this.getDocuments()).hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNodeExtensions(Class nodeClass, boolean matchIfEqual) {
        Set<String> nodeExtensions;
        Set<String> nodeExtensionSet;
        NodeExtensionKey nodeExtensionKey;
        block6: {
            boolean matches;
            DocRecord docRecord;
            Class docClass;
            Map documentMap;
            Reference<Set<String>> ref;
            nodeExtensionKey = new NodeExtensionKey(nodeClass, matchIfEqual);
            if (this._cacheEnabled && (ref = this._keyToWeakNodeExtensionSetMap.get(nodeExtensionKey)) != null && (nodeExtensionSet = ref.get()) != null) {
                return nodeExtensionSet;
            }
            nodeExtensions = null;
            Map map = documentMap = this.getDocumentMap();
            synchronized (map) {
                for (DocRecord docRecord2 : documentMap.values()) {
                    boolean matches2;
                    Class docClass2 = docRecord2.getDocClass();
                    if (docClass2 == null || !(matches2 = matchIfEqual ? nodeClass.equals(docClass2) : nodeClass.isAssignableFrom(docClass2)) || (nodeExtensions = this.getNodeExtensions(docRecord2, nodeExtensions)) == null || !matchIfEqual) continue;
                    break block6;
                }
            }
            Iterator i = this._hiddenMap.values().iterator();
            while (!(!i.hasNext() || (docClass = (docRecord = (DocRecord)i.next()).getDocClass()) != null && (matches = matchIfEqual ? nodeClass.equals(docClass) : nodeClass.isAssignableFrom(docClass)) && (nodeExtensions = this.getNodeExtensions(docRecord, nodeExtensions)) != null && matchIfEqual)) {
            }
        }
        nodeExtensionSet = nodeExtensions == null ? Collections.emptySet() : Collections.unmodifiableSet(nodeExtensions);
        this._keyToWeakNodeExtensionSetMap.put(nodeExtensionKey, new WeakReference<Set<String>>(nodeExtensionSet));
        return nodeExtensionSet;
    }

    public Set getNodeExtensions(Class[] nodeClasses, boolean matchIfEqual) {
        HashSet extensions = new HashSet();
        for (int i = 0; i < nodeClasses.length; ++i) {
            extensions.addAll(this.getNodeExtensions(nodeClasses[i], matchIfEqual));
        }
        return Collections.unmodifiableSet(extensions);
    }

    private Set<String> getNodeExtensions(DocRecord docRecord, Set<String> nodeExtensions) {
        List extensionList = docRecord.getExtensions();
        if (!extensionList.isEmpty()) {
            if (nodeExtensions == null) {
                nodeExtensions = new HashSet<String>();
            }
            for (ExtInfo extInfo : extensionList) {
                nodeExtensions.add(URLFileSystem.isLocalFileSystemCaseSensitive() ? extInfo.getExtension() : extInfo.getExtension().toLowerCase());
            }
        }
        return nodeExtensions;
    }

    public DocRecord findDocumentFromExtension(String ext) {
        for (DocRecord dr : this.getDocuments()) {
            if (!dr.isExtensionInUse(ext)) continue;
            return dr;
        }
        for (DocRecord dr : this._hiddenMap.values()) {
            if (!dr.isExtensionInUse(ext)) continue;
            return dr;
        }
        return null;
    }

    private void initDocumentMap() {
        if (this._documentMap == null) {
            this._documentMap = Collections.synchronizedMap(new HashMap());
            this.addRecognizerDocuments(this._documentMap);
        }
    }

    private void addRecognizerDocuments(Map documentMap) {
        Map docMap = Recognizer.getExtensionToClassMap();
        if (docMap == null) {
            return;
        }
        Set entrySet = docMap.entrySet();
        for (Map.Entry entry : entrySet) {
            File ext = (File)entry.getKey();
            Class type = (Class)entry.getValue();
            DocRecord record = (DocRecord)documentMap.get(type);
            if (record == null) {
                DocumentInfo info = Recognizer.getDocumentInfo(type);
                if (info == null) {
                    info = this.defaultInfo(type);
                } else if (!info.isIconSpecified()) {
                    info.setIcon(type);
                }
                record = new DocRecord(type, info);
                if (!info.isHidden()) {
                    documentMap.put(type, record);
                } else if (this._hiddenMap != null) {
                    DocRecord hiddenRec = (DocRecord)this._hiddenMap.get(type);
                    if (hiddenRec != null) {
                        record = hiddenRec;
                    } else {
                        this._hiddenMap.put(type, record);
                    }
                }
            }
            record.addIdeExtension(ext.getName());
        }
    }

    private DocumentInfo defaultInfo(Class type) {
        String name = this.shortLabel(type.getName());
        DocumentInfo defaultDocumentInfo = new DocumentInfo(name);
        defaultDocumentInfo.setIcon(type);
        return defaultDocumentInfo;
    }

    private String shortLabel(String label) {
        int index = label.lastIndexOf(46);
        if (index < 0) {
            return label;
        }
        return label.substring(index + 1, label.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExtensionToContentTypeMapImpl(Map ctMap) {
        Map extensionToContentTypeMap;
        Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
        synchronized (map) {
            for (Map.Entry entry : extensionToContentTypeMap.entrySet()) {
                File fileExtension = (File)entry.getKey();
                ContentType contentType = (ContentType)entry.getValue();
                if (fileExtension == null || contentType == null || ctMap.containsKey(fileExtension.getPath())) continue;
                ctMap.put(fileExtension.getPath(), contentType.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtensionToContentTypeMapImpl(Map ctMap) {
        if (ctMap == null) {
            return;
        }
        for (Map.Entry entry : ctMap.entrySet()) {
            Map extensionToContentTypeMap;
            File fileExtension = Recognizer.sanitizeExtension((String)entry.getKey());
            String contentType = (String)entry.getValue();
            if (fileExtension == null || contentType == null) continue;
            Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
            synchronized (map) {
                extensionToContentTypeMap.put(fileExtension, ContentType.valueOf(contentType));
            }
        }
    }

    public static final DocumentInfo findRecognizerDocumentInfo(Class docClass) {
        return Recognizer.getDocumentInfo(docClass);
    }

    public static final ContentType findContentTypeFromExtension(String ext) {
        ContentType contentType = DocumentExtensions.findRecognizerContentType(ext);
        return contentType != null ? contentType : ContentType.TEXT;
    }

    public static final ContentType findRecognizerContentType(String ext) {
        if (ext != null && ext.length() > 0) {
            return Recognizer.getContentTypeForExtension(ext);
        }
        return null;
    }

    static {
        Recognizer.registerDocumentInfo(RegisteredDynamicNode.class, new DocumentInfo(IdeArb.getString(466)));
    }

    public static class ExtInfo
    implements Copyable {
        private boolean _locked;
        private String _extension;
        private boolean _associated;

        public ExtInfo() {
        }

        public ExtInfo(String extension) {
            this(extension, false);
        }

        public ExtInfo(String extension, boolean locked) {
            this._extension = DocRecord.sanitizeExtensionAsString(extension);
            this._locked = locked;
            this._associated = false;
        }

        public void setLocked(boolean locked) {
            this._locked = locked;
        }

        public boolean isLocked() {
            return this._locked;
        }

        public boolean isAssociated() {
            return this._associated;
        }

        public String getExtension() {
            return this._extension;
        }

        public void setExtension(String extension) {
            this._extension = extension;
        }

        protected void setAssociated(boolean associated) {
            this._associated = associated;
        }

        public Object copyTo(Object target) {
            ExtInfo copy = target != null ? (ExtInfo)target : new ExtInfo();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(ExtInfo copy) {
            copy._extension = this._extension;
            copy._locked = this._locked;
            copy._associated = this._associated;
        }

        public String toString() {
            return this._extension;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((ExtInfo)o);
        }

        protected final boolean equalsImpl(ExtInfo other) {
            return other._extension.equals(this._extension);
        }
    }

    public static class DocRecord
    implements Copyable {
        private Class _docClass;
        private String _docClassName;
        private Icon _icon;
        private DocumentInfo _info;
        private String _label;
        private List _ideExtensions = new ArrayList();
        private List _userExtensions = new ArrayList();
        private boolean _isDocClassInitialized;

        public DocRecord() {
        }

        public DocRecord(Class docClass, DocumentInfo info) {
            this._docClass = docClass;
            this._docClassName = docClass.getName();
            this._info = info;
            if (info != null) {
                this._label = info.getLabel();
            }
            if (this._label == null) {
                this._label = docClass.getName();
            }
        }

        public static String sanitizeExtensionAsString(String extension) {
            return Recognizer.sanitizeExtension(extension).getPath();
        }

        public ExtInfo addIdeExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension, true);
            int index = this._ideExtensions.indexOf(extInfo);
            if (index < 0) {
                this._ideExtensions.add(extInfo);
                return extInfo;
            }
            return (ExtInfo)this._ideExtensions.get(index);
        }

        public ExtInfo addUserExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension, false);
            int index = this._userExtensions.indexOf(extInfo);
            if (index < 0) {
                this._userExtensions.add(extInfo);
                return extInfo;
            }
            return (ExtInfo)this._userExtensions.get(index);
        }

        public ExtInfo removeUserExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension);
            int index = this._userExtensions.indexOf(extInfo);
            if (index < 0) {
                return null;
            }
            extInfo = (ExtInfo)this._userExtensions.get(index);
            this._userExtensions.remove(index);
            return extInfo;
        }

        public Icon getIcon() {
            if (this._info != null) {
                this._icon = this._info.getIcon();
                this._info = null;
            }
            return this._icon;
        }

        public String getLabel() {
            return this._label;
        }

        public Class getDocClass() {
            if (!this._isDocClassInitialized) {
                this._isDocClassInitialized = true;
                try {
                    this._docClass = Class.forName(this._docClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this._docClass;
        }

        public List getExtensions() {
            ArrayList extensions = new ArrayList();
            extensions.addAll(this._userExtensions);
            extensions.addAll(this._ideExtensions);
            return extensions;
        }

        public boolean isExtensionInUse(String ext) {
            return this.getExtensions().contains(new ExtInfo(ext));
        }

        public List getUserExtensions() {
            return new ArrayList(this._userExtensions);
        }

        public void setUserExtensions(List extensions) {
            this._userExtensions = extensions;
        }

        public String getDocClassName() {
            return this._docClassName;
        }

        public void setDocClassName(String docClassName) {
            this._docClassName = docClassName;
        }

        public Object copyTo(Object target) {
            DocRecord copy = target != null ? (DocRecord)target : new DocRecord();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(DocRecord copy) {
            copy._docClass = this._docClass;
            copy._docClassName = this._docClassName;
            copy._icon = this._icon;
            copy._label = this._label;
            copy._info = this._info;
            copy._ideExtensions.clear();
            ModelUtil.deepCopy((List)this._ideExtensions, (List)copy._ideExtensions);
            copy._userExtensions.clear();
            ModelUtil.deepCopy((List)this._userExtensions, (List)copy._userExtensions);
        }

        public String toString() {
            return this._label;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((DocRecord)o);
        }

        protected final boolean equalsImpl(DocRecord other) {
            return other._docClass == this._docClass && ModelUtil.areEqual((Object)other._userExtensions, (Object)this._userExtensions);
        }
    }

    private static final class NodeExtensionKey {
        private final Class m_NodeClass;
        private final boolean m_MatchIfEqual;

        public NodeExtensionKey(Class nodeClass, boolean matchIfEqual) {
            this.m_NodeClass = nodeClass;
            this.m_MatchIfEqual = matchIfEqual;
        }

        public int hashCode() {
            return this.m_NodeClass.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof NodeExtensionKey) {
                NodeExtensionKey aNodeExtensionKey = (NodeExtensionKey)object;
                if (this.m_NodeClass.equals(aNodeExtensionKey.m_NodeClass) && this.m_MatchIfEqual == aNodeExtensionKey.m_MatchIfEqual) {
                    return true;
                }
            }
            return false;
        }
    }
}

