/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.config.DTCache;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.DeleteActionHandler;
import oracle.ide.navigator.DeleteHandlerService;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.RefactorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RemoveFromDiskCommand
extends RemoveFileCommand {
    private boolean _silently = false;
    private static final String ERASE_SAFELY_PREF = "EraseSafely";

    public RemoveFromDiskCommand() {
        super(47, 2);
    }

    public void setSilently(boolean silently) {
        this._silently = silently;
    }

    @Override
    public int doit() throws Exception {
        int ret = 1;
        Context context = this.getContext();
        ArrayList<Element> elements = new ArrayList<Element>();
        boolean areAllLocatables = true;
        Element[] selectedElements = context.getSelection();
        int elementCount = selectedElements.length;
        if (elementCount > 0) {
            ArrayList<URL> urlList = new ArrayList<URL>(elementCount);
            for (int i = 0; i < elementCount; ++i) {
                Element element = selectedElements[i];
                elements.add(element);
                if (element instanceof Locatable) {
                    Locatable locatable = (Locatable)((Object)element);
                    URL url = locatable.getURL();
                    urlList.add(url);
                    continue;
                }
                if (element instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder rdcf = (RelativeDirectoryContextFolder)element;
                    URLPath rootURLs = rdcf.getRootDirectories();
                    String relPath = rdcf.getRelativePath();
                    for (URL rootURL : rootURLs) {
                        URL folderURL = URLFactory.newDirURL((URL)rootURL, (String)relPath);
                        urlList.add(folderURL);
                    }
                    continue;
                }
                areAllLocatables = false;
            }
            if (context.containsProperty(DeleteActionHandler.class.getName())) {
                DeleteActionHandler deleteActionHandler = (DeleteActionHandler)context.getProperty(DeleteActionHandler.class.getName());
                deleteActionHandler.doit();
            } else {
                DeleteActionHandler deleteHandler = DeleteHandlerService.createDeleteHandler(context);
                if (deleteHandler != null) {
                    if (this._silently) {
                        deleteHandler.doit();
                    } else {
                        DeleteActionHandler.DeleteOption deleteOption = deleteHandler.clarifyToDeleteOrToRemoveFromParentContainer((Component)((Object)Ide.getMainWindow()));
                        if (deleteOption.equals((Object)DeleteActionHandler.DeleteOption.EraseFromDisk)) {
                            deleteHandler.doit();
                        } else if (deleteOption.equals((Object)DeleteActionHandler.DeleteOption.RemoveFromParent)) {
                            IdeActions.getFileRemoveFromIDEAction().performAction(context);
                        }
                    }
                } else {
                    String message;
                    URL[] urls = urlList.toArray(new URL[urlList.size()]);
                    boolean canSafeDelete = false;
                    if (areAllLocatables) {
                        RefactorManager refactorManager = RefactorManager.getRefactorManager();
                        boolean bl = canSafeDelete = refactorManager != null && refactorManager.canSafeDelete(context, urls);
                    }
                    if (elements.size() == 1) {
                        Element firstElement = (Element)elements.get(0);
                        String longLabel = firstElement.getLongLabel();
                        message = MessageFormat.format(IdeArb.getString(362), longLabel);
                    } else {
                        message = IdeArb.getString(363);
                    }
                    int answer = 1;
                    if (!this._silently) {
                        answer = this.runDialog(message, canSafeDelete);
                    }
                    switch (answer) {
                        case 1: {
                            Folder ownerFolder = this.findOwner(selectedElements[0], this.context);
                            ret = this.eraseElements(ownerFolder, elements);
                            break;
                        }
                        case 2: {
                            RefactorManager refactorManager = RefactorManager.getRefactorManager();
                            if (!refactorManager.safeDeleteFiles(context, urls)) break;
                            ret = 0;
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected boolean remove(Node node, Folder owner) {
        boolean result = false;
        boolean remove = false;
        if (node.isNew()) {
            remove = true;
        } else if (URLFileSystem.canDelete((URL)node.getURL())) {
            node.delete();
            remove = true;
        }
        if (remove) {
            result = owner != null ? (!owner.containsChild(node) ? true : owner.remove(node)) : true;
            if (result) {
                FileOpenHistory.getInstance().removeHistory(node);
                NodeFactory.uncache(node.getURL());
            }
        }
        return result;
    }

    private int eraseElements(final Folder ownerFolder, ArrayList elements) {
        int elementSize = elements.size();
        final ArrayList<Element> finalFiles = new ArrayList<Element>(elementSize);
        for (int i = 0; i < elementSize; ++i) {
            Element element = (Element)elements.get(i);
            if (!this.canRemove(element, ownerFolder)) continue;
            finalFiles.add(element);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList unremovedFiles = new ArrayList();
                int status = RemoveFromDiskCommand.this.remove(finalFiles, ownerFolder, true, unremovedFiles);
                if (status == 0 && unremovedFiles.size() > 0) {
                    String fileNames = RemoveFromDiskCommand.this.buildFileNamesString(unremovedFiles);
                    String msg = IdeArb.format(360, fileNames);
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(361), null);
                }
            }
        };
        runnable.run();
        return 0;
    }

    private int runDialog(String message, boolean canSafeDelete) {
        boolean confirm;
        int ret = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), message);
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        JCheckBox safeDelete = new JCheckBox();
        DTCache dtCache = Ide.getDTCache();
        if (canSafeDelete) {
            ResourceUtils.resButton((AbstractButton)safeDelete, (String)IdeArb.getString(364));
            boolean eraseSafely = dtCache.getBoolean(ERASE_SAFELY_PREF, true);
            safeDelete.setSelected(eraseSafely);
            panel.add((Component)safeDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
            safeDelete.setEnabled(true);
        }
        if (confirm = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)panel, (String)IdeArb.getString(227), (String)"f1_idederasefromdisk1_html")) {
            if (canSafeDelete) {
                boolean isSafeDelete = safeDelete.isSelected();
                dtCache.putBoolean(ERASE_SAFELY_PREF, isSafeDelete);
                ret = isSafeDelete ? 2 : 1;
            } else {
                ret = 1;
            }
        }
        return ret;
    }

    private static String relativeToProjectRootDirectory(Project proj, URL source) {
        String projectFolderUrl = RemoveFromDiskCommand.projectDirectory(proj);
        String sourceUrl = source.getFile();
        return sourceUrl.length() > projectFolderUrl.length() ? sourceUrl.substring(projectFolderUrl.length()) : "";
    }

    private static String projectDirectory(Project project) {
        String projectUrl = project.getURL().getFile();
        return projectUrl.substring(0, projectUrl.length() - project.getShortLabel().length());
    }

    @Override
    protected UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 47);
        return message;
    }

    @Override
    protected boolean isNeedConfirmClose() {
        return false;
    }
}

