/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;

public class NewWorkspaceCommand
extends Command {
    private static boolean addProject = true;
    private static boolean openNavigator = false;

    public NewWorkspaceCommand() {
        super(0);
    }

    @Override
    public int doit() throws Exception {
        URL wspURL;
        Context cmdContext = this.getContext();
        Workspace newWorkspace = NewWorkspaceCommand.createEmptyWorkspace(cmdContext, wspURL = this.getWorkspaceURL());
        if (newWorkspace != null) {
            if (addProject) {
                NewWorkspaceCommand.createProject(cmdContext, newWorkspace);
            }
            if (openNavigator) {
                Context newContext = new Context(cmdContext);
                newContext.setWorkspace(newWorkspace);
                newContext.setProject(null);
                newContext.setNode(newWorkspace);
                Element[] selection = new Element[]{newWorkspace};
                newContext.setSelection(selection);
                NavigatorWindow.openContextInLastActiveNavigator(newContext);
            }
            return 0;
        }
        return 1;
    }

    public static Project createProject(Context context, Workspace workspace) throws Exception {
        Context newCtx = Context.newIdeContext(workspace);
        newCtx.setView(context.getView());
        newCtx.setWorkspace(workspace);
        newCtx.setProject(null);
        AddinManager addinMgr = AddinManager.getAddinManager();
        String cmdName = addinMgr.getCommand(3, null);
        CommandProcessor cmdProc = CommandProcessor.getInstance();
        Command cmd = CommandProcessor.createCommand(cmdName, newCtx);
        if (cmd == null) {
            return null;
        }
        cmdProc.invoke(cmd);
        return cmd.getContext().getProject();
    }

    public static Workspace createEmptyWorkspace(Context context, URL wspURL) throws IllegalAccessException, InstantiationException {
        return NewWorkspaceCommand.createEmptyWorkspace(Ide.getWorkspaces(), Ide.getDefaultWorkspace(), context, wspURL);
    }

    private static int checkForNoExistingWorkspace(Context context, Workspaces workspaces, URL workspaceUrl) {
        Node workspace = NodeFactory.find(workspaceUrl);
        if (workspace == null) {
            return 0;
        }
        RemoveFileCommand cmd = new RemoveFileCommand();
        cmd.setContext(context);
        ArrayList<Node> files = new ArrayList<Node>(1);
        files.add(workspace);
        return cmd.remove(files, workspaces, true);
    }

    static Workspace createEmptyWorkspace(Workspaces workspaces, Workspace defaultWorkspace, Context context, URL wspURL) throws IllegalAccessException, InstantiationException {
        Workspace newWorkspace;
        if (wspURL == null) {
            return null;
        }
        if (NewWorkspaceCommand.checkForNoExistingWorkspace(context, workspaces, wspURL) != 0) {
            return null;
        }
        if (defaultWorkspace != null) {
            newWorkspace = (Workspace)NodeFactory.clone(defaultWorkspace, wspURL);
            if (newWorkspace == null) {
                return null;
            }
            ProjectVersion.initializeVersions(newWorkspace, WorkspaceMigrator.MIGRATOR_NAME);
        } else {
            newWorkspace = (Workspace)NodeFactory.findOrCreate(Workspace.class, wspURL);
        }
        Iterator<Element> iter = newWorkspace.getChildren();
        while (iter.hasNext()) {
            Element child = iter.next();
            if (!(child instanceof Node)) continue;
            NodeFactory.uncache(((Node)child).getURL());
        }
        newWorkspace.removeAll();
        NewWorkspaceCommand.updateWorkDirectoryAfterCreatingWorkspace(workspaces, wspURL);
        workspaces.add(newWorkspace);
        UpdateMessage.fireChildAdded(workspaces, newWorkspace);
        return newWorkspace;
    }

    private static void updateWorkDirectoryAfterCreatingWorkspace(Workspaces workspaces, URL workspaceUrl) {
        URL workspaceDirUrl = URLFileSystem.getParent((URL)workspaceUrl);
        URL workDirectoryUrl = URLFileSystem.getParent((URL)workspaceDirUrl);
        workspaces.setWorkDirectory(workDirectoryUrl);
    }

    private URL getWorkspaceURL() {
        NewWorkspacePanel wspPanel = new NewWorkspacePanel(true, true, true);
        wspPanel.setAddProject(addProject);
        wspPanel.setOpenNavigator(openNavigator);
        if (wspPanel.runDialog()) {
            addProject = wspPanel.isAddProject();
            openNavigator = wspPanel.isOpenNavigator();
            return wspPanel.getFileURL();
        }
        return null;
    }
}

