/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Ide;
import oracle.ide.cmd.FilesToSaveModelBuilder;
import oracle.ide.cmd.FilesToSaveOnCloseCollector;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.util.Executors;

@ThreadSafe
public class ExitCommand
extends Command {
    public static final String SKIP_SAVE_ALL = "ExitCommand.SKIP_SAVE_ALL";
    public static final String SILENT_SAVE_ALL = "ExitCommand.SILENT_SAVE_ALL";
    private static final Collection<ShutdownHook> _shutdownHooks = new ConcurrentLinkedQueue<ShutdownHook>();
    private static final ConcurrentMap<ExecutorService, ExecutorServiceRecord> _executors = new ConcurrentHashMap<ExecutorService, ExecutorServiceRecord>();

    public ExitCommand() {
        super(4);
    }

    public static void addShutdownHook(ShutdownHook hook) {
        _shutdownHooks.add(hook);
    }

    public static void removeShutdownHook(ShutdownHook hook) {
        _shutdownHooks.remove(hook);
    }

    public static void addExecutorService(ExecutorService executor, String name) {
        ExitCommand.addExecutorService(executor, name, true);
    }

    public static void addExecutorService(ExecutorService executor, String name, boolean immediate) {
        if (executor == null) {
            throw new NullPointerException("null executor");
        }
        if (name == null) {
            throw new NullPointerException("null name");
        }
        _executors.put(executor, new ExecutorServiceRecord(executor, name, immediate));
    }

    public static void removeExecutorService(ExecutorService executor) {
        _executors.remove(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean canShutdown() {
        if (_shutdownHooks.isEmpty()) {
            return true;
        }
        for (ShutdownHook hook : _shutdownHooks) {
            try {
                if (hook.canShutdown()) continue;
                boolean bl = false;
                return bl;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        boolean bl = true;
        return bl;
    }

    /*
     * Exception decompiling
     */
    private void shutdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shutdownExecutorServices() {
        if (_executors.isEmpty()) {
            return;
        }
        for (ExecutorServiceRecord record : _executors.values()) {
            boolean success = false;
            try {
                try {
                    if (record.immediate) {
                        Executors.shutdownNow((ExecutorService)record.executor);
                    } else {
                        Executors.shutdown((ExecutorService)record.executor);
                    }
                    if ((success = record.executor.awaitTermination(5L, TimeUnit.SECONDS)) || record.immediate) continue;
                    Executors.shutdownNow((ExecutorService)record.executor);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
                return;
            }
        }
    }

    @Override
    public int doit() throws Exception {
        if (!this.canShutdown()) {
            return 1;
        }
        View view = (View)this.getData();
        if (view == null) {
            view = Ide.getMainWindow().getIdeMainWindowView();
        }
        boolean skipSaveAll = this.getContext().containsProperty(SKIP_SAVE_ALL);
        boolean silentSaveAll = this.getContext().containsProperty(SILENT_SAVE_ALL);
        this.doSaveAll(skipSaveAll, silentSaveAll);
        ArrayList<Node> sysNodes = new ArrayList<Node>();
        ArrayList<Node> dirtyNodes = new ArrayList<Node>();
        this.collectNodes(sysNodes, dirtyNodes, skipSaveAll);
        boolean[] saveOptions = new boolean[]{true, true};
        CheckBoxListModel listModel = this.doSaveNodes(dirtyNodes, saveOptions, skipSaveAll, silentSaveAll);
        boolean doClose = saveOptions[0];
        boolean saveNone = saveOptions[1];
        if (doClose) {
            this.sanitizeWorkspaces(listModel, saveNone);
            listModel = null;
            listModel = new CheckBoxListModel();
            for (Node node : sysNodes) {
                URL url = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)url, (boolean)false);
                }
                try {
                    node.save();
                }
                catch (Exception e) {
                    listModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)url));
                }
            }
            if (listModel.getSize() > 0) {
                boolean bl = doClose = silentSaveAll ? true : this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(290));
            }
            if (doClose) {
                view.close();
                this.shutdown();
            }
        }
        return doClose ? 0 : 1;
    }

    private CheckBoxListModel doSaveNodes(List<Node> dirtyNodes, boolean[] saveOptions, boolean skipSaveAll, boolean silentSaveAll) {
        if (skipSaveAll) {
            return new CheckBoxListModel();
        }
        FilesToSaveOnCloseCollector collector = FilesToSaveOnCloseCollector.collectFilesToSave(dirtyNodes);
        CheckBoxListModel listModel = FilesToSaveModelBuilder.filesToSave(collector);
        if (listModel.getSize() > 0) {
            int response = silentSaveAll ? 0 : SelectFilesPanel.showDialog(IdeArb.getString(286), IdeArb.format(217, listModel.findTextForElement(0)), IdeArb.getString(220), listModel, true, 1, "f1_idedsavefiles_html", collector.actionDescription());
            switch (response) {
                case 0: {
                    saveOptions[1] = false;
                    List list = listModel.getSelectionList();
                    Iterator iterator = null;
                    if (list != null) {
                        iterator = list.iterator();
                    }
                    listModel = null;
                    listModel = new CheckBoxListModel();
                    while (iterator != null && iterator.hasNext()) {
                        Object next = iterator.next();
                        if (!(next instanceof Node)) continue;
                        Node node = (Node)next;
                        URL url = node.getURL();
                        if (node.isReadOnly()) {
                            URLFileSystem.setReadOnly((URL)url, (boolean)false);
                        }
                        try {
                            node.save();
                        }
                        catch (Exception e) {
                            String pathName = URLFileSystem.getPlatformPathName((URL)url);
                            String label = String.format("%s. (%s)", pathName, e.getMessage());
                            listModel.addElement((Object)node, node.getIcon(), true, true, label);
                        }
                    }
                    if (listModel.getSize() <= 0) break;
                    saveOptions[0] = silentSaveAll ? true : this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(287));
                    break;
                }
                case -1: 
                case 2: {
                    saveOptions[0] = false;
                }
            }
        }
        return listModel;
    }

    private void doSaveAll(boolean skipSaveAll, boolean silentSaveAll) {
        if (skipSaveAll) {
            return;
        }
        if (EnvironOptions.getInstance(Preferences.getPreferences()).getSaveOnDeactivation()) {
            try {
                SaveAllCommand.saveAll(silentSaveAll);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void collectNodes(List<Node> sysNodes, List<Node> dirtyNodes, boolean skipSaveAll) {
        if (skipSaveAll) {
            return;
        }
        Iterator<Node> openNodesIter = NodeFactory.getOpenNodes();
        while (openNodesIter.hasNext()) {
            Node node = openNodesIter.next();
            if (node.isDirty()) {
                if (!(!node.getAttributes().isSet(ElementAttributes.SAVEABLE) || node instanceof Project && ((Project)node).isDefault())) {
                    dirtyNodes.add(node);
                    continue;
                }
                sysNodes.add(node);
                continue;
            }
            if (node instanceof Workspace) {
                try {
                    ((Workspace)node).saveUserProperties();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(node instanceof Project)) continue;
            try {
                ((Project)node).saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean exitWithUnsavedReadOnlyFiles(CheckBoxListModel listModel, String title) {
        int response = SelectFilesPanel.showDialog(title, IdeArb.format(289, listModel.findTextForElement(0)), IdeArb.getString(288), listModel, false, 2, "f1_idedunabletosavefiles_html");
        return response == 0;
    }

    private void sanitizeWorkspaces(CheckBoxListModel listModel, boolean saveNone) {
        if (listModel == null || listModel.getSize() == 0) {
            return;
        }
        Workspaces workspaces = (Workspaces)Ide.getSystem().getChild(Workspaces.class);
        if (workspaces == null) {
            return;
        }
        int numFiles = listModel.getSize();
        for (int i = 0; i < numFiles; ++i) {
            Node node;
            if (!saveNone && listModel.isElementSelected(i) || !(node = (Node)listModel.getUserObjectAt(i)).isOpen() || !(node instanceof Workspace) || !node.isNew()) continue;
            workspaces.remove(node);
        }
    }

    private static final class ExecutorServiceRecord {
        private final ExecutorService executor;
        private final String name;
        private final boolean immediate;

        private ExecutorServiceRecord(ExecutorService executor, String name, boolean immediate) {
            this.executor = executor;
            this.name = name;
            this.immediate = immediate;
        }
    }
}

