/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

final class IdeViewHandler
implements ActiveViewListener,
ViewSelectionListener {
    private transient NavigatorWindow _lastActiveNavigator;
    private static Project _lastActiveProject;

    IdeViewHandler() {
    }

    @Override
    public void activeViewChanged(ActiveViewEvent e) {
        View view;
        View oldview = e.getOldView();
        if (oldview != null) {
            oldview.removeViewSelectionListener(this);
        }
        if ((view = e.getNewView()) == null) {
            view = Ide.getMainWindow().getLastActiveView();
        }
        view.addViewSelectionListener(this);
        Context ctx = view.getContext();
        if (ctx != null && ctx.getWorkspace() != null) {
            IdeViewHandler.activateProjectInWorkspace(ctx.getProject(), ctx.getWorkspace());
        } else {
            IdeViewHandler.activateProjectInWorkspace(Ide.getActiveProject(), Ide.getActiveWorkspace());
        }
        if (!IdeAction.isHandlerInProgress()) {
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_ACTIVE_VIEW_CHANGED);
        }
        if (this._lastActiveNavigator != view && view instanceof NavigatorWindow) {
            this._lastActiveNavigator = (NavigatorWindow)view;
        }
    }

    private static void activateProjectInWorkspace(Project project, Workspace wsp) {
        Workspace activeWsp;
        if (wsp == null && Ide.getActiveWorkspace() != null) {
            return;
        }
        if (project == null && wsp != null) {
            project = wsp.currentActiveProject();
        }
        if ((activeWsp = Ide.getActiveWorkspace()) != wsp) {
            Ide.setActiveWorkspace(wsp);
            activeWsp = wsp;
        }
        Project activeProject = project;
        boolean notifyChange = false;
        if (activeWsp != null) {
            Workspaces workspaces = Ide.getWorkspaces();
            if (workspaces != null && !ModelUtil.areEqual((Object)workspaces.getActiveWorkspaceURL(), (Object)activeWsp.getURL())) {
                workspaces.setActiveWorkspaceURL(activeWsp.getURL());
                notifyChange = true;
            }
            if ((activeProject = activeWsp.currentActiveProject()) != project) {
                activeWsp.setActiveProject(project);
                activeProject = project;
            } else if (activeProject != null && !ModelUtil.areEqual((Object)activeProject.getURL(), (Object)activeWsp.getActiveProjectURL())) {
                activeWsp.setActiveProjectURL(activeProject.getURL());
                notifyChange = true;
            }
        }
        if (notifyChange || _lastActiveProject != activeProject) {
            IdeViewHandler.fireActiveProjectChanged(activeProject, activeWsp);
            _lastActiveProject = activeProject;
        }
    }

    private static void fireActiveProjectChanged(Project project, Workspace workspace) {
        UpdateMessage change = new UpdateMessage(IdeConstants.ACTIVE_PROJECT_CHANGED, null);
        change.getModifyObjects().add(project);
        change.getModifyObjects().add(workspace);
        Ide.getSystem().notifyObservers(Ide.getSystem(), change);
    }

    NavigatorWindow getLastActiveNavigator() {
        return this._lastActiveNavigator;
    }

    @Override
    public void viewSelectionChanged(ViewSelectionEvent e) {
        View view = e.getView();
        if (view == Ide.getMainWindow().getLastActiveView()) {
            Context ctx = view.getContext();
            IdeViewHandler.activateProjectInWorkspace(ctx.getProject(), ctx.getWorkspace());
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_VIEW_SELECTION_CHANGED);
        }
    }
}

