/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.ExitNotAllowedException;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeController;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMacros;
import oracle.ide.IdeMainWindow;
import oracle.ide.JavaVersion;
import oracle.ide.Version;
import oracle.ide.boot.Launcher;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.PlatformProperties;
import oracle.ide.config.Preferences;
import oracle.ide.config.SplashScreenOptions;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.DialogWatcher;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationManager;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.TraceFileSystemAccess;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ideri.util.Product;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.internal.ui.EventThreadHangMonitor;
import oracle.javatools.jndi.LocalInitialContextFactoryBuilder;
import oracle.javatools.jndi.Names;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;

public class IdeCore {
    private static final String APPLICATIONS_FILENAME = "applications.xml";
    private static final Logger LOG = Logger.getLogger(IdeCore.class.getName());
    private static final String INSTALL_PATH = "Ide.InstallPath";
    private final IdeArgs ideArgs;
    private final IdeController _controller;
    private final HashMap cmdTable = new HashMap();
    private final HashMap cmdHash = new HashMap();
    private static int nextUniqueCmd = 87;
    private WaitCursor waitCursor;
    private ActionMap anyActionMap;
    private String oracleHome;
    private String ideHome;
    private String userHome;
    private String trueUserHome;
    private String binDir;
    private String systemDirectory;
    private String productVersion;
    private IdeSettings settings;
    private DTCache dtCache;
    private KeyStrokeContextRegistry keyStrokeContextRegistry;
    private IdeProperties idePropertiesInstance;
    private IdeSystem ideSystem;
    private oracle.ide.model.Preferences preferences;
    private Workspaces workspaces;
    private ComponentVersionManager versionMgr = new ComponentVersionManager();
    private Map _macros;
    private ArrayList _ideListeners;
    private boolean _quitting;
    private boolean _starting;
    private boolean forceInvokeLater;
    private String startupCaption = Version.NAME;
    protected String productID = "oracle.ide";
    private static ThreadLocal<WorkspaceProject> activeWorkspaceProject = new ThreadLocal();
    private static final Log ACTIVE_LOG = new Log("active-override");
    private static final boolean ACTIVE_WORKSPACE_OVERRIDE = !Boolean.getBoolean("ide.disable.active.workspace.override");

    protected IdeCore(IdeArgs ideArgs) {
        this.ideArgs = ideArgs;
        this._controller = new IdeController();
    }

    public void useInvokeLaterForAddinsLoadedEvenThoughHeadless() {
        this.forceInvokeLater = true;
    }

    protected String getSplashScreenFilename() {
        String splashImage = System.getProperty("ide.splash.screen");
        return splashImage != null ? splashImage : "splash.gif";
    }

    protected SecurityManager getSecurityManager() {
        return new NullSecurityManager(){

            public void checkExit(int status) {
                if (Beans.isDesignTime()) {
                    throw new ExitNotAllowedException();
                }
            }

            public ThreadGroup getThreadGroup() {
                return super.getThreadGroup();
            }
        };
    }

    protected AddinManager getAddinManager() {
        return null;
    }

    protected Addin[] createCoreModules() {
        return null;
    }

    protected void initializeLookAndFeel() {
        this.initializePlatformLookAndFeel();
    }

    private void initializePlatformLookAndFeel() {
        try {
            try {
                Class<?> cls = Class.forName("oracle.bali.ewt.olaf2.OracleLookAndFeel");
                UIManager.setLookAndFeel(cls.getName());
            }
            catch (Exception e) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IdeArgs getIdeArgs() {
        return this.ideArgs;
    }

    protected boolean isHeadless() {
        return !this.ideArgs.getCreateUI();
    }

    Controller getController() {
        return this._controller;
    }

    protected String getProductID() {
        return this.productID;
    }

    String getProductVersion() {
        return this.productVersion;
    }

    String getBinDirectory() {
        return this.binDir;
    }

    String getHomeDirectory() {
        return this.ideHome;
    }

    String getOracleHomeDirectory() {
        if (this.oracleHome == null) {
            this.oracleHome = Launcher.getOracleHome();
            if (this.oracleHome == null) {
                File f = new File(this.getHomeDirectory());
                this.oracleHome = f.getParent();
            }
            if (!this.oracleHome.endsWith(File.pathSeparator)) {
                this.oracleHome = this.oracleHome + File.separator;
            }
        }
        return this.oracleHome;
    }

    String getLibDirectory() {
        return this.getHomeDirectory() + "lib" + File.separator;
    }

    String getUserHomeDirectory() {
        return this.userHome;
    }

    String getTrueUserHomeDirectory() {
        return this.trueUserHome;
    }

    String getSystemDirectory() {
        return this.systemDirectory;
    }

    String getWorkDirectory() {
        Workspaces wsps = this.getWorkspaces();
        if (wsps != null && wsps.getWorkDirectory() != null) {
            URL workDirURL = wsps.getWorkDirectory();
            return URLFileSystem.getPlatformPathName((URL)workDirURL) + File.separator;
        }
        return this.getDefaultWorkDirectoryLocation();
    }

    private String getDefaultWorkDirectoryLocation() {
        String defaultLocation = System.getProperty("ide.work.dir");
        if (ModelUtil.hasLength((String)defaultLocation)) {
            if (!(defaultLocation = IdeCore.canonicalize(defaultLocation)).endsWith(File.separator)) {
                defaultLocation = defaultLocation + File.separator;
            }
            defaultLocation = defaultLocation + "mywork";
            defaultLocation = defaultLocation + File.separator;
        } else {
            defaultLocation = this.getHomeDirectory() + "mywork" + File.separator;
        }
        return defaultLocation;
    }

    String getProgramName() {
        return IdeUtil.getProgramName();
    }

    String getProgramShortName() {
        return IdeUtil.getProgramShortName();
    }

    IdeProperties getIdeProperties() {
        return this.idePropertiesInstance;
    }

    protected String getProperty(String key, String def) {
        IdeProperties props = this.getIdeProperties();
        return props != null ? props.getProperty(key, def) : null;
    }

    String setProperty(String key, String value) {
        IdeProperties props = this.getIdeProperties();
        return (String)(props != null ? props.setProperty(key, value) : null);
    }

    protected IdeMainWindow getMainWindow() {
        return (IdeMainWindow)MainWindow.getMainWindow((javax.naming.Context)Names.newInitialContext(), (int)1);
    }

    WaitCursor getWaitCursor() {
        if (this.waitCursor == null) {
            this.waitCursor = new MainWindowWaitCursor((Component)((Object)this.getMainWindow()));
        }
        return this.waitCursor;
    }

    ComponentVersionManager getVersionInfo() {
        return this.versionMgr;
    }

    IdeSettings getSettings() {
        return this.loadIdeSettings();
    }

    KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        if (this.keyStrokeContextRegistry == null) {
            this.keyStrokeContextRegistry = new KeyStrokeContextRegistry();
            this.keyStrokeContextRegistry.addListener(new CollectionListener(){

                @Override
                public void elementAdded(CollectionEvent event) {
                    KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
                    KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
                    kso.addContext(ksc);
                }

                @Override
                public void elementRemoved(CollectionEvent event) {
                    KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
                    KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
                    kso.removeContext(ksc);
                }
            });
        }
        return this.keyStrokeContextRegistry;
    }

    EnvironOptions getEnvironOptions() {
        return EnvironOptions.getInstance(Preferences.getPreferences());
    }

    DTCache getDTCache() {
        if (this.dtCache == null) {
            this.dtCache = new DTCache();
            this.dtCache.load();
        }
        return this.dtCache;
    }

    protected URL productSystemDirectory() {
        return ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this.getProductID());
    }

    IdeSystem getSystem() {
        if (this.ideSystem == null) {
            URL systemDir = this.productSystemDirectory();
            URL url = URLFactory.newURL((URL)systemDir, (String)"System.sys");
            if (URLFileSystem.exists((URL)url)) {
                this.ideSystem = new IdeSystem(url);
            } else {
                url = URLFactory.newURL((URL)systemDir, (String)APPLICATIONS_FILENAME);
                this.ideSystem = new IdeSystem(url);
            }
        }
        return this.ideSystem;
    }

    oracle.ide.model.Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.getSystem().getPreferences();
            if (this.preferences == null) {
                this.preferences = (oracle.ide.model.Preferences)this.getSystem().getChild(oracle.ide.model.Preferences.class);
                if (this.preferences == null) {
                    this.preferences = new oracle.ide.model.Preferences();
                }
                this.getSystem().remove(this.preferences);
                this.getSystem().setPreferences(this.preferences);
            }
        }
        return this.preferences;
    }

    Workspaces getWorkspaces() {
        if (this.isStarting()) {
            // empty if block
        }
        if (this.workspaces == null) {
            this.workspaces = (Workspaces)this.getSystem().getChild(Workspaces.class);
            if (this.workspaces == null) {
                this.workspaces = new Workspaces();
            }
        }
        return this.workspaces;
    }

    void addIdeListener(IdeListener l) {
        if (this._ideListeners == null) {
            this._ideListeners = new ArrayList(2);
        }
        this._ideListeners.add(l);
    }

    void removeIdeListener(IdeListener l) {
        if (this._ideListeners != null) {
            this._ideListeners.remove(l);
        }
    }

    InputMap getIdeInputMap() {
        return this.getMainWindow().getInputMap();
    }

    ActionMap getIdeActionMap() {
        IdeMainWindow mainWindow = this.getMainWindow();
        if (mainWindow == null) {
            if (this.anyActionMap == null) {
                this.anyActionMap = new ActionMap();
            }
            return this.anyActionMap;
        }
        return mainWindow.getActionMap();
    }

    boolean isQuitting() {
        return this._quitting;
    }

    boolean isStarting() {
        return this._starting;
    }

    int createCmdID(String commandName) {
        return this.createCmdID(-1, commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createCmdID(int nCmdID, String commandName) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            if (nCmdID == -1) {
                nCmdID = ++nextUniqueCmd;
            }
            Integer cmdID = nCmdID;
            this.cmdTable.put(cmdID, commandName);
            this.cmdHash.put(commandName, cmdID);
        }
        return nCmdID;
    }

    int findOrCreateCmdID(String commandName) {
        return this.findOrCreateCmdID(-1, commandName);
    }

    private int findOrCreateCmdID(int nCmdID, String commandName) {
        Integer cmdID = this.findCmdID(commandName);
        if (cmdID != null) {
            return cmdID;
        }
        return this.createCmdID(nCmdID, commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer findCmdID(String commandName) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            return (Integer)this.cmdHash.get(commandName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findCmdName(int cmdId) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            return (String)this.cmdTable.get(cmdId);
        }
    }

    Map getMacros() {
        if (this._macros == null) {
            String mIdeHome = this.getHomeDirectory();
            String mSystem = this.getSystemDirectory();
            String mUserHome = this.getUserHomeDirectory();
            String mWorkDir = this.getWorkDirectory();
            this._macros = new IdeMacros(mIdeHome, mSystem, mUserHome, mWorkDir).getMap();
        }
        return this._macros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int quit(IdeAction action, Context context) {
        if (this._quitting) {
            return 1;
        }
        this._quitting = true;
        Command command = CommandProcessor.createCommand(action.getCommand(), context);
        command.setData(this.getMainWindow().getIdeMainWindowView());
        int status = 1;
        try {
            status = CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            status = 1;
        }
        finally {
            if (status == 1) {
                this._quitting = false;
            }
        }
        return status;
    }

    void terminate() {
        this.fireIdeEvent(3);
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.activateLayout(null, false);
        }
        SaveAllCommand.saveSystemFiles();
        TraceFileSystemAccess.shutdown();
    }

    void fireIdeEvent(final int nEventID) {
        if (this._ideListeners != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = IdeCore.this._ideListeners.size();
                    if (n > 0) {
                        IdeEvent e = new IdeEvent(nEventID);
                        IdeListener[] l = IdeCore.this._ideListeners.toArray(new IdeListener[n]);
                        for (int i = 0; i < n; ++i) {
                            IdeCore.this.fireIdeEvent(l[i], e);
                        }
                    }
                }
            };
            if ((this.getIdeArgs().getCreateUI() || this.forceInvokeLater) && nEventID != 3) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void fireIdeEvent(IdeListener l, IdeEvent e) {
        switch (e.getID()) {
            case 1: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.addinsLoaded");
                    l.addinsLoaded(e);
                    PerformanceLogger.get().stopTiming("IdeListener.addinsLoaded", l.getClass().getName());
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing addinsLoaded to " + l, exc);
                }
                break;
            }
            case 2: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowOpened");
                    l.mainWindowOpened(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowOpened", l.getClass().getName());
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowOpened to " + l, exc);
                }
                break;
            }
            case 3: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowClosing");
                    l.mainWindowClosing(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowClosing", l.getClass().getName());
                    break;
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowClosing to " + l, exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstallDirectory(File systemDir) {
        BufferedInputStream in = null;
        try {
            Properties ideProps = new Properties();
            File propsFile = new File(systemDir, "ide.properties");
            in = new BufferedInputStream(new FileInputStream(propsFile));
            ideProps.load(in);
            String string = ideProps.getProperty(INSTALL_PATH, null);
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load ide.properties", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static void registerStreamFactory() {
        try {
            URL.setURLStreamHandlerFactory(URLStreamHandlerFactoryQueue.getInstance());
        }
        catch (Error error) {
            // empty catch block
        }
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.startsWith("ide.")) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) {
                            return new URLConnection(u){

                                @Override
                                public void connect() {
                                    this.connected = true;
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return URLFileSystem.openInputStream((URL)this.url);
                                }

                                @Override
                                public OutputStream getOutputStream() throws IOException {
                                    return URLFileSystem.openOutputStream((URL)this.url);
                                }
                            };
                        }
                    };
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startupImpl() {
        if (this._starting) {
            throw new IllegalStateException("IDE is already started");
        }
        this._starting = true;
        IdeCore.registerStreamFactory();
        System.setProperty("ide.build", Version.BUILD_LABEL);
        StartupWindow startupWindow = null;
        try {
            Logger l;
            LogManager lgm;
            URLFileSystemHelper fileSystemHelper;
            if (Version.DEBUG_BUILD != 0 && !Boolean.valueOf(System.getProperty("ide.noassert")).booleanValue()) {
                Thread.currentThread().getContextClassLoader().setPackageAssertionStatus("oracle", true);
            }
            ToStringManager.registerCustomConverter(KeyStroke2String.class);
            Object2Dom.exemptTypeFromIdref(Reference.class);
            Object2Dom.exemptTypeFromIdref(KeyStroke.class);
            this.binDir = IdeCore.canonicalize(System.getProperty("user.dir", "."));
            if (!this.binDir.endsWith(File.separator)) {
                this.binDir = this.binDir + File.separator;
            }
            this.ideHome = IdeCore.canonicalize(System.getProperty("ide.home", null));
            if (!ModelUtil.hasLength((String)this.ideHome)) {
                File f = new File(this.binDir);
                this.ideHome = f.getParent();
            }
            if (!this.ideHome.endsWith(File.separator)) {
                this.ideHome = this.ideHome + File.separator;
            }
            String ideUserDir = System.getProperty("ide.pref.dir");
            this.userHome = IdeCore.canonicalize(ideUserDir);
            if (!ModelUtil.hasLength((String)this.userHome)) {
                ideUserDir = System.getProperty("ide.user.dir");
                this.userHome = IdeCore.canonicalize(ideUserDir);
                if (!ModelUtil.hasLength((String)this.userHome)) {
                    this.userHome = this.ideHome;
                }
            }
            if (!this.userHome.endsWith(File.separator)) {
                this.userHome = this.userHome + File.separator;
            }
            this.trueUserHome = IdeCore.canonicalize(System.getProperty("user.home", null));
            if (!ModelUtil.hasLength((String)this.trueUserHome)) {
                this.trueUserHome = this.userHome;
            } else if (!this.trueUserHome.endsWith(File.separator)) {
                this.trueUserHome = this.trueUserHome + File.separator;
            }
            this.productVersion = System.getProperty("product.version", null);
            if (!ModelUtil.hasLength((String)this.productVersion)) {
                this.productVersion = Version.VER + "." + Version.BUILD_NUM;
            }
            this.systemDirectory = this.userHome + "system" + Version.VER_FULL + File.separator;
            URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
            if (fileHelper != null && (fileSystemHelper = IdeCore.getFileSystemHelper(fileHelper)) != null) {
                URLFileSystem.registerHelper((String)"file", (URLFileSystemHelper)fileSystemHelper);
            }
            boolean userDirectoryCreated = false;
            boolean systemDirectoryCreated = false;
            try {
                URL systemDirectoryURL;
                URL userSettingsDirURL = URLFactory.newFileURL((String)Ide.getUserSettingsDirectory());
                if (!URLFileSystem.exists((URL)userSettingsDirURL)) {
                    URLFileSystem.mkdirs((URL)userSettingsDirURL);
                    userDirectoryCreated = true;
                }
                if (!URLFileSystem.exists((URL)(systemDirectoryURL = URLFactory.newFileURL((String)Ide.getSystemDirectory())))) {
                    URLFileSystem.mkdirs((URL)systemDirectoryURL);
                    systemDirectoryCreated = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (this.ideArgs.getCreateUI()) {
                startupWindow = new StartupWindow(this.startupCaption, null);
                IdeUtil.setStartupWindow(startupWindow);
                String splashFile = this.getSplashScreenFilename();
                if (systemDirectoryCreated) {
                    SplashScreenOptions.freshInstall();
                }
                if (splashFile != null && SplashScreenOptions.getShowSplashScreen() && !Ide.getIdeArgs().hasArg("-nonag")) {
                    int steps = SplashScreenOptions.getSplashScreenCounter();
                    if (steps != -1) {
                        SplashScreen.create((String)(this.binDir + splashFile), (int)steps);
                    } else {
                        SplashScreen.create((String)(this.binDir + splashFile));
                    }
                }
            }
            this.createCmdID(0, "Ide.NEW_WORKSPACE_CMD_ID");
            this.createCmdID(67, "Ide.NEW_VIEW_CMD_ID");
            this.createCmdID(68, "Ide.FREEZE_CMD_ID");
            this.createCmdID(70, "ACTIVATE_LEFT_BUTTON_CMD_ID");
            this.createCmdID(71, "ACTIVATE_RIGHT_BUTTON_CMD_ID");
            this.createCmdID(2, "Ide.NEW_PROJECT_CMD_ID");
            this.createCmdID(3, "Ide.NEW_EMPTY_PROJECT_CMD_ID");
            this.createCmdID(4, "Ide.EXIT_CMD_ID");
            this.createCmdID(5, "Ide.UNDO_CMD_ID");
            this.createCmdID(6, "Ide.REDO_CMD_ID");
            this.createCmdID(65, "Ide.SYSTEM_CMD_ID");
            this.createCmdID(64, "Ide.APPLICATIONS_CMD_ID");
            this.createCmdID(66, "Ide.CONNECTIONS_CMD_ID");
            this.createCmdID(8, "Ide.NEW_CLASS_CMD_ID");
            this.createCmdID(9, "Ide.OPEN_CMD_ID");
            this.createCmdID(10, "Ide.REOPEN_CMD_ID");
            this.createCmdID(11, "Ide.SAVE_CMD_ID");
            this.createCmdID(12, "Ide.SAVE_AS_CMD_ID");
            this.createCmdID(13, "Ide.SAVE_ALL_CMD_ID");
            this.createCmdID(52, "Ide.REVERT_CMD_ID");
            this.createCmdID(14, "Ide.RENAME_CMD_ID");
            this.createCmdID(15, "Ide.PRINTER_SETUP_CMD_ID");
            this.createCmdID(16, "Ide.PRINT_CMD_ID");
            this.createCmdID(17, "Ide.CUT_CMD_ID");
            this.createCmdID(18, "Ide.COPY_CMD_ID");
            this.createCmdID(77, "Ide.COPY_PATH_CMD_ID");
            this.createCmdID(19, "Ide.PASTE_CMD_ID");
            this.createCmdID(78, "Ide.EXTENDED_PASTE_CMD_ID");
            this.createCmdID(20, "Ide.DELETE_CMD_ID");
            this.createCmdID(48, "Ide.CLOSE_NODE_CMD_ID");
            this.createCmdID(51, "Ide.REFRESH_CMD_ID");
            this.createCmdID(21, "Ide.REMOVE_FILE_CMD_ID");
            this.createCmdID(47, "Ide.REMOVE_FROM_DISK_CMD_ID");
            this.createCmdID(22, "Ide.SELECT_ALL_CMD_ID");
            this.createCmdID(23, "Ide.FIND_CMD_ID");
            this.createCmdID(24, "Ide.REPLACE_CMD_ID");
            this.createCmdID(25, "Ide.SEARCH_AGAIN_CMD_ID");
            this.createCmdID(53, "Ide.SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(26, "Ide.INCREMENTAL_SEARCH_FORWARD_CMD_ID");
            this.createCmdID(27, "Ide.INCREMENTAL_SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(28, "Ide.SEARCH_SOURCE_PATH_CMD_ID");
            this.createCmdID(29, "Ide.GOTO_LINE_NUMBER_CMD_ID");
            this.createCmdID(30, "Ide.NEXTMSG_CMD_ID");
            this.createCmdID(31, "Ide.PREVMSG_CMD_ID");
            this.createCmdID(32, "Ide.BROWSE_SYMBOL_CMD_ID");
            this.createCmdID(83, "Ide.BROWSE_SYMBOL_DOC_CMD_ID");
            this.createCmdID(33, "Ide.INSPECTOR_CMD_ID");
            this.createCmdID(34, "Ide.LOG_WINDOW_CMD_ID");
            this.createCmdID(35, "Ide.PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(36, "Ide.TOOLBAR_CMD_ID");
            this.createCmdID(69, "Ide.STATUS_BAR_CMD_ID");
            this.createCmdID(37, "Ide.DEFAULT_PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(38, "Ide.IDE_SETTINGS_CMD_ID");
            this.createCmdID(39, "Ide.CLOSE_ALL_CMD_ID");
            this.createCmdID(44, "Ide.STRUCTURE_CHANGE_CMD_ID");
            this.createCmdID(45, "Ide.PROPERTY_SET_CMD_ID");
            this.createCmdID(49, "Ide.EXPLORER_CMD_ID");
            this.createCmdID(40, "Ide.NEXT_EDITOR_CMD_ID");
            this.createCmdID(41, "Ide.PREV_EDITOR_CMD_ID");
            this.createCmdID(42, "Ide.NEXT_EDITORFRAME_CMD_ID");
            this.createCmdID(43, "Ide.PREV_EDITORFRAME_CMD_ID");
            this.createCmdID(50, "Ide.CONTEXT_MENU_CMD_ID");
            this.createCmdID(54, "Ide.EXPAND_ALL_CMD_ID");
            this.createCmdID(55, "Ide.COLLAPSE_ALL_CMD_ID");
            this.createCmdID(84, "Ide.EXPAND_METHODS_CMD_ID");
            this.createCmdID(85, "Ide.COLLAPSE_METHODS_CMD_ID");
            this.createCmdID(86, "Ide.EXPAND_DOC_CMD_ID");
            this.createCmdID(87, "Ide.COLLAPSE_DOC_CMD_ID");
            this.createCmdID(56, "Ide.PROPERTIES_CMD_ID");
            this.createCmdID(57, "Ide.NAVIGATE_CMD_ID");
            this.createCmdID(58, "Ide.WINDOW_TILE_HORZ_CMD_ID");
            this.createCmdID(59, "Ide.WINDOW_TILE_VERT_CMD_ID");
            this.createCmdID(60, "Ide.WINDOW_CASCADE_CMD_ID");
            this.createCmdID(61, "Ide.WINDOWS_DOT_DOT_DOT_CMD_ID");
            this.createCmdID(73, "Ide.BACK_CMD_ID");
            this.createCmdID(74, "Ide.FORWARD_CMD_ID");
            this.createCmdID(75, "Ide.LAST_EDIT_CMD_ID");
            this.createCmdID(76, "Ide.REPLACE_SOURCE_PATH_CMD_ID");
            this.createCmdID(79, "Ide.ABOUT_CMD_ID");
            this.createCmdID(82, "Ide.DUPLICATE_SELECTION_CMD");
            this.createCmdID(81, "Ide.SELECT_WRAP_CMD");
            String encodingsFileStr = System.getProperty("ide.encodings.file");
            String oracleHome = this.getOracleHomeDirectory();
            File ideBinDir = new File(oracleHome, "ide" + File.separatorChar + "bin");
            File file = new File(ideBinDir, encodingsFileStr != null ? encodingsFileStr : "encodings.xml");
            Encodings.setEncodingsFile((File)file);
            System.setProperty("java.naming.factory.initial", "oracle.javatools.jndi.LocalInitialContextFactory");
            try {
                NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)new LocalInitialContextFactoryBuilder());
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (this.ideArgs.getCreateUI()) {
                this.initializePlatformLookAndFeel();
            }
            PlatformProperties.setForceLoad(this.ideArgs.getPlatformFileName());
            Beans.setDesignTime(true);
            File systemDir = new File(this.getSystemDirectory() + File.separator + "o.ide");
            System.setProperty("ide.firstrun", String.valueOf(!systemDir.exists()));
            boolean inAde = false;
            for (File dir = new File(this.oracleHome); dir != null; dir = dir.getParentFile()) {
                String lowerName = dir.getName().toLowerCase();
                if (!"ade".equals(lowerName) && !".ade".equals(lowerName)) continue;
                inAde = true;
                break;
            }
            System.setProperty("ide.devbuild", String.valueOf(inAde));
            systemDir = new File(this.getSystemDirectory() + File.separator + "diagnostics" + File.separator);
            Diagnostics.setDiagnosticDirectory((File)systemDir);
            this.getAddinManager();
            PerformanceLogger.get().startTiming("init_extensionRegistry", "Initializing extensions...");
            ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
            PerformanceLogger.get().stopTiming("init_extensionRegistry", "Initialized extensions");
            if (Boolean.getBoolean("ide.awthangmonitor")) {
                EventThreadHangMonitor.initMonitoring();
            }
            PerformanceLogger.get().startTiming("init_branding", "Branding...");
            String productId = Product.getProductID();
            if (productId != null && reg.findExtension(productId) == null) {
                Extension ext = reg.findExtensionEvenIfNotLoaded(productId);
                System.err.println("Product extension " + productId + " could not be loaded. The product cannot start.");
                if (ext != null && ext instanceof DefaultExtension) {
                    DefaultExtension defaultExtension = (DefaultExtension)ext;
                    System.err.println("Missing dependencies: ");
                    Collection imports = defaultExtension.getAllImportedExtensions((javax.ide.extension.ExtensionRegistry)ExtensionRegistry.getExtensionRegistry());
                    for (String string : imports) {
                        if (reg.findExtension(string) != null) continue;
                        System.err.println("  " + string);
                    }
                }
                System.err.println("Disabled extensions:");
                for (String id : reg.getDisabledExtensions()) {
                    System.err.println("  " + id + ": " + reg.getNotLoadedReason(id));
                }
                System.exit(1);
            }
            if (this.ideArgs.getCreateUI()) {
                this.installAboutBox();
            }
            PerformanceLogger.get().stopTiming("init_branding", "Branded");
            SplashScreen.log((String)IdeArb.getString(12));
            this.verifyUserHome();
            this.copyExtensionUserData();
            SplashScreen.log((String)IdeArb.getString(13));
            this.loadIdeSettings();
            new NativeHandler().initialize();
            String errorsFromMigration = null;
            MigrationManager migrationManager = MigrationManager.getMigrationManager();
            if (migrationManager != null) {
                errorsFromMigration = migrationManager.migrate(userDirectoryCreated, systemDirectoryCreated);
            }
            SplashScreen.log((String)IdeArb.getString(14));
            this.loadIdeProperties();
            MessageDialog.setPersistence((MessageDialogPersistence)new MessageDialogPersistence(){

                protected File getUserDirectory() {
                    return new File(URLFileSystem.getPlatformPathName((URL)ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.ide")));
                }
            });
            SplashScreen.log((String)IdeArb.getString(11));
            this.verifyJdkVersion();
            SecurityManager securityManager = this.getSecurityManager();
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            }
            SplashScreen.log((String)IdeArb.getString(18));
            oracle.ide.model.Preferences preferences = this.getPreferences();
            if (preferences == null) {
                lgm = LogManager.getLogManager();
                if (lgm != null) {
                    lgm.getMsgPage().log("SEVERE: NULL Preferences during startup");
                } else {
                    l = Logger.getLogger(this.getClass().getName());
                    l.log(Level.SEVERE, "NULL Preferences during startup");
                }
            }
            if (this.ideArgs.getCreateUI()) {
                this.initializeLookAndFeel();
            }
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.initializeCoreModules", "Initializing core modules...");
            SplashScreen.log((String)IdeArb.getString(16));
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.createCoreModules");
            Addin[] coreModules = this.createCoreModules();
            if (this.ideArgs.getCreateUI()) {
                IdeUtil.setMainWindow((JFrame)((Object)this.getMainWindow()));
            }
            this.brandMainWindow();
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.createCoreModules", "Created core modules");
            SplashScreen.log((String)IdeArb.getString(19));
            IdeCore.initializeModules(coreModules);
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.initializeCoreModules", "Initialized core modules");
            this.initProductAndUserAddins();
            if (migrationManager != null) {
                migrationManager.finishMigration();
            }
            if (this.ideArgs.getCreateUI()) {
                FileOpenHistory.getInstance();
                GrabbableFocusManager.install();
                DialogWatcher.install();
                this.getMainWindow().postInitialize(this.ideArgs);
                this.fireIdeEvent(2);
            }
            if (errorsFromMigration != null) {
                lgm = LogManager.getLogManager();
                if (lgm != null) {
                    lgm.getMsgPage().log(errorsFromMigration);
                } else {
                    l = Logger.getLogger(this.getClass().getName());
                    l.log(Level.WARNING, errorsFromMigration);
                }
            }
            this.startupCaption = this.getProductNameFromBranding();
            SwingUtils.setProgramName((String)this.startupCaption);
            String shortName = this.getProductShortNameFromBranding();
            SwingUtils.setProgramShortName((String)shortName);
            boolean showImages = Boolean.getBoolean("ide.wizard.legacyimages");
            if (!showImages) {
                BaseWizard.setImageWizardPageSupported((boolean)false);
            }
            this.defaultMyWorkDirectory();
            this._starting = false;
        }
        catch (Throwable throwable) {
            this._starting = false;
            if (Boolean.getBoolean("ide.dump.classpath")) {
                System.out.println("Full IDE Classpath:");
                HashSet<ClassLoader> seen = new HashSet<ClassLoader>();
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                for (Extension extension : registry.getAllExtensions()) {
                    ClassLoader loader = registry.getClassLoader(extension.getID());
                    if (seen.contains(loader)) continue;
                    seen.add(loader);
                    System.out.println("Loader " + loader + " classpath entries: ");
                    if (loader instanceof PolicyClassLoader) {
                        for (SharedCodeSource sharedCodeSource : ((PolicyClassLoader)loader).getCodeSources(true)) {
                            System.out.println("   " + sharedCodeSource.getLocation());
                        }
                        continue;
                    }
                    if (loader instanceof URLClassLoader) {
                        for (URL uRL : ((URLClassLoader)loader).getURLs()) {
                            System.out.println("   " + uRL);
                        }
                        continue;
                    }
                    System.out.println("   Not URLClassLoader or PolicyClassLoader: " + loader.getClass());
                }
            }
            if (startupWindow != null) {
                IdeUtil.setStartupWindow(null);
                StartupWindow fStartupWindow = startupWindow;
                SwingUtilities.invokeLater(new Runnable(fStartupWindow){
                    final /* synthetic */ JFrame val$fStartupWindow;
                    {
                        this.val$fStartupWindow = jFrame;
                    }

                    @Override
                    public void run() {
                        this.val$fStartupWindow.setVisible(false);
                        this.val$fStartupWindow.dispose();
                    }
                });
            }
            throw throwable;
        }
        if (Boolean.getBoolean("ide.dump.classpath")) {
            System.out.println("Full IDE Classpath:");
            HashSet<ClassLoader> seen = new HashSet<ClassLoader>();
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            for (Extension extension : registry.getAllExtensions()) {
                ClassLoader loader = registry.getClassLoader(extension.getID());
                if (seen.contains(loader)) continue;
                seen.add(loader);
                System.out.println("Loader " + loader + " classpath entries: ");
                if (loader instanceof PolicyClassLoader) {
                    for (SharedCodeSource sharedCodeSource : ((PolicyClassLoader)loader).getCodeSources(true)) {
                        System.out.println("   " + sharedCodeSource.getLocation());
                    }
                    continue;
                }
                if (loader instanceof URLClassLoader) {
                    for (URL uRL : ((URLClassLoader)loader).getURLs()) {
                        System.out.println("   " + uRL);
                    }
                    continue;
                }
                System.out.println("   Not URLClassLoader or PolicyClassLoader: " + loader.getClass());
            }
        }
        if (startupWindow != null) {
            IdeUtil.setStartupWindow(null);
            StartupWindow fStartupWindow = startupWindow;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void defaultMyWorkDirectory() {
        Workspaces ws = this.getWorkspaces();
        if (ws == null) {
            return;
        }
        URL workDir = ws.getWorkDirectory();
        if (workDir != null) {
            return;
        }
        ws.setWorkDirectory(URLFactory.newDirURL((String)this.getDefaultWorkDirectoryLocation()));
    }

    private static URLFileSystemHelper getFileSystemHelper(URLFileSystemHelper helper) {
        String traceFileName = null;
        PrintStream printStream = null;
        IdeArgs ideArgs = Ide.getIdeArgs();
        String[] args = ideArgs.getArgs();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String option = "-TraceFS";
            if (!arg.startsWith("-TraceFS")) continue;
            String optionArg = arg.substring("-TraceFS".length());
            if (optionArg.length() == 0) {
                printStream = System.err;
                break;
            }
            if (optionArg.charAt(0) != '=') break;
            traceFileName = optionArg.substring(1);
            break;
        }
        if (traceFileName == null && printStream == null) {
            return null;
        }
        TraceFileSystemAccess traceFileSystemAccess = traceFileName != null ? TraceFileSystemAccess.start(helper, traceFileName, true) : TraceFileSystemAccess.start(helper, printStream, true);
        return traceFileSystemAccess;
    }

    private static String canonicalize(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            return dir;
        }
        File f = new File(IdeCore.stripDoubleQuotes(dir));
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f.toString();
    }

    private static String stripDoubleQuotes(String dir) {
        String[] tokens;
        StringBuffer sb = new StringBuffer();
        for (String token : tokens = dir.split("[\\\"]")) {
            if ("".equals(token)) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    private void verifyUserHome() {
        File userHomeFile = new File(this.userHome + File.separator).getAbsoluteFile();
        userHomeFile.mkdirs();
        if (!userHomeFile.isDirectory() || !userHomeFile.canWrite()) {
            String msg = IdeArb.format(235, userHomeFile.getAbsolutePath());
            if (Ide.getIdeArgs().getCreateUI()) {
                String title = this.startupCaption;
                MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)msg, (String)title, null);
            } else {
                LOG.log(Level.SEVERE, msg);
            }
            System.exit(1);
        }
    }

    private synchronized IdeSettings loadIdeSettings() {
        if (this.settings == null) {
            this.settings = new IdeSettings();
            this.settings.load();
            this.settings.init();
            EnvironOptions opts = this.getEnvironOptions();
            IdeUtil.setIdeEncoding(opts.getEncoding());
            opts.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IdeUtil.setIdeEncoding(IdeCore.this.getEnvironOptions().getEncoding());
                }
            });
            KeyStrokeOptions keyStrokeOptions = this.settings.getKeyStrokeOptions();
            keyStrokeOptions.setKeyboardPanelEventDispatcher(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdeCore.this.fireIdeEvent(4);
                }
            });
        }
        return this.settings;
    }

    private void loadIdeProperties() {
        if (this.idePropertiesInstance == null) {
            this.idePropertiesInstance = new IdeProperties();
            this.idePropertiesInstance.ensureOpen();
            this.idePropertiesInstance.setProperty(INSTALL_PATH, this.binDir);
        }
    }

    private void verifyJdkVersion() {
        JavaVersion javaVersion;
        String showBadJdkWarningProperty = this.getProperty("showBadJdkWarning", Boolean.TRUE.toString());
        String launchedFromJDev = this.getProperty("launched.from.jdev", Boolean.FALSE.toString());
        if (Boolean.valueOf(showBadJdkWarningProperty).booleanValue() && !Boolean.valueOf(launchedFromJDev).booleanValue() && !(javaVersion = new JavaVersion()).isSupported()) {
            if (this.ideArgs.getCreateUI()) {
                if (!Ide.getIdeArgs().hasArg("-nonag")) {
                    SplashScreen.setVisible((boolean)false);
                    final String msg = IdeArb.format(340, javaVersion.currentVersion(), javaVersion.minVersion(), javaVersion.maxVersion());
                    new Object(){

                        public void doit() {
                            String msgId = "oracle.ide.badJdkWarning";
                            String title = IdeCore.this.startupCaption;
                            boolean res = MessageDialog.optionalConfirm((String)"oracle.ide.badJdkWarning", (Component)SwingUtils.getToplevelWindow(), (String)msg, (String)title, null);
                            if (!res) {
                                MessageDialog.getPersistence().setConfirmed("oracle.ide.badJdkWarning", null);
                                System.exit(1);
                            }
                        }
                    }.doit();
                    SplashScreen.setVisible((boolean)true);
                }
            } else {
                String msg = IdeArb.format(341, javaVersion.minVersion(), javaVersion.currentVersion());
                System.err.println(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeModules(Addin[] modules) {
        if (modules != null) {
            for (Addin module : modules) {
                if (module == null) continue;
                try {
                    PerformanceLogger.get().startTiming("oracle.ide.IdeCore.module." + module.getClass().getName());
                    module.initialize();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.module." + module.getClass().getName(), module.getClass().getName());
                }
            }
        }
    }

    protected void initProductAndUserAddins() {
        AddinManager.getAddinManager().initProductAndUserAddins();
        this.fireIdeEvent(1);
    }

    protected void copyExtensionUserData() {
    }

    private void installAboutBox() {
        AboutBoxModel model = new AboutBoxModel();
        model.setProductName(Ide.getProgramName());
        AboutBoxFactory factory = new AboutBoxFactory();
        factory.setModel(model);
        this.installAboutBox(factory);
        AboutBoxFactory.setAboutBoxFactory(factory);
        this.initAboutBoxModel();
    }

    protected void installAboutBox(AboutBoxFactory factory) {
    }

    protected String getProductNameFromBranding() {
        return "";
    }

    protected String getProductShortNameFromBranding() {
        return "";
    }

    protected void initAboutBoxModel() {
    }

    protected void brandMainWindow() {
    }

    WorkspaceProject getActiveWorkspaceProjectOverride() {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            return activeWorkspaceProject.get();
        }
        return null;
    }

    public static void setActiveWorkspaceOverrideEnabled(boolean enabled) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            WorkspaceProject override = activeWorkspaceProject.get();
            if (enabled) {
                ACTIVE_LOG.trace("enabling active workspace override");
                if (override != null) {
                    throw new IllegalStateException("active workspace/project already enabled");
                }
                activeWorkspaceProject.set(new WorkspaceProject());
            } else {
                ACTIVE_LOG.trace("disabling active workspace override");
                if (override == null) {
                    throw new IllegalStateException("active workspace/project override not enabled");
                }
                activeWorkspaceProject.set(null);
            }
        }
    }

    public static void setActiveWorkspaceOverride(Workspace workspace) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            ACTIVE_LOG.trace("overriding workspace to {0}", (Object)workspace);
            WorkspaceProject override = activeWorkspaceProject.get();
            if (override == null) {
                throw new IllegalStateException("active workspace/project override not enabled");
            }
            override.workspace = workspace;
        }
    }

    public static void setActiveProjectOverride(Project project) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            ACTIVE_LOG.trace("overriding project to {0}", (Object)project);
            WorkspaceProject override = activeWorkspaceProject.get();
            if (override == null) {
                throw new IllegalStateException("active workspace/project override not enabled");
            }
            if (project != null && override.workspace == null) {
                throw new IllegalStateException("workspace null");
            }
            override.project = project;
        }
    }

    static class WorkspaceProject {
        Workspace workspace;
        Project project;

        WorkspaceProject() {
        }
    }

    private static final class StartupWindow
    extends JFrame
    implements AWTEventListener {
        private int openChildren = 0;

        StartupWindow(String caption, Image icon) {
            super(caption);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension size = tk.getScreenSize();
            tk.addAWTEventListener(this, 64L);
            this.setIconImage(icon);
            this.setUndecorated(true);
            this.setBounds(size.width / 2, size.height / 2, 0, 0);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
        }

        @Override
        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.dispose();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            block0 : switch (event.getID()) {
                case 200: {
                    Window child = (Window)event.getSource();
                    Window[] children = this.getOwnedWindows();
                    if (children == null) break;
                    for (int i = children.length - 1; i >= 0; --i) {
                        if (child != children[i]) continue;
                        ++this.openChildren;
                        break block0;
                    }
                    break;
                }
                case 202: {
                    Window child = (Window)event.getSource();
                    Window[] children = this.getOwnedWindows();
                    if (children == null) break;
                    for (int i = children.length - 1; i >= 0; --i) {
                        if (child != children[i]) continue;
                        --this.openChildren;
                        break;
                    }
                    if (this.openChildren != 0) break;
                    this.setVisible(false);
                    break;
                }
            }
        }
    }

    private final class MainWindowWaitCursor
    extends WaitCursor {
        MainWindowWaitCursor(Component c) {
            this.attachSuper(this.findRootPaneContainer(c));
        }

        private void attachSuper(RootPaneContainer c) {
            super.attach(c);
        }

        @Deprecated
        public void attach(RootPaneContainer c) {
            this.complain();
            super.attach(c);
        }

        @Deprecated
        public void detach(RootPaneContainer c) {
            if (!Ide.isQuitting()) {
                this.complain();
            }
            super.detach(c);
        }

        private void complain() {
            new IllegalStateException("WARNING: attaching and detaching from the WaitCursor returned by Ide.getWaitCursor() is no longer supported. Instead, clients should create a new WaitCursor instance. The WaitCursor returned by Ide.getWaitCursor should only be used by the IDE's main window.").printStackTrace();
        }
    }
}

