/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.ComponentFocusEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class ComponentFocusTrigger
extends Trigger {
    public ComponentFocusTrigger(TimingController timer, Component source, Trigger.TriggerAction action, ComponentFocusEvent event) {
        this.setupListener(timer, source, action, event);
    }

    public ComponentFocusTrigger(TimingController startTimer, Component source, ComponentFocusEvent event, TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }

    protected void setupListener(TimingController timer, Object source, Trigger.TriggerAction action, TriggerEvent event) {
        try {
            ComponentFocusListener listener = new ComponentFocusListener(timer, action, (ComponentFocusEvent)event);
            this.setupListener(source, listener, "addFocusListener", FocusListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating focus listener for object " + source + ": " + e);
        }
    }

    class ComponentFocusListener
    extends TriggerListener
    implements FocusListener {
        ComponentFocusEvent event;

        protected ComponentFocusListener(TimingController timer, Trigger.TriggerAction action, ComponentFocusEvent event) {
            super(timer, action);
            this.event = event;
        }

        public void focusGained(FocusEvent e) {
            if (this.event == ComponentFocusEvent.FOCUS_IN) {
                this.pullTrigger();
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.event == ComponentFocusEvent.FOCUS_OUT) {
                this.pullTrigger();
            }
        }
    }
}

