/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.common;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.ADACreateNode;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.palette.interactor.DragRectMakeSDMNodeInteractor;
import oracle.diagram.sdm.palette.interactor.MakeSDMNodeInteractor;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultSDMNodeHandler
extends ADACreateNode {
    private final DiagramContext _context;
    private final PaletteItem _item;

    public CreateDefaultSDMNodeHandler(DiagramContext context, PaletteItem item) {
        this._context = context;
        this._item = item;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected final PaletteItem getPaletteItem() {
        return this._item;
    }

    @Override
    protected IlvManager getRoot() {
        return this.getManagerView().getManager();
    }

    @Override
    protected List<IlvGraphic> getValidContexts() {
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext());
        Vector<IlvGraphic> valid = new Vector<IlvGraphic>();
        valid.add((IlvGraphic)this.getRoot());
        if (engine.isDropToGroupEnabled()) {
            IlvSDMModel model = engine.getModel();
            Enumeration e = model.getObjects();
            while (e != null && e.hasMoreElements()) {
                Object obj = e.nextElement();
                this.processPossibleContextObject(engine, model, valid, obj);
            }
        }
        return Collections.unmodifiableList(this.sortByName(valid));
    }

    @Override
    protected boolean createNode(IlvGraphic context) {
        if (context == null || !(context instanceof IlvManager)) {
            return false;
        }
        IlvManagerView view = this.getManagerView();
        IlvPoint location = null;
        Object parent = null;
        if (context == this.getRoot()) {
            location = new IlvPoint((float)(view.getX() + view.getWidth() / 2), (float)(view.getY() + view.getHeight() / 2));
            view.getTransformer().inverse(location);
        } else {
            parent = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext()).getObject(context);
            IlvRect rBB = context.boundingBox();
            location = new IlvPoint((float)rBB.getCenterX(), (float)rBB.getCenterY());
        }
        IlvManagerViewInteractor i = this.getManagerView().getInteractor();
        if (i != null && i instanceof MakeSDMNodeInteractor) {
            ((MakeSDMNodeInteractor)i).createNode(location.x, location.y, parent, false);
            return true;
        }
        if (i != null && i instanceof DragRectMakeSDMNodeInteractor) {
            return ((DragRectMakeSDMNodeInteractor)i).createNode(location.x, location.y, parent, false);
        }
        return false;
    }

    @Override
    protected IlvGraphic getInitialSelection() {
        IlvManager mgr = this.getManagerView().getManager();
        int count = mgr.getSelectedObjectsCount(true);
        if (count == 1) {
            return mgr.getSelectedObjects(true).nextElement();
        }
        return null;
    }

    @Override
    protected String getType() {
        return this.getPaletteItem().getName();
    }

    @Override
    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getDiagramContext(), g, NavigableGraphicPlugin.class);
    }

    @Override
    protected PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getDiagramContext(), g, PresentableGraphicPlugin.class);
    }

    protected boolean isValidContext(IlvGraphic context) {
        IlvManagerViewInteractor i = this.getManagerView().getInteractor();
        if (i != null && i instanceof MakeSDMNodeInteractor) {
            return ((MakeSDMNodeInteractor)i).isValidContext(context);
        }
        return false;
    }

    private void processPossibleContextObject(IlvSDMEngine engine, IlvSDMModel model, Vector<IlvGraphic> valid, Object obj) {
        IlvGraphic graphic = engine.getGraphic(obj, false);
        if (this.isValidContext(graphic)) {
            valid.add(graphic);
        }
        Enumeration e = model.getChildren(obj);
        while (e != null && e.hasMoreElements()) {
            Object child = e.nextElement();
            this.processPossibleContextObject(engine, model, valid, child);
        }
    }
}

