/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.sdm.IlvSDMEngine;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.interaction.SDMEditInteractor;
import oracle.diagram.sdm.interaction.SDMInPlaceEditContext;
import oracle.ide.controller.CommandProcessor;

public class DefaultSDMInPlaceEditPlugin
extends AbstractPlugin
implements InPlaceEditPlugin {
    private final DiagramContext _context;

    public DefaultSDMInPlaceEditPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public boolean performInPlaceEdit(IlvManager mgr, IlvGraphic mainObj, IlvGraphic subObj) {
        IlvGraphic originalGraphic = mainObj;
        if (mainObj != null && mainObj instanceof IlvLabelInterface) {
            IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)mainObj);
            if (engine == null || !engine.getModel().isEditable() || !this.hasSingleSelection(engine)) {
                return false;
            }
            if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
                return false;
            }
            mainObj = engine.getRenderer().getEncapsulatedGraphic(mainObj);
            if (mainObj instanceof IlvLabelInterface && ReadOnlyUtil.checkWritableEdit(this.getDiagramContext(), mainObj)) {
                IlvManagerView view = this.getManagerView();
                SDMInPlaceEditContext context = this.createInPlaceEditContext((IlvGrapher)ManagerUtil.getManager(originalGraphic), originalGraphic);
                SDMEditInteractor i = this.createEditInteractor(context);
                view.pushInteractor((IlvManagerViewInteractor)i);
                return true;
            }
        }
        return false;
    }

    public void performLabelEditAndEndTransaction(Object modelObject) {
        IlvGraphic g;
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getManagerView());
        IlvGraphic originalGraphic = g = engine.getGraphic(modelObject, false);
        if (g != null) {
            g = engine.getRenderer().getEncapsulatedGraphic(g);
            if (g instanceof IlvLabelInterface) {
                final IlvManagerView view = this.getManagerView();
                SDMInPlaceEditContext context = this.createInPlaceEditContext((IlvGrapher)ManagerUtil.getManager(originalGraphic), originalGraphic);
                context.setLocalUndoTransactions(false);
                final SDMEditInteractor edit = this.createEditInteractor(context);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvManagerViewInteractor lastInteractor = view.getInteractor();
                        view.pushInteractor((IlvManagerViewInteractor)edit);
                        DefaultSDMInPlaceEditPlugin.attachUndoTransactionCleanupListener(view, edit, lastInteractor);
                    }
                });
            } else {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    protected static void attachUndoTransactionCleanupListener(final IlvManagerView view, final SDMEditInteractor edit, final IlvManagerViewInteractor current) {
        view.addInteractorListener(new InteractorListener(){

            public void interactorChanged(InteractorChangedEvent event) {
                if (event.getNewValue() == current && event.getOldValue() == edit) {
                    if (edit.getExitStatus().equals((Object)EditInteractor.Status.COMMIT)) {
                        CommandProcessor.getInstance().endTrans();
                    } else {
                        CommandProcessor.getInstance().abortTrans();
                    }
                    view.removeInteractorListener((InteractorListener)this);
                }
            }
        });
    }

    protected SDMInPlaceEditContext createInPlaceEditContext(IlvGrapher grapher, IlvGraphic hit) {
        return new SDMInPlaceEditContext(grapher, hit);
    }

    protected final SDMEditInteractor createEditInteractor(JViewsEditor editor, SDMInPlaceEditContext context) {
        throw new IllegalStateException("should be calling createEditInteractor(SDMInPlaceEditContext)");
    }

    protected SDMEditInteractor createEditInteractor(SDMInPlaceEditContext context) {
        return new SDMEditInteractor(context);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected boolean hasSingleSelection(IlvSDMEngine engine) {
        Enumeration e = engine.getSelectedObjects();
        if (e.hasMoreElements()) {
            e.nextElement();
            return !e.hasMoreElements();
        }
        return false;
    }
}

