/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.action.handler;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMEngineAdjustingCommand;
import oracle.diagram.sdm.undo.SDMRemoveObjectCommand;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.javatools.util.BundleLoader;

public class SDMDeleteHandler
extends AbstractHandler {
    private static final String TRANSACTION_NAME = BundleLoader.getBundle((String)"oracle.diagram.res.UndoResource", (ClassLoader)SDMDeleteHandler.class.getClassLoader()).getString("delete.text");

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == 20) {
            IlvSDMEngine diagramEngine;
            Enumeration selectedObjects;
            if (ReadOnlyUtil.checkWritable(this.getDiagramContext(context)) && (selectedObjects = (diagramEngine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext(context))).getSelectedObjects()).hasMoreElements()) {
                this.delete(diagramEngine, context);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == 20) {
            IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext(context));
            Enumeration e = engine == null ? null : engine.getSelectedObjects();
            action.setEnabled(e == null ? false : e.hasMoreElements());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(IlvSDMEngine diagramEngine, Context context) {
        IlvSDMModel model = diagramEngine.getModel();
        boolean exceptionOccured = false;
        try {
            CommandProcessor.getInstance().beginTrans(TRANSACTION_NAME);
            SDMEngineAdjustingCommand cmd = new SDMEngineAdjustingCommand(diagramEngine, true);
            cmd.setContext(context);
            CommandProcessor.getInstance().invoke((Command)cmd);
            Enumeration selectedObjects = diagramEngine.getSelectedObjects();
            while (selectedObjects.hasMoreElements()) {
                Object obj = selectedObjects.nextElement();
                SDMRemoveObjectCommand removeCommand = new SDMRemoveObjectCommand(model, obj);
                removeCommand.setContext(context);
                CommandProcessor.getInstance().invoke((Command)removeCommand);
                if (model.isLink(obj)) continue;
                this.deleteRelatedLinks(obj, diagramEngine, context);
            }
            Collection linksToDelete = this.findDanglingLinks(diagramEngine);
            for (Object link : linksToDelete) {
                SDMRemoveObjectCommand removeCommand = new SDMRemoveObjectCommand(model, link);
                removeCommand.setContext(context);
                CommandProcessor.getInstance().invoke((Command)removeCommand);
            }
        }
        catch (Exception e) {
            exceptionOccured = true;
        }
        finally {
            try {
                SDMEngineAdjustingCommand cmd = new SDMEngineAdjustingCommand(diagramEngine, false);
                cmd.setContext(context);
                CommandProcessor.getInstance().invoke((Command)cmd);
            }
            catch (Exception e) {}
            if (exceptionOccured) {
                CommandProcessor.getInstance().abortTrans();
            } else {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    private void deleteRelatedLinks(Object node, IlvSDMEngine diagramEngine, Context context) throws Exception {
        IlvSDMModel model = diagramEngine.getModel();
        Enumeration objects = diagramEngine.getAllObjects();
        while (objects.hasMoreElements()) {
            Object obj = objects.nextElement();
            if (!model.isLink(obj)) continue;
            Object fromObject = model.getFrom(obj);
            Object toObject = model.getTo(obj);
            if (fromObject != node && toObject != node) continue;
            SDMRemoveObjectCommand removeCommand = new SDMRemoveObjectCommand(model, obj);
            removeCommand.setContext(context);
            CommandProcessor.getInstance().invoke((Command)removeCommand);
        }
    }

    private Collection findDanglingLinks(IlvSDMEngine diagramEngine) {
        IlvSDMModel model = diagramEngine.getModel();
        LinkedHashSet danglingLinks = new LinkedHashSet();
        Enumeration allObjects = diagramEngine.getAllObjects();
        while (allObjects.hasMoreElements()) {
            Object obj = allObjects.nextElement();
            if (!model.isLink(obj)) continue;
            Object fromObject = model.getFrom(obj);
            Object toObject = model.getTo(obj);
            int numValidConnections = 0;
            Enumeration searchObjects = diagramEngine.getAllObjects();
            while (searchObjects.hasMoreElements()) {
                Object searchObject = searchObjects.nextElement();
                if (!(searchObject != fromObject && searchObject != toObject || danglingLinks.contains(searchObject))) {
                    ++numValidConnections;
                }
                if (numValidConnections != 2) continue;
                break;
            }
            if (numValidConnections >= 2) continue;
            danglingLinks.add(obj);
        }
        return danglingLinks;
    }
}

