/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class DomainPropertyEditorImpl
extends PropertyEditorSupport {
    private final String[] _content;
    private final Object[] _domainValues;

    public DomainPropertyEditorImpl(String[] content, Object[] domainValues) {
        this._content = new String[content.length];
        System.arraycopy(content, 0, this._content, 0, content.length);
        this._domainValues = new Object[domainValues.length];
        System.arraycopy(domainValues, 0, this._domainValues, 0, domainValues.length);
    }

    public DomainPropertyEditorImpl(ResourceBundle rb, String baseKey, Object[] domainValues) {
        ArrayList<String> strings = new ArrayList<String>(32);
        StringBuffer key = new StringBuffer(baseKey.length() + 10);
        int i = 0;
        while (true) {
            try {
                key.replace(0, key.length(), baseKey);
                key.append('.');
                key.append(i);
                key.append(".text");
                String value = rb.getString(key.toString());
                if (value == null) break;
                strings.add(value);
            }
            catch (MissingResourceException mrex) {
                break;
            }
            ++i;
        }
        this._content = strings.toArray(new String[strings.size()]);
        this._domainValues = new Object[domainValues.length];
        System.arraycopy(domainValues, 0, this._domainValues, 0, domainValues.length);
        if (this._content.length != this._domainValues.length) {
            throw new IllegalArgumentException("Number of domain values and NLS values must match");
        }
    }

    @Override
    public String getAsText() {
        Object domainValue = this.getValue();
        for (int i = 0; i < this._domainValues.length; ++i) {
            if (!this._domainValues[i].equals(domainValue)) continue;
            return this.getTags()[i];
        }
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String[] tags = this.getTags();
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(text)) continue;
            this.setValue(this._domainValues[i]);
            return;
        }
        this.setValue(null);
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public String[] getTags() {
        return this._content;
    }

    public Object[] getDomainValues() {
        return this._domainValues;
    }
}

