/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.event;

import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;

public class PreferenceStoreEvent {
    private final PreferenceStore _source;
    private final PreferenceDefinition[] _changed;
    private final Object[] _oldValues;
    private final Object[] _newValues;

    public PreferenceStoreEvent(PreferenceStore source, PreferenceDefinition[] changed, Object[] oldValues, Object[] newValues) {
        this._source = source;
        this._changed = changed;
        this._oldValues = oldValues;
        this._newValues = newValues;
        if (this._changed != null && (this._oldValues == null || this._oldValues.length < this._changed.length || this._newValues == null || this._newValues.length < this._changed.length)) {
            throw new IllegalArgumentException("The lengths of the changed, oldValues, and newValues arrays must be equal");
        }
    }

    public final PreferenceStore getSource() {
        return this._source;
    }

    public final int getChangesCount() {
        return this._changed != null ? this._changed.length : 0;
    }

    public PreferenceDefinition getChangedPreference(int index) {
        this.checkBounds(index);
        return this._changed[index];
    }

    public Object getOldValue(int index) {
        this.checkBounds(index);
        return this._oldValues[index];
    }

    public Object getNewValue(int index) {
        this.checkBounds(index);
        return this._newValues[index];
    }

    public int getIndexOf(PreferenceDefinition pref) {
        if (pref != null) {
            int isize = this.getChangesCount();
            for (int i = 0; i < isize; ++i) {
                if (pref.getRootDefinition() != this.getChangedPreference(i).getRootDefinition()) continue;
                return i;
            }
        }
        return -1;
    }

    protected final void checkBounds(int index) {
        if (index < 0 || index >= this.getChangesCount()) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
    }
}

