/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import ilog.views.IlvManagerView;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.ide.palette2.PaletteItem;

public abstract class PaletteTask {
    private final DiagramContext _context;
    private final PaletteItem _paletteItem;
    private boolean _aborting = false;

    public PaletteTask(DiagramContext context, PaletteItem item) {
        this._context = context;
        this._paletteItem = item;
    }

    public abstract void invoke(boolean var1);

    public abstract void setSticky(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        if (this.isAborting()) {
            return;
        }
        try {
            this._aborting = true;
            this.abortImpl();
        }
        finally {
            this._aborting = false;
        }
    }

    public final boolean isAborting() {
        return this._aborting;
    }

    public final PaletteItem getPaletteItem() {
        return this._paletteItem;
    }

    public final IlvManagerView getManagerView() {
        return this._context.getManagerView();
    }

    public final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected abstract void abortImpl();

    public void finished() {
        PalettePlugin pp;
        if (!this.isAborting() && (pp = PluginUtil.getPlugin(this._context, PalettePlugin.class)) != null) {
            pp.taskFinished(this);
        }
    }
}

