/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.DiagramFrameworkLinkPolicy;
import oracle.diagram.framework.link.policy.InvokablePolicy;
import oracle.diagram.framework.link.policy.SubShapePinLinkPolicy;
import oracle.diagram.framework.transformer.TransformerUtil;

public class PartialOrthogonalLinkPolicy
extends DiagramFrameworkLinkPolicy {
    private double _cachedWidth;
    private double _cachedHeight;

    public PartialOrthogonalLinkPolicy() {
        this.setChildPolicy(null);
    }

    public PartialOrthogonalLinkPolicy(IlvLinkShapePolicy child) {
        SubShapePinLinkPolicy policy = new SubShapePinLinkPolicy();
        if (child != null) {
            policy.setChildPolicy(child);
        }
        this.setChildPolicy((IlvLinkShapePolicy)policy);
    }

    public void afterAdd(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            if (link.getGraphicBag() != null) {
                link.getGraphicBag().applyToObject((IlvGraphic)link, new IlvApplyObject(){

                    public void apply(IlvGraphic graphic, Object obj) {
                        PartialOrthogonalLinkPolicy.this.initPolicy((IlvLinkImage)graphic, false);
                    }
                }, null, true);
            } else {
                this.initPolicy(link, false);
            }
        }
        this.cacheRect(link);
        super.afterAdd(link);
    }

    public void onInstall(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        this.cacheRect(link);
        super.onInstall(link);
    }

    public void afterFromNodeMoved(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && !this.compareRect(link)) {
            this.initPolicy(link, false);
        }
        this.cacheRect(link);
        super.afterFromNodeMoved(link);
    }

    public void afterToNodeMoved(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && !this.compareRect(link)) {
            this.initPolicy(link, false);
        }
        this.cacheRect(link);
        super.afterToNodeMoved(link);
    }

    public void afterMovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, ptIndex, false);
        }
        this.cacheRect(link);
        super.afterMovePoint(link, ptIndex, trans);
    }

    public boolean allowInsertPoint(IlvLinkImage link, int ptIndex, float x, float y, IlvTransformer trans) {
        return super.allowInsertPoint(link, ptIndex, x, y, trans);
    }

    public void afterInsertPoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, ptIndex, false);
        }
        this.cacheRect(link);
        super.afterInsertPoint(link, ptIndex, trans);
    }

    public boolean allowRemovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        return super.allowRemovePoint(link, ptIndex, trans);
    }

    public void afterRemovePoint(IlvLinkImage link, int ptIndex, IlvTransformer trans) {
        super.afterRemovePoint(link, ptIndex, trans);
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        this.cacheRect(link);
    }

    public void afterSetIntermediateLinkPoints(IlvLinkImage link) {
        if (this.isPolicyEnabled(link)) {
            this.initPolicy(link, false);
        }
        super.afterSetIntermediateLinkPoints(link);
    }

    @Override
    public void invoke(IlvLinkImage link) {
        this.initPolicy(link, true);
        IlvLinkShapePolicy child = this.getChildPolicy();
        if (child instanceof InvokablePolicy) {
            ((InvokablePolicy)child).invoke(link);
        }
    }

    public IlvPoint[] getLinkPoints(IlvLinkImage link, IlvTransformer trans) {
        IlvPoint[] points = link.getLinkPoints(trans);
        return points;
    }

    @Override
    protected IlvPoint[] truncateLink(IlvPoint[] points, IlvLinkImage link, IlvTransformer trans, float errorTolerance) {
        return LinkUtil.truncateLink(points, link, trans, errorTolerance);
    }

    private void cacheRect(IlvLinkImage link) {
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        this._cachedWidth = points[points.length - 1].getX() - points[0].getX();
        this._cachedHeight = points[points.length - 1].getY() - points[0].getY();
    }

    private boolean compareRect(IlvLinkImage link) {
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        return this._cachedWidth == points[points.length - 1].getX() - points[0].getX() && this._cachedHeight == points[points.length - 1].getY() - points[0].getY();
    }
}

