/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.javadoc;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.publish.AbstractPublishPlugin;
import oracle.diagram.javadoc.AbstractDiagramJavaDocGenerator;
import oracle.diagram.javadoc.ContentItem;
import oracle.diagram.javadoc.GenerationContext;
import oracle.diagram.javadoc.util.URLUtils;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;

public abstract class AbstractFrameworkDiagramJavaDocGenerator
extends AbstractDiagramJavaDocGenerator {
    protected Collection<ContentItem> generateContentSetURL(final GenerationContext context, ContentSet contentSet, String relPath, final URL url) throws Exception {
        super.generateContentSetURL(context, contentSet, relPath, url);
        URL javadocRoot = context.getOutputDirectory();
        String type = context.getImageSuffix();
        String relativeName = contentSet.toRelativePath(url);
        final String name = URLFileSystem.getName((URL)url);
        URL pkgURL = URLFileSystem.getParent((URL)url);
        String pkgName = contentSet.toRelativePath(pkgURL);
        pkgName = pkgName.replace('/', '.');
        if (pkgName.endsWith(".")) {
            pkgName = pkgName.substring(0, pkgName.length() - 1);
        }
        final URL diagramImage = URLFactory.newURL((URL)javadocRoot, (String)(relativeName + type));
        URL diagramHTML = URLFactory.newURL((URL)javadocRoot, (String)URLUtils.appendSuffix((String)relativeName, (String)".html"));
        final EditorManager editorManager = EditorManager.getEditorManager();
        final JViewsEditor[] editReturn = new JViewsEditor[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                editReturn[0] = (JViewsEditor)editorManager.openDefaultEditorInFrame(url);
            }
        });
        final JViewsEditor editor = editReturn[0];
        View view = editor.getViewWithoutDecoration();
        final IlvManagerView ilvView = ((DiagramView)view).getActiveManagerView();
        DiagramContext dContext = DiagramContext.getDiagramContext(ilvView);
        final AbstractPublishPlugin publisher = new AbstractPublishPlugin(dContext){

            @Override
            protected IlvManagerView createPublishingView(IlvManager mgr) {
                AccessibleManagerView view = new AccessibleManagerView(mgr);
                view.setKeepingAspectRatio(true);
                view.setBackground(Color.WHITE);
                view.setAntialiasing(true);
                return view;
            }
        };
        final DimensionFloat[] dimmRet = new DimensionFloat[1];
        final StringBuffer mapString = new StringBuffer();
        final Exception[] publishException = new Exception[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                IlvGraphicEnumeration graphicsdd = ilvView.getManager().getObjects();
                double minX = Double.MAX_VALUE;
                double minY = Double.MAX_VALUE;
                while (graphicsdd.hasMoreElements()) {
                    IlvGraphic graphic = graphicsdd.nextElement();
                    if (graphic instanceof FakeNode) continue;
                    IlvRect rect = graphic.boundingBox();
                    minX = minX > rect.getX() ? rect.getX() : minX;
                    minY = minY > rect.getY() ? rect.getY() : minY;
                }
                double offsetX = minX - 20.0 - 1.0;
                double offsetY = minY - 20.0 - 1.0;
                String imageMap = AbstractFrameworkDiagramJavaDocGenerator.this.createImageMap(context, ilvView.getManager(), -offsetX, -offsetY);
                if (imageMap != null) {
                    mapString.insert(0, imageMap);
                }
                try {
                    dimmRet[0] = publisher.publishDiagram(diagramImage, null);
                }
                catch (Exception ex) {
                    publishException[0] = ex;
                }
                if (!context.wasEditorAlreadyOpen((Editor)editor)) {
                    EditorManager.getEditorManager().closeEditors(Collections.singletonList(editor));
                }
            }
        });
        if (publishException[0] != null) {
            throw publishException[0];
        }
        OutputStream output = URLFileSystem.openOutputStream((URL)diagramHTML);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(output, context.getEncodingType())));
        this.writeHeader(context, pw, name, relativeName);
        this.writeNavigationBar(context, pw, name, relativeName);
        this.writeBody(context, pw, pkgName, name, diagramImage, (int)Math.ceil(dimmRet[0].width), (int)Math.ceil(dimmRet[0].height), mapString.toString());
        this.writeNavigationBar(context, pw, name, relativeName);
        this.writeFooter(context, pw, name, relativeName);
        pw.flush();
        pw.close();
        final String sectionName = this.getSectionName(context, contentSet, relPath, url);
        final String relURL = URLFileSystem.toRelativeSpec((URL)diagramHTML, (URL)javadocRoot);
        final String packageName = this.getFullyQualifiedPackageName(context, contentSet, relPath, relURL);
        return Arrays.asList(new ContentItem(){

            public String getSection() {
                return sectionName;
            }

            public String getName() {
                return name;
            }

            public String getRelativeURL() {
                return relURL;
            }

            public String getPackageName() {
                return packageName;
            }
        });
    }

    protected String getSectionName(GenerationContext context, ContentSet contentSet, String relPath, URL url) {
        return RESOURCES.getString("AllDiagrams.text");
    }

    protected abstract String createImageMap(GenerationContext var1, IlvManager var2, double var3, double var5);
}

