/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import java.awt.AWTEvent;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractorMoveSelection;
import oracle.diagram.framework.interaction.SelectInteractor;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubSelectableShape;

public class SelectInteractorMoveSelection
extends CoreSelectInteractorMoveSelection {
    public SelectInteractorMoveSelection(SelectInteractor inter) {
        super(inter);
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    @Override
    protected IlvGraphic getHitSubObject(IlvGraphic mainObject, IlvManagerView view, IlvPoint mousePoint) {
        if (mainObject instanceof SubSelectableShape) {
            return SubSelectionManager.getInstance().getSubObject(mainObject, mousePoint, view);
        }
        return null;
    }

    @Override
    protected void highlight(IlvGraphic targetObject, IlvGraphic targetSubObject, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (targetValidity == CoreSelectInteractorMoveSelection.MoveType.SIMPLE_MOVE) {
            super.highlight(targetObject, targetSubObject, targetValidity);
            return;
        }
        if (targetObject != this.getManager()) {
            this.setSelectedMainObject(targetObject, true);
        }
        if (targetSubObject != null) {
            SubSelectionManager.getInstance().select(targetObject, targetSubObject, true, true);
        }
    }

    @Override
    protected void unhighlight(IlvGraphic targetObject, IlvGraphic targetSubObject, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (targetValidity == CoreSelectInteractorMoveSelection.MoveType.SIMPLE_MOVE) {
            super.unhighlight(targetObject, targetSubObject, targetValidity);
            return;
        }
        if (targetObject != this.getManager()) {
            this.setSelectedMainObject(targetObject, false);
        }
        if (targetSubObject != null) {
            SubSelectionManager.getInstance().select(targetObject, targetSubObject, false, true);
        }
    }

    @Override
    protected CoreSelectInteractorMoveSelection.MoveType validateTarget(IlvGraphic hitObject, IlvGraphic hitSubObject, int modifiers) {
        if ((modifiers & 1) != 0) {
            return CoreSelectInteractorMoveSelection.MoveType.MOVE;
        }
        if ((modifiers & 2) != 0) {
            return CoreSelectInteractorMoveSelection.MoveType.COPY;
        }
        if ((modifiers & 8) != 0) {
            return CoreSelectInteractorMoveSelection.MoveType.LINK;
        }
        if (this.hasLeftOriginalContext()) {
            return CoreSelectInteractorMoveSelection.MoveType.MOVE;
        }
        return super.validateTarget(hitObject, hitSubObject, modifiers);
    }

    @Override
    protected void moveComplete(AWTEvent event, IlvGraphic target, IlvGraphic subTarget, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        super.moveComplete(event, target, subTarget, targetValidity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSelectedMainObject(IlvGraphic ilvgraphic, boolean select) {
        IlvManager ilvmanager = (IlvManager)ilvgraphic.getGraphicBag();
        IlvManager ilvmanager1 = this.getManager();
        try {
            if (ilvmanager != ilvmanager1) {
                ilvmanager.setContentsAdjusting(true, true);
                ilvmanager1.setSelectionAdjusting(true);
            }
            ilvmanager.setSelected(ilvgraphic, select, true);
        }
        finally {
            if (ilvmanager != ilvmanager1) {
                ilvmanager1.setSelectionAdjusting(false);
                ilvmanager.setContentsAdjusting(false, true);
            }
        }
    }

    @Override
    protected boolean isMoveAllowed() {
        if (super.isMoveAllowed()) {
            IlvGraphic[] graphics = new IlvGraphic[this.getMovingObjectsCount() + this.getMovingSubObjectsCount()];
            int i = 0;
            IlvGraphicEnumeration e = this.getMovingObjects();
            while (e.hasMoreElements()) {
                graphics[i++] = e.nextElement();
            }
            e = this.getMovingSubObjects();
            while (e.hasMoreElements()) {
                graphics[i++] = e.nextElement();
            }
            return ReadOnlyUtil.checkWritableMoveGraphics(this.getDiagramContext(), graphics);
        }
        return false;
    }
}

